/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.auth.BuiltinUserAuthFactories;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;

public interface ServerAuthenticationManager {
    public static final String MAX_AUTH_REQUESTS = "max-auth-requests";
    public static final int DEFAULT_MAX_AUTH_REQUESTS = 20;
    public static final String WELCOME_BANNER = "welcome-banner";
    public static final String AUTO_WELCOME_BANNER_VALUE = "#auto-welcome-banner";
    public static final String WELCOME_BANNER_LANGUAGE = "welcome-banner-language";
    public static final String DEFAULT_WELCOME_BANNER_LANGUAGE = "en";
    public static final String WELCOME_BANNER_PHASE = "welcome-banner-phase";
    public static final WelcomeBannerPhase DEFAULT_BANNER_PHASE = WelcomeBannerPhase.IMMEDIATE;
    public static final String WELCOME_BANNER_CHARSET = "welcome-banner-charset";
    public static final String AUTH_METHODS = "auth-methods";
    public static final UserAuthPublicKeyFactory DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY = UserAuthPublicKeyFactory.INSTANCE;
    public static final UserAuthGSSFactory DEFAULT_USER_AUTH_GSS_FACTORY = UserAuthGSSFactory.INSTANCE;
    public static final UserAuthPasswordFactory DEFAULT_USER_AUTH_PASSWORD_FACTORY = UserAuthPasswordFactory.INSTANCE;
    public static final UserAuthKeyboardInteractiveFactory DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY = UserAuthKeyboardInteractiveFactory.INSTANCE;

    public List<NamedFactory<UserAuth>> getUserAuthFactories();

    default public String getUserAuthFactoriesNameList() {
        return NamedResource.getNames(this.getUserAuthFactories());
    }

    default public List<String> getUserAuthFactoriesNames() {
        return NamedResource.getNameList(this.getUserAuthFactories());
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> var1);

    default public void setUserAuthFactoriesNameList(String names) {
        this.setUserAuthFactoriesNames(GenericUtils.split((String)names, (char)','));
    }

    default public void setUserAuthFactoriesNames(String ... names) {
        this.setUserAuthFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)result.getParsedFactories(), (String)"No supported cipher factories: %s", (Object[])new Object[]{names});
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((Collection)unsupported), (String)"Unsupported cipher factories found: %s", (Object)unsupported);
        this.setUserAuthFactories(factories);
    }

    public PublickeyAuthenticator getPublickeyAuthenticator();

    public void setPasswordAuthenticator(PasswordAuthenticator var1);

    public PasswordAuthenticator getPasswordAuthenticator();

    public void setPublickeyAuthenticator(PublickeyAuthenticator var1);

    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator();

    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator var1);

    public GSSAuthenticator getGSSAuthenticator();

    public void setGSSAuthenticator(GSSAuthenticator var1);

    public HostBasedAuthenticator getHostBasedAuthenticator();

    public void setHostBasedAuthenticator(HostBasedAuthenticator var1);

    public static List<NamedFactory<UserAuth>> resolveUserAuthFactories(ServerAuthenticationManager manager) {
        if (manager == null) {
            return Collections.emptyList();
        }
        return ServerAuthenticationManager.resolveUserAuthFactories(manager, manager.getUserAuthFactories());
    }

    public static List<NamedFactory<UserAuth>> resolveUserAuthFactories(ServerAuthenticationManager manager, List<NamedFactory<UserAuth>> userFactories) {
        if (GenericUtils.size(userFactories) > 0) {
            return userFactories;
        }
        if (manager == null) {
            return Collections.emptyList();
        }
        ArrayList<NamedFactory<UserAuth>> factories = new ArrayList<NamedFactory<UserAuth>>();
        if (manager.getPasswordAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_PASSWORD_FACTORY);
            factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        } else if (manager.getKeyboardInteractiveAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        }
        if (manager.getPublickeyAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
        }
        if (manager.getGSSAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_GSS_FACTORY);
        }
        return factories;
    }
}

