/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.keyprovider.KeyPairProviderHolder;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KexFactoryManager
extends KeyPairProviderHolder,
SignatureFactoriesManager {
    public List<NamedFactory<KeyExchange>> getKeyExchangeFactories();

    public void setKeyExchangeFactories(List<NamedFactory<KeyExchange>> var1);

    public List<NamedFactory<Cipher>> getCipherFactories();

    default public String getCipherFactoriesNameList() {
        return NamedResource.getNames(this.getCipherFactories());
    }

    default public List<String> getCipherFactoriesNames() {
        return NamedResource.getNameList(this.getCipherFactories());
    }

    public void setCipherFactories(List<NamedFactory<Cipher>> var1);

    default public void setCipherFactoriesNameList(String names) {
        this.setCipherFactoriesNames(GenericUtils.split((String)names, (char)','));
    }

    default public void setCipherFactoriesNames(String ... names) {
        this.setCipherFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setCipherFactoriesNames(Collection<String> names) {
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList(names);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)result.getParsedFactories(), (String)"No supported cipher factories: %s", (Object[])new Object[]{names});
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((Collection)unsupported), (String)"Unsupported cipher factories found: %s", (Object)unsupported);
        this.setCipherFactories(factories);
    }

    public List<NamedFactory<Compression>> getCompressionFactories();

    default public String getCompressionFactoriesNameList() {
        return NamedResource.getNames(this.getCompressionFactories());
    }

    default public List<String> getCompressionFactoriesNames() {
        return NamedResource.getNameList(this.getCompressionFactories());
    }

    public void setCompressionFactories(List<NamedFactory<Compression>> var1);

    default public void setCompressionFactoriesNameList(String names) {
        this.setCompressionFactoriesNames(GenericUtils.split((String)names, (char)','));
    }

    default public void setCompressionFactoriesNames(String ... names) {
        this.setCompressionFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setCompressionFactoriesNames(Collection<String> names) {
        BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList(names);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)result.getParsedFactories(), (String)"No supported compression factories: %s", (Object[])new Object[]{names});
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((Collection)unsupported), (String)"Unsupported compression factories found: %s", (Object)unsupported);
        this.setCompressionFactories(factories);
    }

    public List<NamedFactory<Mac>> getMacFactories();

    default public String getMacFactoriesNameList() {
        return NamedResource.getNames(this.getMacFactories());
    }

    default public List<String> getMacFactoriesNames() {
        return NamedResource.getNameList(this.getMacFactories());
    }

    public void setMacFactories(List<NamedFactory<Mac>> var1);

    default public void setMacFactoriesNameList(String names) {
        this.setMacFactoriesNames(GenericUtils.split((String)names, (char)','));
    }

    default public void setMacFactoriesNames(String ... names) {
        this.setMacFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setMacFactoriesNames(Collection<String> names) {
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList(names);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)result.getParsedFactories(), (String)"No supported MAC factories: %s", (Object[])new Object[]{names});
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((Collection)unsupported), (String)"Unsupported MAC factories found: %s", (Object)unsupported);
        this.setMacFactories(factories);
    }
}

