/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ValidateUtils;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    protected final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private int backlog = 0;

    public Nio2Acceptor(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
        this.backlog = manager.getIntProperty("socket-backlog", 0);
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        AsynchronousChannelGroup group = this.getChannelGroup();
        for (SocketAddress socketAddress : addresses) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Binding Nio2Acceptor to address {}", (Object)socketAddress);
            }
            AsynchronousServerSocketChannel asyncChannel = this.openAsynchronousServerSocketChannel(socketAddress, group);
            AsynchronousServerSocketChannel socket = this.setSocketOptions(asyncChannel);
            socket.bind(socketAddress, this.backlog);
            SocketAddress local = socket.getLocalAddress();
            this.channels.put(local, socket);
            CompletionHandler handler = (CompletionHandler)ValidateUtils.checkNotNull(this.createSocketCompletionHandler(this.channels, socket), (String)"No completion handler created for address=%s", (Object)socketAddress);
            socket.accept(local, handler);
        }
    }

    protected AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousServerSocketChannel.open(group);
    }

    protected CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> createSocketCompletionHandler(Map<SocketAddress, AsynchronousServerSocketChannel> channelsMap, AsynchronousServerSocketChannel socket) throws IOException {
        return new AcceptCompletionHandler(socket);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        Set<SocketAddress> addresses = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", addresses);
        }
        this.unbind(addresses);
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        boolean debugEnabled = this.log.isDebugEnabled();
        boolean traceEnabled = this.log.isTraceEnabled();
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel = this.channels.remove(socketAddress);
            if (channel != null) {
                try {
                    if (traceEnabled) {
                        this.log.trace("unbind({})", (Object)socketAddress);
                    }
                    channel.close();
                }
                catch (IOException e) {
                    this.log.warn("unbind({}) {} while unbinding channel: {}", new Object[]{socketAddress, e.getClass().getSimpleName(), e.getMessage()});
                    if (!debugEnabled) continue;
                    this.log.debug("unbind(" + socketAddress + ") failure details", (Throwable)e);
                }
                continue;
            }
            if (!traceEnabled) continue;
            this.log.trace("No active channel to unbind for {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    protected void preClose() {
        this.unbind();
        super.preClose();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run((Object)this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        Set<SocketAddress> boundAddresses = this.getBoundAddresses();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (SocketAddress address : boundAddresses) {
            AsynchronousServerSocketChannel asyncChannel = this.channels.remove(address);
            if (asyncChannel == null) continue;
            try {
                asyncChannel.close();
                if (!debugEnabled) continue;
                this.log.debug("doCloseImmediately({}) closed channel", (Object)address);
            }
            catch (IOException e) {
                if (!debugEnabled) continue;
                this.log.debug("Exception caught while closing channel of " + address, (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBoundAddresses() + "]";
    }

    protected class AcceptCompletionHandler
    extends Nio2CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        protected final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(AsynchronousSocketChannel result, SocketAddress address) {
            boolean keepAccepting;
            if (!Nio2Acceptor.this.channels.containsKey(address)) {
                if (Nio2Acceptor.this.log.isDebugEnabled()) {
                    Nio2Acceptor.this.log.debug("onCompleted({}) unbound address", (Object)address);
                }
                return;
            }
            Nio2Session session = null;
            Long sessionId = null;
            IoServiceEventListener listener = Nio2Acceptor.this.getIoServiceEventListener();
            try {
                if (listener != null) {
                    SocketAddress localAddress = result.getLocalAddress();
                    SocketAddress remoteAddress = result.getRemoteAddress();
                    listener.connectionAccepted(Nio2Acceptor.this, localAddress, remoteAddress);
                }
                IoHandler handler = Nio2Acceptor.this.getIoHandler();
                Nio2Acceptor.this.setSocketOptions(result);
                session = Objects.requireNonNull(this.createSession(Nio2Acceptor.this, address, result, handler), "No NIO2 session created");
                sessionId = session.getId();
                handler.sessionCreated(session);
                Nio2Acceptor.this.sessions.put(sessionId, session);
                if (session.isClosing()) {
                    try {
                        handler.sessionClosed(session);
                    }
                    finally {
                        Nio2Acceptor.this.unmapSession(sessionId);
                    }
                } else {
                    session.startReading();
                }
                keepAccepting = true;
            }
            catch (Throwable exc) {
                block20: {
                    if (listener != null) {
                        try {
                            SocketAddress localAddress = result.getLocalAddress();
                            SocketAddress remoteAddress = result.getRemoteAddress();
                            listener.abortAcceptedConnection(Nio2Acceptor.this, localAddress, remoteAddress, exc);
                        }
                        catch (Exception e) {
                            if (!Nio2Acceptor.this.log.isDebugEnabled()) break block20;
                            Nio2Acceptor.this.log.debug("onCompleted(" + address + ") listener=" + listener + " ignoring abort event exception", (Throwable)e);
                        }
                    }
                }
                keepAccepting = this.okToReaccept(exc, address);
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        Nio2Acceptor.this.log.warn("onCompleted(" + address + ") Failed (" + t.getClass().getSimpleName() + ") to close accepted connection from " + address + ": " + t.getMessage(), t);
                    }
                }
                Nio2Acceptor.this.unmapSession(sessionId);
            }
            if (keepAccepting) {
                try {
                    this.socket.accept(address, this);
                }
                catch (Throwable exc) {
                    this.failed(exc, address);
                }
            } else {
                Nio2Acceptor.this.log.error("=====> onCompleted({}) no longer accepting incoming connections <====", (Object)address);
            }
        }

        protected Nio2Session createSession(Nio2Acceptor acceptor, SocketAddress address, AsynchronousSocketChannel channel, IoHandler handler) throws Throwable {
            if (Nio2Acceptor.this.log.isTraceEnabled()) {
                Nio2Acceptor.this.log.trace("createNio2Session({}) address={}", (Object)acceptor, (Object)address);
            }
            return new Nio2Session(acceptor, Nio2Acceptor.this.getFactoryManager(), handler, channel);
        }

        @Override
        protected void onFailed(Throwable exc, SocketAddress address) {
            if (this.okToReaccept(exc, address)) {
                try {
                    this.socket.accept(address, this);
                }
                catch (Throwable t) {
                    Nio2Acceptor.this.log.error("Failed (" + t.getClass().getSimpleName() + " to re-accept new connections on " + address + ": " + t.getMessage(), t);
                }
            }
        }

        protected boolean okToReaccept(Throwable exc, SocketAddress address) {
            AsynchronousServerSocketChannel channel = Nio2Acceptor.this.channels.get(address);
            boolean debugEnabled = Nio2Acceptor.this.log.isDebugEnabled();
            if (channel == null) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Caught {} for untracked channel of {}: {}", new Object[]{exc.getClass().getSimpleName(), address, exc.getMessage()});
                }
                return false;
            }
            if (Nio2Acceptor.this.disposing.get()) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Caught {} for tracked channel of {} while disposing: {}", new Object[]{exc.getClass().getSimpleName(), address, exc.getMessage()});
                }
                return false;
            }
            if (debugEnabled) {
                Nio2Acceptor.this.log.debug("Caught {} while accepting incoming connection from {}: {}", new Object[]{exc.getClass().getSimpleName(), address, exc.getMessage()});
            }
            if (Nio2Acceptor.this.log.isTraceEnabled()) {
                Nio2Acceptor.this.log.trace("Incoming connection from " + address + " failure details", exc);
            }
            return true;
        }
    }
}

