/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.SttySupport;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class PtyCapableChannelSession
extends ChannelSession {
    public static final int DEFAULT_COLUMNS_COUNT = 80;
    public static final int DEFAULT_ROWS_COUNT = 24;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    public static final Map<PtyMode, Integer> DEFAULT_PTY_MODES = GenericUtils.mapBuilder().put((Object)PtyMode.ISIG, (Object)1).put((Object)PtyMode.ICANON, (Object)1).put((Object)PtyMode.ECHO, (Object)1).put((Object)PtyMode.ECHOE, (Object)1).put((Object)PtyMode.ECHOK, (Object)1).put((Object)PtyMode.ECHONL, (Object)0).put((Object)PtyMode.NOFLSH, (Object)0).immutable();
    private boolean agentForwarding;
    private boolean usePty;
    private String ptyType;
    private int ptyColumns = 80;
    private int ptyLines = 24;
    private int ptyWidth = 640;
    private int ptyHeight = 480;
    private Map<PtyMode, Integer> ptyModes = new EnumMap<PtyMode, Integer>(PtyMode.class);
    private final Map<String, String> env = new LinkedHashMap<String, String>();

    public PtyCapableChannelSession(boolean usePty) {
        this.usePty = usePty;
        this.ptyType = System.getenv("TERM");
        if (GenericUtils.isEmpty((CharSequence)this.ptyType)) {
            this.ptyType = "dummy";
        }
        this.ptyModes.putAll(DEFAULT_PTY_MODES);
    }

    public void setupSensibleDefaultPty() {
        try {
            if (OsUtils.isUNIX()) {
                this.ptyModes = SttySupport.getUnixPtyModes();
                this.ptyColumns = SttySupport.getTerminalWidth();
                this.ptyLines = SttySupport.getTerminalHeight();
            } else {
                this.ptyType = "windows";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAgentForwarding() {
        return this.agentForwarding;
    }

    public void setAgentForwarding(boolean agentForwarding) {
        this.agentForwarding = agentForwarding;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    public void setUsePty(boolean usePty) {
        this.usePty = usePty;
    }

    public String getPtyType() {
        return this.ptyType;
    }

    public void setPtyType(String ptyType) {
        this.ptyType = ptyType;
    }

    public int getPtyColumns() {
        return this.ptyColumns;
    }

    public void setPtyColumns(int ptyColumns) {
        this.ptyColumns = ptyColumns;
    }

    public int getPtyLines() {
        return this.ptyLines;
    }

    public void setPtyLines(int ptyLines) {
        this.ptyLines = ptyLines;
    }

    public int getPtyWidth() {
        return this.ptyWidth;
    }

    public void setPtyWidth(int ptyWidth) {
        this.ptyWidth = ptyWidth;
    }

    public int getPtyHeight() {
        return this.ptyHeight;
    }

    public void setPtyHeight(int ptyHeight) {
        this.ptyHeight = ptyHeight;
    }

    public Map<PtyMode, Integer> getPtyModes() {
        return this.ptyModes;
    }

    public void setPtyModes(Map<PtyMode, Integer> ptyModes) {
        this.ptyModes = ptyModes == null ? Collections.emptyMap() : ptyModes;
    }

    public void setEnv(String key, String value) {
        this.env.put(key, value);
    }

    public void sendWindowChange(int columns, int lines) throws IOException {
        this.sendWindowChange(columns, lines, this.ptyHeight, this.ptyWidth);
    }

    public void sendWindowChange(int columns, int lines, int height, int width) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWindowChange({}) cols={}, lines={}, height={}, width={}", new Object[]{this, columns, lines, height, width});
        }
        this.ptyColumns = columns;
        this.ptyLines = lines;
        this.ptyHeight = height;
        this.ptyWidth = width;
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putInt((long)this.getRecipient());
        buffer.putString("window-change");
        buffer.putBoolean(false);
        buffer.putInt((long)this.ptyColumns);
        buffer.putInt((long)this.ptyLines);
        buffer.putInt((long)this.ptyHeight);
        buffer.putInt((long)this.ptyWidth);
        this.writePacket(buffer);
    }

    protected void doOpenPty() throws IOException {
        Session session = this.getSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.agentForwarding) {
            if (debugEnabled) {
                this.log.debug("doOpenPty({}) Send agent forwarding request", (Object)this);
            }
            String channelType = session.getStringProperty("ssh-agent-factory-proxy-auth-channel-type", "auth-agent-req@openssh.com");
            Buffer buffer = session.createBuffer((byte)98, 64);
            buffer.putInt((long)this.getRecipient());
            buffer.putString(channelType);
            buffer.putBoolean(false);
            this.writePacket(buffer);
        }
        if (this.usePty) {
            if (debugEnabled) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST pty-req: type={}, cols={}, lines={}, height={}, width={}, modes={}", new Object[]{this, this.ptyType, this.ptyColumns, this.ptyLines, this.ptyHeight, this.ptyWidth, this.ptyModes});
            }
            Buffer buffer = session.createBuffer((byte)98, 127);
            buffer.putInt((long)this.getRecipient());
            buffer.putString("pty-req");
            buffer.putBoolean(false);
            buffer.putString(this.ptyType);
            buffer.putInt((long)this.ptyColumns);
            buffer.putInt((long)this.ptyLines);
            buffer.putInt((long)this.ptyHeight);
            buffer.putInt((long)this.ptyWidth);
            ByteArrayBuffer modes = new ByteArrayBuffer(GenericUtils.size(this.ptyModes) * 5 + 64, false);
            this.ptyModes.forEach((arg_0, arg_1) -> PtyCapableChannelSession.lambda$doOpenPty$0((Buffer)modes, arg_0, arg_1));
            modes.putByte((byte)0);
            buffer.putBytes(modes.getCompactData());
            this.writePacket(buffer);
        }
        if (GenericUtils.size(this.env) > 0) {
            if (debugEnabled) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, this.env);
            }
            for (Map.Entry<String, String> entry : this.env.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Buffer buffer = session.createBuffer((byte)98, key.length() + value.length() + 32);
                buffer.putInt((long)this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(key);
                buffer.putString(value);
                this.writePacket(buffer);
            }
        }
    }

    private static /* synthetic */ void lambda$doOpenPty$0(Buffer modes, PtyMode mode, Integer value) {
        modes.putByte((byte)mode.toInt());
        modes.putInt(value.longValue());
    }
}

