/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.Objects;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractUserAuth
extends AbstractLoggingBean
implements UserAuth {
    private final String name;
    private ClientSession clientSession;
    private String service;

    protected AbstractUserAuth(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty((String)name, (String)"No name");
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    public final String getName() {
        return this.name;
    }

    public String getService() {
        return this.service;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        this.clientSession = Objects.requireNonNull(session, "No client session");
        this.service = ValidateUtils.checkNotNullAndNotEmpty((String)service, (String)"No service");
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        ClientSession session = this.getClientSession();
        String service = this.getService();
        if (buffer == null) {
            return this.sendAuthDataRequest(session, service);
        }
        return this.processAuthDataRequest(session, service, buffer);
    }

    protected abstract boolean sendAuthDataRequest(ClientSession var1, String var2) throws Exception;

    protected abstract boolean processAuthDataRequest(ClientSession var1, String var2, Buffer var3) throws Exception;

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("destroy({})[{}]", (Object)this.getClientSession(), (Object)this.getService());
        }
    }

    public String toString() {
        return this.getName() + ": " + this.getSession() + "[" + this.getService() + "]";
    }
}

