/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractAgentClient
extends AbstractLoggingBean {
    private final Buffer buffer = new ByteArrayBuffer();
    private final SshAgent agent;

    protected AbstractAgentClient(SshAgent agent) {
        this.agent = agent;
    }

    public synchronized void messageReceived(Buffer message) throws IOException {
        this.buffer.putBuffer((Readable)message);
        int avail = this.buffer.available();
        if (avail < 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received message total length ({}) below minimum ({})", (Object)avail, (Object)4);
            }
            return;
        }
        int rpos = this.buffer.rpos();
        int len = this.buffer.getInt();
        this.buffer.rpos(rpos);
        avail = this.buffer.available();
        if (avail < len + 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received request length ({}) below minimum ({})", (Object)avail, (Object)(len + 4));
            }
            return;
        }
        ByteArrayBuffer rep = new ByteArrayBuffer();
        rep.putInt(0L);
        rep.rpos(rep.wpos());
        ByteArrayBuffer req = new ByteArrayBuffer(this.buffer.getBytes());
        int cmd = -1;
        try {
            cmd = req.getUByte();
            this.process(cmd, (Buffer)req, (Buffer)rep);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to handle command={}: {}", new Object[]{e.getClass().getSimpleName(), cmd, e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received command=" + cmd + " handling failure details", (Throwable)e);
            }
            rep.clear();
            rep.putInt(0L);
            rep.rpos(rep.wpos());
            rep.putInt(1L);
            rep.putByte((byte)30);
        }
        this.reply(this.prepare((Buffer)rep));
    }

    protected void process(int cmd, Buffer req, Buffer rep) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("process(cmd={})", (Object)SshAgentConstants.getCommandMessageName(cmd));
        }
        switch (cmd) {
            case 11: {
                List<? extends Map.Entry<PublicKey, String>> keys = this.agent.getIdentities();
                rep.putByte((byte)12);
                rep.putInt((long)keys.size());
                for (Map.Entry entry : keys) {
                    rep.putPublicKey((PublicKey)entry.getKey());
                    rep.putString((String)entry.getValue());
                }
                break;
            }
            case 13: {
                PublicKey signingKey = req.getPublicKey();
                byte[] data = req.getBytes();
                int n = req.getInt();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_SIGN_REQUEST key={}, flags=0x{}, data={}", new Object[]{signingKey.getAlgorithm(), Integer.toHexString(n), BufferUtils.toHex((char)':', (byte[])data)});
                }
                String keyType = ValidateUtils.checkNotNullAndNotEmpty((String)KeyUtils.getKeyType((Key)signingKey), (String)"Cannot resolve key type of %s", (Object)signingKey.getClass().getSimpleName());
                byte[] signature = this.agent.sign(signingKey, data);
                ByteArrayBuffer sig = new ByteArrayBuffer(keyType.length() + signature.length + 64, false);
                sig.putString(keyType);
                sig.putBytes(signature);
                rep.putByte((byte)14);
                rep.putBytes(sig.array(), sig.rpos(), sig.available());
                break;
            }
            case 17: {
                KeyPair keyToAdd = req.getKeyPair();
                String comment = req.getString();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_ADD_IDENTITY comment={}", (Object)comment);
                }
                this.agent.addIdentity(keyToAdd, comment);
                rep.putByte((byte)6);
                break;
            }
            case 18: {
                PublicKey keyToRemove = req.getPublicKey();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_REMOVE_IDENTITY {}", (Object)keyToRemove.getClass().getSimpleName());
                }
                this.agent.removeIdentity(keyToRemove);
                rep.putByte((byte)6);
                break;
            }
            case 19: {
                this.agent.removeAllIdentities();
                rep.putByte((byte)6);
                break;
            }
            default: {
                if (debugEnabled) {
                    this.log.debug("Unknown command: {}", (Object)SshAgentConstants.getCommandMessageName(cmd));
                }
                rep.putByte((byte)30);
            }
        }
    }

    protected Buffer prepare(Buffer buf) {
        int len = buf.available();
        int rpos = buf.rpos();
        int wpos = buf.wpos();
        buf.rpos(rpos - 4);
        buf.wpos(rpos - 4);
        buf.putInt((long)len);
        buf.wpos(wpos);
        return buf;
    }

    protected abstract void reply(Buffer var1) throws IOException;
}

