/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.loader.putty.AbstractPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.PuttyKeyReader;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDSAPuttyKeyDecoder
extends AbstractPuttyKeyDecoder<ECPublicKey, ECPrivateKey> {
    public static final ECDSAPuttyKeyDecoder INSTANCE = new ECDSAPuttyKeyDecoder();

    public ECDSAPuttyKeyDecoder() {
        super(ECPublicKey.class, ECPrivateKey.class, ECCurves.KEY_TYPES);
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(String resourceKey, PuttyKeyReader pubReader, PuttyKeyReader prvReader) throws IOException, GeneralSecurityException {
        ECPoint w;
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchAlgorithmException("ECC not supported for " + resourceKey);
        }
        String keyType = pubReader.readString();
        ECCurves curve = ECCurves.fromKeyType((String)keyType);
        if (curve == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + keyType);
        }
        String encCurveName = pubReader.readString();
        String keyCurveName = curve.getName();
        if (!keyCurveName.equals(encCurveName)) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + keyCurveName + ") vs. encoded one (" + encCurveName + ")");
        }
        byte[] octets = pubReader.read();
        try {
            w = ECCurves.octetStringToEcPoint((byte[])octets);
            if (w == null) {
                throw new InvalidKeySpecException("No public ECPoint generated for curve=" + keyCurveName + " from octets=" + BufferUtils.toHex((char)':', (byte[])octets));
            }
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("Failed (" + e.getClass().getSimpleName() + ") to generate public ECPoint for curve=" + keyCurveName + " from octets=" + BufferUtils.toHex((char)':', (byte[])octets) + ": " + e.getMessage());
        }
        KeyFactory kf = SecurityUtils.getKeyFactory((String)"EC");
        ECParameterSpec paramSpec = curve.getParameters();
        PublicKey pubKey = kf.generatePublic(new ECPublicKeySpec(w, paramSpec));
        BigInteger s = prvReader.readInt();
        PrivateKey prvKey = kf.generatePrivate(new ECPrivateKeySpec(s, paramSpec));
        return Collections.singletonList(new KeyPair(pubKey, prvKey));
    }
}

