/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.impl.AbstractIdentityResourceLoader;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.putty.PuttyKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.putty.PuttyKeyReader;
import org.apache.sshd.common.util.GenericUtils;

public abstract class AbstractPuttyKeyDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractIdentityResourceLoader<PUB, PRV>
implements PuttyKeyPairResourceParser<PUB, PRV> {
    public static final String ENCRYPTION_HEADER = "Encryption";

    protected AbstractPuttyKeyDecoder(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        super(pubType, prvType, names);
    }

    @Override
    public boolean canExtractKeyPairs(String resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        if (!PuttyKeyPairResourceParser.super.canExtractKeyPairs(resourceKey, lines)) {
            return false;
        }
        for (String l : lines) {
            if (!(l = GenericUtils.trimToEmpty((String)l)).startsWith("PuTTY-User-Key-File")) continue;
            int pos = l.indexOf(58);
            if (pos <= 0 || pos >= l.length() - 1) {
                return false;
            }
            Collection supported = this.getSupportedTypeNames();
            String typeValue = l.substring(pos + 1).trim();
            return supported.contains(typeValue);
        }
        return false;
    }

    public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        List<String> pubLines = Collections.emptyList();
        List<String> prvLines = Collections.emptyList();
        String prvEncryption = null;
        int numLines = lines.size();
        block10: for (int index = 0; index < numLines; ++index) {
            String l = lines.get(index);
            int pos = (l = GenericUtils.trimToEmpty((String)l)).indexOf(58);
            if (pos <= 0 || pos >= l.length() - 1) continue;
            String hdrName = l.substring(0, pos).trim();
            String hdrValue = l.substring(pos + 1).trim();
            switch (hdrName) {
                case "Encryption": {
                    if (prvEncryption != null) {
                        throw new StreamCorruptedException("Duplicate " + hdrName + " in" + resourceKey);
                    }
                    prvEncryption = hdrValue;
                    continue block10;
                }
                case "Public-Lines": {
                    pubLines = AbstractPuttyKeyDecoder.extractDataLines(resourceKey, lines, index + 1, hdrName, hdrValue, pubLines);
                    index += pubLines.size();
                    continue block10;
                }
                case "Private-Lines": {
                    prvLines = AbstractPuttyKeyDecoder.extractDataLines(resourceKey, lines, index + 1, hdrName, hdrValue, prvLines);
                    index += prvLines.size();
                    continue block10;
                }
            }
        }
        return this.loadKeyPairs(resourceKey, pubLines, prvLines, prvEncryption, passwordProvider);
    }

    public static List<String> extractDataLines(String resourceKey, List<String> lines, int startIndex, String hdrName, String hdrValue, List<String> curLines) throws IOException {
        int numLines;
        if (GenericUtils.size(curLines) > 0) {
            throw new StreamCorruptedException("Duplicate " + hdrName + " in " + resourceKey);
        }
        try {
            numLines = Integer.parseInt(hdrValue);
        }
        catch (NumberFormatException e) {
            throw new StreamCorruptedException("Bad " + hdrName + " value (" + hdrValue + ") in " + resourceKey);
        }
        int endIndex = startIndex + numLines;
        int totalLines = lines.size();
        if (endIndex > totalLines) {
            throw new StreamCorruptedException("Excessive " + hdrName + " value (" + hdrValue + ") in " + resourceKey);
        }
        return lines.subList(startIndex, endIndex);
    }

    public Collection<KeyPair> loadKeyPairs(String resourceKey, List<String> pubLines, List<String> prvLines, String prvEncryption, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(resourceKey, KeyPairResourceParser.joinDataLines(pubLines), KeyPairResourceParser.joinDataLines(prvLines), prvEncryption, passwordProvider);
    }

    public Collection<KeyPair> loadKeyPairs(String resourceKey, String pubData, String prvData, String prvEncryption, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        Base64.Decoder b64Decoder = Base64.getDecoder();
        byte[] pubBytes = b64Decoder.decode(pubData);
        byte[] prvBytes = b64Decoder.decode(prvData);
        String password = null;
        if (GenericUtils.length((CharSequence)prvEncryption) > 0 && !"none".equalsIgnoreCase(prvEncryption)) {
            password = passwordProvider.getPassword(resourceKey);
        }
        if (GenericUtils.isEmpty((CharSequence)prvEncryption) || "none".equalsIgnoreCase(prvEncryption) || GenericUtils.isEmpty((CharSequence)password)) {
            return this.loadKeyPairs(resourceKey, pubBytes, prvBytes);
        }
        int pos = prvEncryption.indexOf(45);
        if (pos <= 0) {
            throw new StreamCorruptedException("Missing private key encryption mode in " + prvEncryption);
        }
        String mode = prvEncryption.substring(pos + 1).toUpperCase();
        String algName = null;
        int numBits = 0;
        for (int index = 0; index < pos; ++index) {
            char ch = prvEncryption.charAt(index);
            if (ch < '0' || ch > '9') continue;
            algName = prvEncryption.substring(0, index).toUpperCase();
            numBits = Integer.parseInt(prvEncryption.substring(index, pos));
            break;
        }
        if (GenericUtils.isEmpty(algName) || numBits <= 0) {
            throw new StreamCorruptedException("Missing private key encryption algorithm details in " + prvEncryption);
        }
        prvBytes = PuttyKeyPairResourceParser.decodePrivateKeyBytes(prvBytes, algName, numBits, mode, password);
        return this.loadKeyPairs(resourceKey, pubBytes, prvBytes);
    }

    /*
     * Exception decompiling
     */
    public Collection<KeyPair> loadKeyPairs(String resourceKey, byte[] pubData, byte[] prvData) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Collection<KeyPair> loadKeyPairs(String resourceKey, InputStream pubData, InputStream prvData) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract Collection<KeyPair> loadKeyPairs(String var1, PuttyKeyReader var2, PuttyKeyReader var3) throws IOException, GeneralSecurityException;
}

