/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionProperties {
    private VersionProperties() {
        throw new UnsupportedOperationException("No instance");
    }

    public static NavigableMap<String, String> getVersionProperties() {
        return LazyVersionPropertiesHolder.PROPERTIES;
    }

    private static final class LazyVersionPropertiesHolder {
        private static final NavigableMap<String, String> PROPERTIES = Collections.unmodifiableNavigableMap(LazyVersionPropertiesHolder.loadVersionProperties(LazyVersionPropertiesHolder.class));

        private LazyVersionPropertiesHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        private static NavigableMap<String, String> loadVersionProperties(Class<?> anchor) {
            return LazyVersionPropertiesHolder.loadVersionProperties(anchor, ThreadUtils.resolveDefaultClassLoader(anchor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static NavigableMap<String, String> loadVersionProperties(Class<?> anchor, ClassLoader loader) {
            TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            try {
                InputStream input = loader.getResourceAsStream("org/apache/sshd/sshd-version.properties");
                if (input == null) {
                    throw new FileNotFoundException("Version resource does not exist");
                }
                Properties props = new Properties();
                try {
                    props.load(input);
                }
                finally {
                    input.close();
                }
                for (String key : props.stringPropertyNames()) {
                    String prev;
                    String propValue = props.getProperty(key);
                    String value = GenericUtils.trimToEmpty(propValue);
                    if (GenericUtils.isEmpty(value) || (prev = result.put(key, value)) == null) continue;
                    Logger log = LoggerFactory.getLogger(anchor);
                    log.warn("Multiple values for key=" + key + ": current=" + value + ", previous=" + prev);
                }
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(anchor);
                log.warn("Failed (" + e.getClass().getSimpleName() + ") to load version properties: " + e.getMessage());
            }
            return result;
        }
    }
}

