/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli;

import java.io.PrintStream;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.util.GenericUtils;

public abstract class CliSupport {
    public static final BuiltinIoServiceFactoryFactories DEFAULT_IO_SERVICE_FACTORY = BuiltinIoServiceFactoryFactories.NIO2;

    protected CliSupport() {
    }

    public static boolean showError(PrintStream stderr, String message) {
        stderr.println(message);
        return true;
    }

    public static BuiltinIoServiceFactoryFactories resolveIoServiceFactory(PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        BuiltinIoServiceFactoryFactories factory = null;
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-io".equals(argName)) continue;
            if (factory != null) {
                stderr.println("I/O factory re-specified - already set as " + factory);
                return null;
            }
            if (++index >= numArgs) {
                stderr.println("option requires an argument: " + argName);
                return null;
            }
            String provider = args[index];
            factory = BuiltinIoServiceFactoryFactories.fromFactoryName((String)provider);
            if (factory != null) continue;
            System.err.println("provider (" + argName + ") should be one of " + BuiltinIoServiceFactoryFactories.VALUES);
            return null;
        }
        if (factory == null) {
            factory = DEFAULT_IO_SERVICE_FACTORY;
        }
        System.setProperty(IoServiceFactoryFactory.class.getName(), factory.getFactoryClassName());
        return factory;
    }

    public static <M extends AbstractFactoryManager> M setupIoServiceFactory(M manager, PrintStream stderr, String ... args) {
        BuiltinIoServiceFactoryFactories factory = CliSupport.resolveIoServiceFactory(stderr, args);
        if (factory == null) {
            return null;
        }
        manager.setIoServiceFactoryFactory(factory.create());
        return manager;
    }
}

