/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer.matcher;

import java.util.ArrayDeque;
import java.util.ArrayList;
import org.apache.mina.core.buffer.matcher.IOCase;

public class FilenameUtils {
    private static final int NOT_FOUND = -1;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char UNIX_NAME_SEPARATOR = '/';
    private static final char WINDOWS_NAME_SEPARATOR = '\\';

    public static boolean wildcardMatch(String fileName, String wildcardMatcher, IOCase ioCase) {
        if (fileName == null && wildcardMatcher == null) {
            return true;
        }
        if (fileName == null || wildcardMatcher == null) {
            return false;
        }
        ioCase = IOCase.value(ioCase, IOCase.SENSITIVE);
        String[] wcs = FilenameUtils.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        ArrayDeque<int[]> backtrack = new ArrayDeque<int[]>(wcs.length);
        do {
            if (!backtrack.isEmpty()) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > fileName.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = fileName.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = ioCase.checkIndexOf(fileName, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = ioCase.checkIndexOf(fileName, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!ioCase.checkRegionMatches(fileName, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != fileName.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return false;
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    static char flipSeparator(char ch) {
        if (ch == '/') {
            return '\\';
        }
        if (ch == '\\') {
            return '/';
        }
        throw new IllegalArgumentException(String.valueOf(ch));
    }
}

