/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassivePorts {
    private Logger log = LoggerFactory.getLogger(PassivePorts.class);
    private static final int MAX_PORT = 65535;
    private static final Integer MAX_PORT_INTEGER = 65535;
    private List<Integer> freeList;
    private Set<Integer> usedList;
    private Random r = new Random();
    private String passivePortsString;
    private boolean checkIfBound;

    private static Set<Integer> parse(String portsString) {
        HashSet<Integer> passivePortsList = new HashSet<Integer>();
        boolean inRange = false;
        Integer lastPort = 1;
        StringTokenizer st = new StringTokenizer(portsString, ",;-", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (",".equals(token) || ";".equals(token)) {
                if (inRange) {
                    PassivePorts.fillRange(passivePortsList, lastPort, MAX_PORT_INTEGER);
                }
                lastPort = 1;
                inRange = false;
                continue;
            }
            if ("-".equals(token)) {
                inRange = true;
                continue;
            }
            if (token.length() == 0) continue;
            Integer port = Integer.valueOf(token);
            PassivePorts.verifyPort(port);
            if (inRange) {
                PassivePorts.fillRange(passivePortsList, lastPort, port);
                inRange = false;
            }
            PassivePorts.addPort(passivePortsList, port);
            lastPort = port;
        }
        if (inRange) {
            PassivePorts.fillRange(passivePortsList, lastPort, MAX_PORT_INTEGER);
        }
        return passivePortsList;
    }

    private static void fillRange(Set<Integer> passivePortsList, Integer beginPort, Integer endPort) {
        for (int i = beginPort.intValue(); i <= endPort; ++i) {
            PassivePorts.addPort(passivePortsList, i);
        }
    }

    private static void addPort(Set<Integer> passivePortsList, Integer port) {
        passivePortsList.add(port);
    }

    private static void verifyPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Port can not be negative: " + port);
        }
        if (port > 65535) {
            throw new IllegalArgumentException("Port too large: " + port);
        }
    }

    public PassivePorts(String passivePorts, boolean checkIfBound) {
        this(PassivePorts.parse(passivePorts), checkIfBound);
        this.passivePortsString = passivePorts;
    }

    public PassivePorts(Set<Integer> passivePorts, boolean checkIfBound) {
        if (passivePorts == null) {
            throw new NullPointerException("passivePorts can not be null");
        }
        if (passivePorts.isEmpty()) {
            passivePorts = new HashSet<Integer>();
            passivePorts.add(0);
        }
        this.freeList = new ArrayList<Integer>(passivePorts);
        this.usedList = new HashSet<Integer>(passivePorts.size());
        this.checkIfBound = checkIfBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPortUnbound(int port) {
        if (!this.checkIfBound) {
            return true;
        }
        if (port == 0) {
            return true;
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
    }

    public synchronized int reserveNextPort() {
        ArrayList<Integer> freeCopy = new ArrayList<Integer>(this.freeList);
        while (freeCopy.size() > 0) {
            int i = this.r.nextInt(freeCopy.size());
            Integer ret = (Integer)freeCopy.get(i);
            if (ret == 0) {
                return 0;
            }
            if (this.checkPortUnbound(ret)) {
                this.freeList.remove(i);
                this.usedList.add(ret);
                return ret;
            }
            freeCopy.remove(i);
            this.log.warn("Passive port in use by another process: " + ret);
        }
        return -1;
    }

    public synchronized void releasePort(int port) {
        if (port != 0) {
            if (this.usedList.remove(port)) {
                this.freeList.add(port);
            } else {
                this.log.warn("Releasing unreserved passive port: " + port);
            }
        }
    }

    public String toString() {
        if (this.passivePortsString != null) {
            return this.passivePortsString;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer port : this.freeList) {
            sb.append(port);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

