package org.apache.maven.report.projectinfo;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.net.URL;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.TextBlock;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;

/**
 * @author Nick Stolwijk
 * @version $Id: DependencyManagementReportTest.java 1732680 2016-02-27 23:31:53Z michaelo $
 * @since 2.1
 */
public class DependencyManagementReportTest
    extends AbstractProjectInfoTestCase
{
    /**
     * WebConversation object
     */
    private static final WebConversation WEB_CONVERSATION = new WebConversation();

    /**
     * Test report
     *
     * @throws Exception if any
     */
    public void testReport()
        throws Exception
    {
        generateReport( "dependency-management", "dependency-management-plugin-config.xml" );
        assertTrue( "Test html generated", getGeneratedReport( "dependency-management.html" ).exists() );

        URL reportURL = getGeneratedReport( "dependency-management.html" ).toURI().toURL();
        assertNotNull( reportURL );

        // HTTPUnit
        WebRequest request = new GetMethodWebRequest( reportURL.toString() );
        WebResponse response = WEB_CONVERSATION.getResponse( request );

        // Basic HTML tests
        assertTrue( response.isHTML() );
        assertTrue( response.getContentLength() > 0 );

        // Test the Page title
        String expectedTitle = prepareTitle( getString( "report.dependency-management.name" ),
            getString( "report.dependency-management.title" ) );
        assertEquals( expectedTitle, response.getTitle() );

        // Test the tables
        WebTable[] webTables = response.getTables();
        assertEquals( webTables.length, 1 );

        assertEquals( webTables[0].getColumnCount(), 5 );
        assertEquals( webTables[0].getRowCount(),
                      1 + getTestMavenProject().getDependencyManagement().getDependencies().size() );

        // Test the texts
        TextBlock[] textBlocks = response.getTextBlocks();
        assertEquals( getString( "report.dependency-management.title" ), textBlocks[0].getText() );
        assertEquals( "test", textBlocks[1].getText() );
    }
}
