/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

File buildLog = new File( basedir, 'build.log' )
assert buildLog.exists()

// we have 2 modules and for each module this should be output once
// note: this is only logged in debug mode by net.sourceforge.pmd.cache.FileAnalysisCache
assert 2 == buildLog.text.count( "Analysis cache created" )

// since we are running clean pmd:pmd, the cache is always created, never updated
// note: this is only logged in debug mode by net.sourceforge.pmd.cache.FileAnalysisCache
assert 0 == buildLog.text.count( "Analysis cache updated" )
