<!---
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

## Build Cache Parameters

This document contains various configuration parameters supported by the cache engine.

### Command line flags

| Parameter                                                  | Description                                                                                                                               | Usage Scenario                                                                     |
|------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------|
| `-Dmaven.build.cache.configPath=path to file`              | Location of cache configuration file                                                                                                      | Cache config is not in default location                                            |
| `-Dmaven.build.cache.enabled=(true/false)`                 | Cache and associated features disabled/enabled                                                                                            | To remove noise from logs when the remote cache is not available              |
| `-Dmaven.build.cache.remote.enabled=(true/false)`          | Checks and downloads artifacts from the remote cache (overrides <remote enabled=("true"/"false")>)                                        | To control remote cache access by node, if, say, some nodes lack reliable access   |
| `-Dmaven.build.cache.remote.save.enabled=(true/false)`     | Remote cache save allowed or not                                                                                                          | To designate nodes which allowed to push in remote shared cache                    |
| `-Dmaven.build.cache.remote.save.final=(true/false)`       | Prohibit to override remote cache                                                                                                         | Prevents cache records from being overridden by subsequent builds                      |
| `-Dmaven.build.cache.remote.url=`                          | Url of the remote cache (overrides  <remote><url></url></remote>)                                                                         | To override url of remote cache from command line                                  |
| `-Dmaven.build.cache.remote.server.id=`                    | Id of the remote cache server (overrides  <remote id=""></remote>)                                                                        | To override id of remote cache server from command line                            |
| `-Dmaven.build.cache.failFast=(true/false)`                | Fail on the first module which cannot be restored from cache                                                                              | Remote cache setup/tuning/troubleshooting                                          |
| `-Dmaven.build.cache.baselineUrl=<http url>`               | Location of baseline build for comparison                                                                                                 | Remote cache setup/tuning/troubleshooting                                          |
| `-Dmaven.build.cache.lazyRestore=(true/false)`             | Restore artifacts from remote cache lazily                                                                                                | Performance optimization                                                           |
| `-Dmaven.build.cache.restoreGeneratedSources=(true/false)` | Restore generated sources and directly attached files in the corresponding project directories. (default is true)                         | Performance optimization                                                           |
| `-Dmaven.build.cache.restoreOnDiskArtifacts=(true/false)`  | Restore generated artifacts in the project build directory. (default is true)                                                             | Performance optimization                                                           |
| `-Dmaven.build.cache.alwaysRunPlugins=<list of plugins>`   | Comma separated list of plugins to always run regardless of cache state. An example: `maven-deploy-plugin:*,maven-install-plugin:install` | Remote cache setup/tuning/troubleshooting                                          |
| `-Dmaven.build.cache.skipCache=(true/false)`               | Skip looking up artifacts in caches. Does not affect writing artifacts to caches, disables only reading when set to `true`               | May be used to trigger a forced rebuild when matching artifacts do exist in caches |
| `-Dmaven.build.cache.skipSave=(true/false)`            | Skip writing build result in caches. Does not affect reading from the cache.               | Configuring MR builds to benefits from the cache, but restricting writes to the `master` branch |
| `-Dmaven.build.cache.mandatoryClean=(true/false)`          | Enable or disable the necessity to execute the `clean` phase in order to store the build result in cache                                  | Reducing the risk to save "wrong" files in cache in a local dev environnement      |

### Project-level properties

Project-level parameters allowing to override global parameters on the project level. Must be specified as prefixed
project properties:

```xml

<pom>
    ...
    <properties>
        <maven.build.cache.input.glob>{*.css}</maven.build.cache.input.glob>
    </properties>
</pom>
```

| Parameter                                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
|----------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `maven.build.cache.input.glob`               | Project specific <a href="build-cache-config.html#global">glob</a> to select sources. Overrides the global glob.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `maven.build.cache.input`                    | Additional <a href="build-cache-config.html#include">inputs</a><br/><br/>Example :<br/>```<maven.build.cache.input.1>src/main/scala<maven.build.cache.input.1>```<br/>```<maven.build.cache.input.2>assembly-conf<maven.build.cache.input.2>```                                                                                                                                                                                                                                                                                                                     |
| `maven.build.cache.exclude.xxx`              | Additional <a href="build-cache-config.html#class_exclude">exclusion</a>. <br/><br/>Example :<br/>```<maven.build.cache.exclude.value.1>src/main/java/package-info.java<maven.build.cache.exclude.value.1>```<br/>```<maven.build.cache.exclude.value.2>src/main/resources<maven.build.cache.exclude.value.2>```<br/>```<maven.build.cache.exclude.glob.2>*.md<maven.build.cache.exclude.glob/2>```<br/>Produce two project exclusions :  <br/>```<exclude>src/main/java/package-info.java</exclude>```<br/>```<exclude glob="*.md">src/main/resources</exclude>``` |
| `maven.build.cache.processPlugins`           | Introspect plugins to find inputs or not. The default value is true.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `maven.build.cache.skipCache`                | Skip looking up artifacts for a particular project in caches. The default value is false.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `maven.build.cache.restoreGeneratedSources`  | Restore generated sources and directly attached files in the corresponding project directories. The default value is true.                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `maven.build.cache.restoreOnDiskArtifacts`   | Restore generated artifacts in the project build directory. The default value is true.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |

