// Copyright 2018 The Abseil Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef ABSL_DEBUGGING_SYMBOLIZE_H_
#define ABSL_DEBUGGING_SYMBOLIZE_H_

#include "absl/debugging/internal/symbolize.h"

namespace absl {

// Initializes this module. Symbolize() may fail prior calling this function.
// `argv0` is the path to this program, which is usually obtained in main()
// though argv[0].
void InitializeSymbolizer(const char* argv0);

// Symbolizes a program counter.  On success, returns true and write the
// symbol name to "out".  The symbol name is demangled if possible
// (supports symbols generated by GCC 3.x or newer), may be truncated, and
// will be '\0' terminated.  Otherwise, returns false.
bool Symbolize(const void *pc, char *out, int out_size);

}  // namespace absl

#endif  // ABSL_DEBUGGING_SYMBOLIZE_H_
