/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.marmotta.platform.ldp.exceptions;

/**
 * Exception to be thrown if a client operation tries to modify server-controlled data, and the operation should not be ignored.
 *
 * @author Jakob Frank
 *
 * @see <a href="https://dvcs.w3.org/hg/ldpwg/raw-file/default/ldp.html#ldpr-put-servermanagedprops">LDP Spec, Sec. 5.5.2</a>
 */
public class InvalidModificationException extends Exception {

    public InvalidModificationException() {
        super();
    }

    public InvalidModificationException(String message) {
        super(message);
    }

    public InvalidModificationException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidModificationException(Throwable cause) {
        super(cause);
    }

}
