/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.marmotta.commons.sesame.filter;

/**
 * Negates a wrapped filter
 * <p/>
 * Author: Sebastian Schaffert (sschaffert@apache.org)
 */
public class NotFilter<T> implements SesameFilter<T> {

    SesameFilter<T> wrapped;

    public NotFilter(SesameFilter<T> wrapped) {
        this.wrapped = wrapped;
    }

    /**
     * Return false in case the filter does not accept the resource passed as argument, true otherwise.
     *
     * @param resource
     * @return
     */
    @Override
    public boolean accept(T resource) {
        return !wrapped.accept(resource);
    }
}
