/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight.vectorhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.highlight.vectorhighlight.SimpleFragmentsBuilder;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class SourceSimpleFragmentsBuilder
extends SimpleFragmentsBuilder {
    private final SearchContext searchContext;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(FieldMapper<?> mapper, SearchContext searchContext, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(mapper, preTags, postTags, boundaryScanner);
        this.searchContext = searchContext;
    }

    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SearchLookup lookup = this.searchContext.lookup();
        lookup.setNextReader((AtomicReaderContext)reader.getContext());
        lookup.setNextDocId(docId);
        List<Object> values = lookup.source().extractRawValues(this.mapper.names().sourcePath());
        if (values.isEmpty()) {
            return EMPTY_FIELDS;
        }
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.mapper.names().indexName(), values.get(i).toString(), TextField.TYPE_NOT_STORED);
        }
        return fields;
    }
}

