/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.slowlog;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.SearchContext;

public class ShardSlowLogSearchService
extends AbstractIndexShardComponent {
    private boolean reformat;
    private long queryWarnThreshold;
    private long queryInfoThreshold;
    private long queryDebugThreshold;
    private long queryTraceThreshold;
    private long fetchWarnThreshold;
    private long fetchInfoThreshold;
    private long fetchDebugThreshold;
    private long fetchTraceThreshold;
    private String level;
    private final ESLogger queryLogger;
    private final ESLogger fetchLogger;
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN = "index.search.slowlog.threshold.query.warn";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO = "index.search.slowlog.threshold.query.info";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG = "index.search.slowlog.threshold.query.debug";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE = "index.search.slowlog.threshold.query.trace";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN = "index.search.slowlog.threshold.fetch.warn";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO = "index.search.slowlog.threshold.fetch.info";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG = "index.search.slowlog.threshold.fetch.debug";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE = "index.search.slowlog.threshold.fetch.trace";
    public static final String INDEX_SEARCH_SLOWLOG_REFORMAT = "index.search.slowlog.reformat";
    public static final String INDEX_SEARCH_SLOWLOG_LEVEL = "index.search.slowlog.level";

    @Inject
    public ShardSlowLogSearchService(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService) {
        super(shardId, indexSettings);
        this.reformat = this.componentSettings.getAsBoolean("reformat", (Boolean)true);
        this.queryWarnThreshold = this.componentSettings.getAsTime("threshold.query.warn", TimeValue.timeValueNanos(-1L)).nanos();
        this.queryInfoThreshold = this.componentSettings.getAsTime("threshold.query.info", TimeValue.timeValueNanos(-1L)).nanos();
        this.queryDebugThreshold = this.componentSettings.getAsTime("threshold.query.debug", TimeValue.timeValueNanos(-1L)).nanos();
        this.queryTraceThreshold = this.componentSettings.getAsTime("threshold.query.trace", TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchWarnThreshold = this.componentSettings.getAsTime("threshold.fetch.warn", TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchInfoThreshold = this.componentSettings.getAsTime("threshold.fetch.info", TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchDebugThreshold = this.componentSettings.getAsTime("threshold.fetch.debug", TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchTraceThreshold = this.componentSettings.getAsTime("threshold.fetch.trace", TimeValue.timeValueNanos(-1L)).nanos();
        this.level = this.componentSettings.get("level", "TRACE").toUpperCase(Locale.ROOT);
        this.queryLogger = Loggers.getLogger(this.logger, ".query");
        this.fetchLogger = Loggers.getLogger(this.logger, ".fetch");
        this.queryLogger.setLevel(this.level);
        this.fetchLogger.setLevel(this.level);
        indexSettingsService.addListener(new ApplySettings());
    }

    public void onQueryPhase(SearchContext context, long tookInNanos) {
        if (this.queryWarnThreshold >= 0L && tookInNanos > this.queryWarnThreshold) {
            this.queryLogger.warn("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.queryInfoThreshold >= 0L && tookInNanos > this.queryInfoThreshold) {
            this.queryLogger.info("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.queryDebugThreshold >= 0L && tookInNanos > this.queryDebugThreshold) {
            this.queryLogger.debug("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.queryTraceThreshold >= 0L && tookInNanos > this.queryTraceThreshold) {
            this.queryLogger.trace("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        }
    }

    public void onFetchPhase(SearchContext context, long tookInNanos) {
        if (this.fetchWarnThreshold >= 0L && tookInNanos > this.fetchWarnThreshold) {
            this.fetchLogger.warn("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.fetchInfoThreshold >= 0L && tookInNanos > this.fetchInfoThreshold) {
            this.fetchLogger.info("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.fetchDebugThreshold >= 0L && tookInNanos > this.fetchDebugThreshold) {
            this.fetchLogger.debug("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.fetchTraceThreshold >= 0L && tookInNanos > this.fetchTraceThreshold) {
            this.fetchLogger.trace("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        }
    }

    public static class SlowLogSearchContextPrinter {
        private final SearchContext context;
        private final long tookInNanos;
        private final boolean reformat;

        public SlowLogSearchContextPrinter(SearchContext context, long tookInNanos, boolean reformat) {
            this.context = context;
            this.tookInNanos = tookInNanos;
            this.reformat = reformat;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("took[").append(TimeValue.timeValueNanos(this.tookInNanos)).append("], took_millis[").append(TimeUnit.NANOSECONDS.toMillis(this.tookInNanos)).append("], ");
            if (this.context.types() == null) {
                sb.append("types[], ");
            } else {
                sb.append("types[");
                Strings.arrayToDelimitedString(this.context.types(), ",", sb);
                sb.append("], ");
            }
            if (this.context.groupStats() == null) {
                sb.append("stats[], ");
            } else {
                sb.append("stats[");
                Strings.collectionToDelimitedString(this.context.groupStats(), ",", "", "", sb);
                sb.append("], ");
            }
            sb.append("search_type[").append((Object)this.context.searchType()).append("], total_shards[").append(this.context.numberOfShards()).append("], ");
            if (this.context.request().source() != null && this.context.request().source().length() > 0) {
                try {
                    sb.append("source[").append(XContentHelper.convertToJson(this.context.request().source(), this.reformat)).append("], ");
                }
                catch (IOException e) {
                    sb.append("source[_failed_to_convert_], ");
                }
            } else {
                sb.append("source[], ");
            }
            if (this.context.request().extraSource() != null && this.context.request().extraSource().length() > 0) {
                try {
                    sb.append("extra_source[").append(XContentHelper.convertToJson(this.context.request().extraSource(), this.reformat)).append("], ");
                }
                catch (IOException e) {
                    sb.append("extra_source[_failed_to_convert_], ");
                }
            } else {
                sb.append("extra_source[], ");
            }
            return sb.toString();
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public synchronized void onRefreshSettings(Settings settings) {
            boolean reformat;
            String level;
            long fetchTraceThreshold;
            long fetchDebugThreshold;
            long fetchInfoThreshold;
            long fetchWarnThreshold;
            long queryTraceThreshold;
            long queryDebugThreshold;
            long queryInfoThreshold;
            long queryWarnThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.queryWarnThreshold)).nanos();
            if (queryWarnThreshold != ShardSlowLogSearchService.this.queryWarnThreshold) {
                ShardSlowLogSearchService.this.queryWarnThreshold = queryWarnThreshold;
            }
            if ((queryInfoThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.queryInfoThreshold)).nanos()) != ShardSlowLogSearchService.this.queryInfoThreshold) {
                ShardSlowLogSearchService.this.queryInfoThreshold = queryInfoThreshold;
            }
            if ((queryDebugThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.queryDebugThreshold)).nanos()) != ShardSlowLogSearchService.this.queryDebugThreshold) {
                ShardSlowLogSearchService.this.queryDebugThreshold = queryDebugThreshold;
            }
            if ((queryTraceThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.queryTraceThreshold)).nanos()) != ShardSlowLogSearchService.this.queryTraceThreshold) {
                ShardSlowLogSearchService.this.queryTraceThreshold = queryTraceThreshold;
            }
            if ((fetchWarnThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.fetchWarnThreshold)).nanos()) != ShardSlowLogSearchService.this.fetchWarnThreshold) {
                ShardSlowLogSearchService.this.fetchWarnThreshold = fetchWarnThreshold;
            }
            if ((fetchInfoThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.fetchInfoThreshold)).nanos()) != ShardSlowLogSearchService.this.fetchInfoThreshold) {
                ShardSlowLogSearchService.this.fetchInfoThreshold = fetchInfoThreshold;
            }
            if ((fetchDebugThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.fetchDebugThreshold)).nanos()) != ShardSlowLogSearchService.this.fetchDebugThreshold) {
                ShardSlowLogSearchService.this.fetchDebugThreshold = fetchDebugThreshold;
            }
            if ((fetchTraceThreshold = settings.getAsTime(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE, TimeValue.timeValueNanos(ShardSlowLogSearchService.this.fetchTraceThreshold)).nanos()) != ShardSlowLogSearchService.this.fetchTraceThreshold) {
                ShardSlowLogSearchService.this.fetchTraceThreshold = fetchTraceThreshold;
            }
            if (!(level = settings.get(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_LEVEL, ShardSlowLogSearchService.this.level)).equals(ShardSlowLogSearchService.this.level)) {
                ShardSlowLogSearchService.this.queryLogger.setLevel(level.toUpperCase(Locale.ROOT));
                ShardSlowLogSearchService.this.fetchLogger.setLevel(level.toUpperCase(Locale.ROOT));
                ShardSlowLogSearchService.this.level = level;
            }
            if ((reformat = settings.getAsBoolean(ShardSlowLogSearchService.INDEX_SEARCH_SLOWLOG_REFORMAT, (Boolean)ShardSlowLogSearchService.this.reformat).booleanValue()) != ShardSlowLogSearchService.this.reformat) {
                ShardSlowLogSearchService.this.reformat = reformat;
            }
        }
    }
}

