/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTreeTermsReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.elasticsearch.common.breaker.MemoryCircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class PagedBytesIndexFieldData
extends AbstractBytesIndexFieldData<PagedBytesAtomicFieldData> {
    private final CircuitBreakerService breakerService;

    public PagedBytesIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagedBytesAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        PagedBytesEstimator estimator = new PagedBytesEstimator(context, this.breakerService.getBreaker());
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            PagedBytesAtomicFieldData emptyData = PagedBytesAtomicFieldData.empty(reader.maxDoc());
            estimator.adjustForNoTerms(emptyData.getMemorySizeInBytes());
            return emptyData;
        }
        PagedBytes bytes = new PagedBytes(15);
        MonotonicAppendingLongBuffer termOrdToBytesOffset = new MonotonicAppendingLongBuffer();
        termOrdToBytesOffset.add(0L);
        long numTerms = this.regex == null && this.frequency == null ? terms.size() : -1L;
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(numTerms, reader.maxDoc(), acceptableTransientOverheadRatio);
        PagedBytesAtomicFieldData data = null;
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            bytes.copyUsingLengthPrefix(new BytesRef());
            DocsEnum docsEnum = null;
            BytesRef term = termsEnum.next();
            while (term != null) {
                long termOrd = builder.nextOrdinal();
                assert (termOrd == termOrdToBytesOffset.size());
                termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                docsEnum = termsEnum.docs(null, docsEnum, 0);
                int docId = docsEnum.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    builder.addDoc(docId);
                    docId = docsEnum.nextDoc();
                }
                term = termsEnum.next();
            }
            long sizePointer = bytes.getPointer();
            PagedBytes.Reader bytesReader = bytes.freeze(true);
            Ordinals ordinals = builder.build(this.fieldDataType.getSettings());
            data = new PagedBytesAtomicFieldData(bytesReader, sizePointer, termOrdToBytesOffset, ordinals);
            success = true;
            PagedBytesAtomicFieldData pagedBytesAtomicFieldData = data;
            return pagedBytesAtomicFieldData;
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.getMemorySizeInBytes());
            }
            builder.close();
        }
    }

    static final class FilterSettingFields {
        static final String ACCEPTABLE_TRANSIENT_OVERHEAD_RATIO = "acceptable_transient_overhead_ratio";
        static final String FREQUENCY_MIN = "filter.frequency.min";
        static final String FREQUENCY_MAX = "filter.frequency.max";
        static final String FREQUENCY_MIN_SEGMENT_SIZE = "filter.frequency.min_segment_size";
        static final String REGEX_PATTERN = "filter.regex.pattern";

        FilterSettingFields() {
        }
    }

    public class PagedBytesEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final AtomicReaderContext context;
        private final MemoryCircuitBreaker breaker;
        private long estimatedBytes;

        PagedBytesEstimator(AtomicReaderContext context, MemoryCircuitBreaker breaker) {
            this.breaker = breaker;
            this.context = context;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            long bytes = term.length;
            bytes += 64L;
            bytes = (long)((double)bytes / 1.5) + 1L;
            return bytes;
        }

        public long estimateStringFieldData() {
            try {
                AtomicReader reader = this.context.reader();
                Terms terms = reader.terms(PagedBytesIndexFieldData.this.getFieldNames().indexName());
                Fields fields = reader.fields();
                Terms fieldTerms = fields.terms(PagedBytesIndexFieldData.this.getFieldNames().indexName());
                if (fieldTerms instanceof BlockTreeTermsReader.FieldReader) {
                    BlockTreeTermsReader.Stats stats = ((BlockTreeTermsReader.FieldReader)fieldTerms).computeStats();
                    long totalTermBytes = stats.totalTermBytes;
                    if (PagedBytesIndexFieldData.this.logger.isTraceEnabled()) {
                        PagedBytesIndexFieldData.this.logger.trace("totalTermBytes: {}, terms.size(): {}, terms.getSumDocFreq(): {}", totalTermBytes, terms.size(), terms.getSumDocFreq());
                    }
                    long totalBytes = totalTermBytes + 2L * terms.size() + 4L * terms.getSumDocFreq();
                    return totalBytes;
                }
            }
            catch (Exception e) {
                PagedBytesIndexFieldData.this.logger.warn("Unable to estimate memory overhead", e, new Object[0]);
            }
            return 0L;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            float acceptableTransientOverheadRatio = PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
            AtomicReader reader = this.context.reader();
            if (acceptableTransientOverheadRatio != 0.5f || PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsDouble("filter.frequency.min", (Double)0.0) != 0.0 || PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsDouble("filter.frequency.max", (Double)0.0) != 0.0 || PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsDouble("filter.frequency.min_segment_size", (Double)0.0) != 0.0 || PagedBytesIndexFieldData.this.fieldDataType.getSettings().get("filter.regex.pattern") != null) {
                if (PagedBytesIndexFieldData.this.logger.isTraceEnabled()) {
                    PagedBytesIndexFieldData.this.logger.trace("Filter exists, can't circuit break normally, using RamAccountingTermsEnum", new Object[0]);
                }
                return new RamAccountingTermsEnum(PagedBytesIndexFieldData.this.filter(terms, reader), this.breaker, this);
            }
            this.estimatedBytes = this.estimateStringFieldData();
            if (this.estimatedBytes == 0L) {
                return new RamAccountingTermsEnum(PagedBytesIndexFieldData.this.filter(terms, reader), this.breaker, this);
            }
            this.breaker.addEstimateBytesAndMaybeBreak(this.estimatedBytes);
            return PagedBytesIndexFieldData.this.filter(terms, reader);
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            if (termsEnum instanceof RamAccountingTermsEnum) {
                this.estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            }
            this.breaker.addWithoutBreaking(-(this.estimatedBytes - actualUsed));
        }

        public void adjustForNoTerms(long actualUsed) {
            this.breaker.addWithoutBreaking(actualUsed);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<PagedBytesAtomicFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new PagedBytesIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

