/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.FastCharArrayWriter;
import org.elasticsearch.common.io.FastStringReader;

public class AllEntries
extends Reader {
    private final List<Entry> entries = Lists.newArrayList();
    private Entry current;
    private Iterator<Entry> it;
    private boolean itsSeparatorTime = false;
    private boolean customBoost = false;

    public void addText(String name, String text, float boost) {
        int lastStartOffset;
        if (boost != 1.0f) {
            this.customBoost = true;
        }
        if (this.entries.isEmpty()) {
            lastStartOffset = -1;
        } else {
            Entry last = this.entries.get(this.entries.size() - 1);
            lastStartOffset = last.startOffset() + last.reader().length();
        }
        int startOffset = lastStartOffset + 1;
        Entry entry = new Entry(name, new FastStringReader(text), startOffset, boost);
        this.entries.add(entry);
    }

    public boolean customBoost() {
        return this.customBoost;
    }

    public void clear() {
        this.entries.clear();
        this.current = null;
        this.it = null;
        this.itsSeparatorTime = false;
    }

    @Override
    public void reset() {
        try {
            for (Entry entry : this.entries) {
                entry.reader().reset();
            }
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("should not happen");
        }
        this.it = this.entries.iterator();
        if (this.it.hasNext()) {
            this.current = this.it.next();
            this.itsSeparatorTime = true;
        }
    }

    public String buildText() {
        this.reset();
        FastCharArrayWriter writer = new FastCharArrayWriter();
        for (Entry entry : this.entries) {
            writer.append(entry.reader());
            writer.append(' ');
        }
        this.reset();
        return writer.toString();
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Set<String> fields() {
        HashSet<String> fields = Sets.newHashSet();
        for (Entry entry : this.entries) {
            fields.add(entry.name());
        }
        return fields;
    }

    public float boost(int startOffset) {
        if (!this.entries.isEmpty()) {
            int lo = 0;
            int hi = this.entries.size() - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midOffset = this.entries.get(mid).startOffset();
                if (startOffset < midOffset) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            int index = Math.max(0, hi);
            assert (this.entries.get(index).startOffset() <= startOffset);
            assert (index == this.entries.size() - 1 || this.entries.get(index + 1).startOffset() > startOffset);
            return this.entries.get(index).boost();
        }
        return 1.0f;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.customBoost) {
            int result = this.current.reader().read(cbuf, off, len);
            if (result == -1) {
                if (this.itsSeparatorTime) {
                    this.itsSeparatorTime = false;
                    cbuf[off] = 32;
                    return 1;
                }
                this.itsSeparatorTime = true;
                this.current = this.it.hasNext() ? this.it.next() : null;
                return this.read(cbuf, off, len);
            }
            return result;
        }
        int read = 0;
        while (len > 0) {
            int result = this.current.reader().read(cbuf, off, len);
            if (result == -1) {
                if (!this.it.hasNext()) {
                    this.current = null;
                    if (read == 0) {
                        return -1;
                    }
                    return read;
                }
                this.current = this.it.next();
                cbuf[off++] = 32;
                ++read;
                --len;
                continue;
            }
            read += result;
            off += result;
            len -= result;
        }
        return read;
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current = null;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.current != null && this.current.reader().ready();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Entry entry : this.entries) {
            sb.append(entry.name()).append(',');
        }
        return sb.toString();
    }

    public static class Entry {
        private final String name;
        private final FastStringReader reader;
        private final int startOffset;
        private final float boost;

        public Entry(String name, FastStringReader reader, int startOffset, float boost) {
            this.name = name;
            this.reader = reader;
            this.startOffset = startOffset;
            this.boost = boost;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public String name() {
            return this.name;
        }

        public float boost() {
            return this.boost;
        }

        public FastStringReader reader() {
            return this.reader;
        }
    }
}

