/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.XReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public final class XSearcherManager
extends XReferenceManager<IndexSearcher> {
    private final SearcherFactory searcherFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XSearcherManager(IndexWriter writer, boolean applyAllDeletes, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = XSearcherManager.getSearcher(searcherFactory, (IndexReader)DirectoryReader.open((IndexWriter)writer, (boolean)applyAllDeletes));
    }

    public XSearcherManager(Directory dir, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = XSearcherManager.getSearcher(searcherFactory, (IndexReader)DirectoryReader.open((Directory)dir));
    }

    @Override
    protected void decRef(IndexSearcher reference) throws IOException {
        reference.getIndexReader().decRef();
    }

    @Override
    protected IndexSearcher refreshIfNeeded(IndexSearcher referenceToRefresh) throws IOException {
        IndexReader r = referenceToRefresh.getIndexReader();
        if (!$assertionsDisabled && !(r instanceof DirectoryReader)) {
            throw new AssertionError((Object)("searcher's IndexReader should be a DirectoryReader, but got " + r));
        }
        DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)r));
        if (newReader == null) {
            return null;
        }
        return XSearcherManager.getSearcher(this.searcherFactory, (IndexReader)newReader);
    }

    @Override
    protected boolean tryIncRef(IndexSearcher reference) {
        return reference.getIndexReader().tryIncRef();
    }

    @Override
    protected int getRefCount(IndexSearcher reference) {
        return reference.getIndexReader().getRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearcherCurrent() throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.acquire();
        try {
            IndexReader r = searcher.getIndexReader();
            if (!$assertionsDisabled && !(r instanceof DirectoryReader)) {
                throw new AssertionError((Object)("searcher's IndexReader should be a DirectoryReader, but got " + r));
            }
            boolean bl = ((DirectoryReader)r).isCurrent();
            return bl;
        }
        finally {
            this.release(searcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexSearcher getSearcher(SearcherFactory searcherFactory, IndexReader reader) throws IOException {
        IndexSearcher searcher;
        boolean success = false;
        try {
            searcher = searcherFactory.newSearcher(reader);
            if (searcher.getIndexReader() != reader) {
                throw new IllegalStateException("SearcherFactory must wrap exactly the provided reader (got " + searcher.getIndexReader() + " but expected " + reader + ")");
            }
            success = true;
        }
        finally {
            if (!success) {
                reader.decRef();
            }
        }
        return searcher;
    }

    static {
        boolean bl = $assertionsDisabled = !XSearcherManager.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Version.LUCENE_46 != org.elasticsearch.Version.CURRENT.luceneVersion) {
            throw new AssertionError((Object)"Remove this once we are on LUCENE_47 - see LUCENE-5436");
        }
    }
}

