/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.h2.constant.SysProperties;
import org.h2.store.fs.FileObject;
import org.h2.util.IOUtils;

public class FileObjectDisk
extends RandomAccessFile
implements FileObject {
    private final String name;
    private FileLock lock;

    FileObjectDisk(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        this.name = string;
    }

    public void sync() throws IOException {
        String string = SysProperties.SYNC_METHOD;
        if (!"".equals(string)) {
            if ("sync".equals(string)) {
                this.getFD().sync();
            } else if ("force".equals(string)) {
                this.getChannel().force(true);
            } else if ("forceFalse".equals(string)) {
                this.getChannel().force(false);
            } else {
                this.getFD().sync();
            }
        }
    }

    public void setFileLength(long l) throws IOException {
        IOUtils.setLength(this, l);
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean tryLock() {
        if (this.lock == null) {
            try {
                this.lock = this.getChannel().tryLock();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.lock != null;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lock = null;
        }
    }
}

