/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractSingleValueMathFunction;

class Tan
extends AbstractSingleValueMathFunction {
    Tan() {
    }

    @Override
    protected String getName() {
        return "tan";
    }

    @Override
    protected double calc(double d, String suffix, NumberExpression.Dimension dimension) {
        if (suffix.equalsIgnoreCase("deg")) {
            d = Math.toRadians(d);
        } else if (suffix.equalsIgnoreCase("grad")) {
            d *= 0.015707963267948967;
        }
        return Math.tan(d);
    }

    @Override
    protected String resultSuffix(String suffix, NumberExpression.Dimension dimension) {
        return "";
    }

    @Override
    protected NumberExpression.Dimension resultDimension(String suffix, NumberExpression.Dimension dimension) {
        return NumberExpression.Dimension.NUMBER;
    }
}

