/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    protected Connection mConnection;
    protected TextField mName;
    protected TextField mDriver;
    protected TextField mURL;
    protected TextField mUser;
    protected TextField mPassword;
    protected Label mError;
    private String[][] connTypes;
    private Hashtable settings;
    private Choice types;
    private Choice recent;

    public static Connection createConnection(String string, String string2, String string3, String string4) throws Exception {
        Class.forName(string).newInstance();
        return DriverManager.getConnection(string2, string3, string4);
    }

    ConnectionDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    private void create() {
        Panel panel;
        Panel panel2;
        Panel panel3;
        Panel panel4;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLayout(new BorderLayout());
        Panel panel5 = new Panel(new BorderLayout());
        if (dimension.width >= 640) {
            panel4 = new Panel(new GridLayout(8, 1, 10, 10));
            panel3 = new Panel(new GridLayout(8, 1, 10, 10));
            panel2 = new Panel(new GridLayout(1, 2, 10, 10));
            panel = new Panel(new GridLayout(8, 1, 10, 10));
        } else {
            panel4 = new Panel(new GridLayout(8, 1));
            panel3 = new Panel(new GridLayout(8, 1));
            panel2 = new Panel(new GridLayout(1, 2));
            panel = new Panel(new GridLayout(8, 1));
        }
        panel5.add("West", panel4);
        panel5.add("Center", panel3);
        panel5.add("South", panel2);
        panel5.add("North", ConnectionDialog.createLabel(""));
        panel5.add("East", panel);
        panel5.setBackground(SystemColor.control);
        panel3.setBackground(SystemColor.control);
        panel4.setBackground(SystemColor.control);
        panel2.setBackground(SystemColor.control);
        panel4.add(ConnectionDialog.createLabel("Recent:"));
        this.recent = new Choice();
        try {
            this.settings = ConnectionDialogCommon.loadRecentConnectionSettings();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.recent.add(ConnectionDialogCommon.emptySettingName);
        Enumeration enumeration = this.settings.elements();
        while (enumeration.hasMoreElements()) {
            this.recent.add(((ConnectionSetting)enumeration.nextElement()).getName());
        }
        this.recent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)itemEvent.getItem();
                ConnectionSetting connectionSetting = (ConnectionSetting)ConnectionDialog.this.settings.get(string);
                if (connectionSetting != null) {
                    ConnectionDialog.this.mName.setText(connectionSetting.getName());
                    ConnectionDialog.this.mDriver.setText(connectionSetting.getDriver());
                    ConnectionDialog.this.mURL.setText(connectionSetting.getUrl());
                    ConnectionDialog.this.mUser.setText(connectionSetting.getUser());
                    ConnectionDialog.this.mPassword.setText(connectionSetting.getPassword());
                }
            }
        });
        panel3.add(this.recent);
        Button button = new Button("Clr");
        button.setActionCommand("Clear");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialogCommon.deleteRecentConnectionSettings();
                ConnectionDialog.this.settings = new Hashtable();
                ConnectionDialog.this.recent.removeAll();
                ConnectionDialog.this.recent.add(ConnectionDialogCommon.emptySettingName);
                ConnectionDialog.this.mName.setText(null);
            }
        });
        panel.add(button);
        panel4.add(ConnectionDialog.createLabel("Setting Name:"));
        this.mName = new TextField("");
        panel3.add(this.mName);
        panel4.add(ConnectionDialog.createLabel("Type:"));
        this.types = new Choice();
        this.connTypes = ConnectionDialogCommon.getTypes();
        for (int i = 0; i < this.connTypes.length; ++i) {
            this.types.add(this.connTypes[i][0]);
        }
        this.types.addItemListener(this);
        panel3.add(this.types);
        panel4.add(ConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField(this.connTypes[0][1]);
        panel3.add(this.mDriver);
        panel4.add(ConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        panel3.add(this.mURL);
        panel4.add(ConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("SA");
        this.mUser.addActionListener(this);
        panel3.add(this.mUser);
        panel4.add(ConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.addActionListener(this);
        this.mPassword.setEchoChar('*');
        panel3.add(this.mPassword);
        button = new Button("Ok");
        button.setActionCommand("ConnectOk");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Cancel");
        button.setActionCommand("ConnectCancel");
        button.addActionListener(this);
        panel2.add(button);
        this.add("East", ConnectionDialog.createLabel(""));
        this.add("West", ConnectionDialog.createLabel(""));
        this.mError = new Label("");
        Panel panel6 = ConnectionDialog.createBorderPanel(this.mError);
        this.add("South", panel6);
        this.add("North", ConnectionDialog.createLabel(""));
        this.add("Center", panel5);
        this.doLayout();
        this.pack();
        Dimension dimension2 = this.getSize();
        if (dimension.width >= 640) {
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            this.setLocation(0, 0);
            this.setSize(dimension);
        }
        this.show();
    }

    public static Connection createConnection(Frame frame, String string) {
        ConnectionDialog connectionDialog = new ConnectionDialog(frame, string);
        connectionDialog.create();
        return connectionDialog.mConnection;
    }

    protected static Label createLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    protected static Panel createBorderPanel(Component component) {
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new BorderLayout());
        panel.add("Center", component);
        panel.add("North", ConnectionDialog.createLabel(""));
        panel.add("South", ConnectionDialog.createLabel(""));
        panel.add("East", ConnectionDialog.createLabel(""));
        panel.add("West", ConnectionDialog.createLabel(""));
        panel.setBackground(SystemColor.control);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ConnectOk") || actionEvent.getSource() instanceof TextField) {
            try {
                if (this.mURL.getText().indexOf(171) >= 0) {
                    throw new Exception("please specify db path");
                }
                this.mConnection = ConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                if (this.mName.getText() != null && this.mName.getText().trim().length() != 0) {
                    ConnectionSetting connectionSetting = new ConnectionSetting(this.mName.getText(), this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                    ConnectionDialogCommon.addToRecentConnectionSettings(this.settings, connectionSetting);
                }
                this.dispose();
            }
            catch (IOException iOException) {
                this.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.mError.setText(exception.toString());
            }
        } else if (string.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        for (int i = 0; i < this.connTypes.length; ++i) {
            if (!string.equals(this.connTypes[i][0])) continue;
            this.mDriver.setText(this.connTypes[i][1]);
            this.mURL.setText(this.connTypes[i][2]);
        }
    }
}

