/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;

public class MailUtil {
    private static final Pattern EMAIL = Pattern.compile("(?i)([^<@\\s]+@[^@> ]+)");

    public static void setPersonAndEmail(String string, Property personProperty, Property emailProperty, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        String email = MailUtil.extractEmail(string, sb);
        String person = MailUtil.clean(sb.toString());
        if (person != null && person.length() > 0) {
            metadata.set(personProperty, person);
        }
        if (email != null && email.length() > 0) {
            metadata.set(emailProperty, email);
        }
    }

    public static void addPersonAndEmail(String string, Property personProperty, Property emailProperty, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        String email = MailUtil.extractEmail(string, sb);
        String person = MailUtil.clean(sb.toString());
        if (person != null && person.length() > 0) {
            metadata.add(personProperty, person);
        }
        if (email != null && email.length() > 0) {
            metadata.add(emailProperty, email);
        }
    }

    private static String clean(String s) {
        s = s.replaceAll("[<>\"]", " ");
        s = s.trim();
        return s;
    }

    private static String extractEmail(String string, StringBuffer sb) {
        Matcher emailMatcher = EMAIL.matcher(string);
        String email = "";
        while (emailMatcher.find()) {
            emailMatcher.appendReplacement(sb, "");
            email = emailMatcher.group(1);
        }
        emailMatcher.appendTail(sb);
        return email;
    }

    public static boolean containsEmail(String chunk) {
        if (chunk == null) {
            return false;
        }
        return EMAIL.matcher(chunk).find();
    }
}

