/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class HsqlQueryExpression
extends JDBCQueryExpression {
    public HsqlQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        return this.getStandardStatement(lock, false).toString();
    }

    protected StringBuffer getStandardStatement(boolean lock, boolean oj) {
        int j;
        String tableName;
        JDBCQueryExpression.Join join;
        int i;
        Vector<String> done = new Vector<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._limit != null) {
            if (this._offset != null) {
                sql.append(" LIMIT ");
                sql.append(this._offset).append(" ");
                sql.append(this._limit).append(" ");
            } else {
                sql.append(" TOP ").append(this._limit).append(" ");
            }
        }
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        if (this._select == null) {
            sql.append(this.getColumnList());
        } else {
            sql.append(this._select).append(" ");
        }
        sql.append(" FROM ");
        Hashtable tables = (Hashtable)this._tables.clone();
        boolean first = true;
        for (i = 0; i < this._joins.size(); ++i) {
            join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (!join.outer || done.contains(join.leftTable)) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (oj) {
                sql.append("{oj ");
            }
            sql.append(this._factory.quoteName(join.leftTable));
            sql.append(" LEFT OUTER JOIN ");
            tableName = (String)tables.get(join.rightTable);
            if (join.rightTable.equals(tableName)) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(join.rightTable));
            }
            sql.append(" ON ");
            for (j = 0; j < join.leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[j])).append("=");
                sql.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[j]));
            }
            tables.remove(join.leftTable);
            tables.remove(join.rightTable);
            for (int k = i + 1; k < this._joins.size(); ++k) {
                JDBCQueryExpression.Join join2 = (JDBCQueryExpression.Join)this._joins.elementAt(k);
                if (!join2.outer || !join.leftTable.equals(join2.leftTable)) continue;
                sql.append(" LEFT OUTER JOIN ");
                tableName = (String)tables.get(join2.rightTable);
                if (join2.rightTable.equals(tableName)) {
                    sql.append(this._factory.quoteName(tableName));
                } else {
                    sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(join2.rightTable));
                }
                sql.append(" ON ");
                for (int j2 = 0; j2 < join2.leftColumns.length; ++j2) {
                    if (j2 > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this._factory.quoteName(join2.leftTable + "." + join2.leftColumns[j2])).append("=");
                    sql.append(this._factory.quoteName(join2.rightTable + "." + join2.rightColumns[j2]));
                }
                tables.remove(join2.rightTable);
            }
            if (oj) {
                sql.append("}");
            }
            done.addElement(join.leftTable);
        }
        Enumeration enumeration = tables.keys();
        while (enumeration.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            String tableAlias = (String)enumeration.nextElement();
            tableName = (String)tables.get(tableAlias);
            if (tableAlias.equals(tableName)) {
                sql.append(this._factory.quoteName(tableName));
                continue;
            }
            sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        first = true;
        for (i = 0; i < this._joins.size(); ++i) {
            join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (join.outer) continue;
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            for (j = 0; j < join.leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[j])).append("=");
                sql.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[j]));
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        return sql;
    }

    public boolean isLimitClauseSupported() {
        return true;
    }

    public boolean isOffsetClauseSupported() {
        return true;
    }
}

