/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.async.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import org.apache.chemistry.opencmis.server.async.AsyncCmisExecutor;
import org.apache.chemistry.opencmis.server.async.impl.SimpleCmisAsyncListener;

public class SimpleAsyncCmisExecutor
implements AsyncCmisExecutor {
    private static int cmisThreadInitNumber = 0;
    private ExecutorService executorService = this.createExecutorService();
    private long timeout = 86400000L;

    private static synchronized int nextThreadNum() {
        return cmisThreadInitNumber++;
    }

    private ExecutorService createExecutorService() {
        final ThreadGroup threadGroup = new ThreadGroup("cmis-thread-group");
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(threadGroup, r, "cmis-" + SimpleAsyncCmisExecutor.nextThreadNum());
            }
        };
        int processors = Runtime.getRuntime().availableProcessors();
        int maximumPoolSize = processors * 100;
        int corePoolSize = processors;
        int queueSize = maximumPoolSize / 2;
        ThreadPoolExecutor threadPoolexecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
        return threadPoolexecutor;
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void execute(AsyncContext asyncContext, Runnable runable) {
        asyncContext.setTimeout(this.timeout);
        asyncContext.addListener((AsyncListener)new SimpleCmisAsyncListener());
        this.executorService.submit(runable);
    }
}

