/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.tikaservice.rmeta;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.agents.transformation.tikaservice.rmeta.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.json.simple.parser.ParseException;

public class TikaExtractor
extends BaseTransformationConnector {
    public static final String _rcsid = "@(#)$Id$";
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_SERVER_HTML = "editConfiguration_Server.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_TIKASERVER_HTML = "editSpecification_TikaServer.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    protected static final String ACTIVITY_EXTRACT = "extract";
    protected static final String[] activitiesList = new String[]{"extract"};
    protected static final long sessionExpirationInterval = 300000L;
    protected static final long inMemoryMaximumFile = 65536L;
    private static final int maxMetadataNameLength = 8000;
    private String tikaHostname = null;
    private String tikaPortString = null;
    private String connectionTimeoutString = null;
    private String socketTimeoutString = null;
    private String retryIntervalString = null;
    private String retryIntervalTikaDownString = null;
    private String retryNumberString = null;
    private long sessionTimeout = -1L;
    private int tikaPort = -1;
    private int connectionTimeout = -1;
    private int socketTimeout = -1;
    private long retryInterval = -1L;
    private long retryIntervalTikaDown = -1L;
    private int retryNumber = -1;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClientBuilder builder = null;
    private CloseableHttpClient httpClient = null;
    private HttpHost tikaHost = null;
    protected static final URI rmetaURI;
    private static final Set<String> archiveMimes;
    static final Set<String> archiveExtensions;

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.tikaHostname = configParameters.getParameter("tikaHostname");
        this.tikaPortString = configParameters.getParameter("tikaPort");
        this.connectionTimeoutString = configParameters.getParameter("connectionTimeout");
        this.socketTimeoutString = configParameters.getParameter("socketTimeout");
        this.retryIntervalString = configParameters.getParameter("retryInterval");
        this.retryIntervalTikaDownString = configParameters.getParameter("retryIntervalTikaDown");
        this.retryNumberString = configParameters.getParameter("retryNumber");
    }

    public void disconnect() throws ManifoldCFException {
        this.expireSession();
        this.tikaHostname = null;
        this.tikaPortString = null;
        this.connectionTimeoutString = null;
        this.socketTimeoutString = null;
        this.retryIntervalString = null;
        this.retryIntervalTikaDownString = null;
        this.retryNumberString = null;
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (System.currentTimeMillis() >= this.sessionTimeout) {
            this.expireSession();
        }
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isConnected() {
        return this.sessionTimeout != -1L;
    }

    protected void getSession() throws ManifoldCFException {
        if (this.sessionTimeout == -1L) {
            if (this.tikaHostname == null || this.tikaHostname.length() == 0) {
                throw new ManifoldCFException("Missing host name");
            }
            if (this.tikaPortString == null) {
                throw new ManifoldCFException("Missing port value");
            }
            try {
                this.tikaPort = Integer.parseInt(this.tikaPortString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad port number: " + this.tikaPortString);
            }
            try {
                this.connectionTimeout = Integer.parseInt(this.connectionTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad connection timeout number: " + this.connectionTimeoutString);
            }
            try {
                this.socketTimeout = Integer.parseInt(this.socketTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad socket timeout number: " + this.socketTimeoutString);
            }
            try {
                this.retryInterval = Long.parseLong(this.retryIntervalString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad retry interval number: " + this.retryIntervalString);
            }
            try {
                this.retryIntervalTikaDown = Long.parseLong(this.retryIntervalTikaDownString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad retry interval when tika is down number: " + this.retryIntervalTikaDownString);
            }
            try {
                this.retryNumber = Integer.parseInt(this.retryNumberString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad retry number: " + this.retryNumberString);
            }
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(this.socketTimeout).setExpectContinueEnabled(false).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.socketTimeout);
            this.builder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build());
            this.builder.setRequestExecutor(new HttpRequestExecutor(this.socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
            this.httpClient = this.builder.build();
            this.tikaHost = new HttpHost(this.tikaHostname, this.tikaPort);
        }
        this.sessionTimeout = System.currentTimeMillis() + 300000L;
    }

    protected void expireSession() throws ManifoldCFException {
        this.tikaPort = -1;
        this.httpClient = null;
        this.tikaHost = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        this.sessionTimeout = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String check() throws ManifoldCFException {
        this.getSession();
        HttpPut httpPut = new HttpPut(rmetaURI);
        InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream("this is a test".getBytes(StandardCharsets.UTF_8)));
        httpPut.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            try {
                response = this.httpClient.execute(this.tikaHost, (HttpRequest)httpPut);
            }
            catch (IOException e) {
                String string = "Connection error: " + e.getMessage();
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e2) {
                        return "Connection error: " + e2.getMessage();
                    }
                }
                return string;
            }
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                String string = "Bad response: " + response.getStatusLine();
                return string;
            }
            String string = super.check();
            return string;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    return "Connection error: " + e.getMessage();
                }
            }
        }
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "TikaExtractor.TikaServerTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_JS, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        TikaExtractor.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_SERVER_HTML, velocityContext);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String retryNumber;
        String retryIntervalTikaDown;
        String retryInterval;
        String socketTimeout;
        String connectionTimeout;
        String tikaPort;
        String tikaHostname = variableContext.getParameter("tikaHostname");
        if (tikaHostname != null) {
            parameters.setParameter("tikaHostname", tikaHostname);
        }
        if ((tikaPort = variableContext.getParameter("tikaPort")) != null) {
            parameters.setParameter("tikaPort", tikaPort);
        }
        if ((connectionTimeout = variableContext.getParameter("connectionTimeout")) != null) {
            parameters.setParameter("connectionTimeout", connectionTimeout);
        }
        if ((socketTimeout = variableContext.getParameter("socketTimeout")) != null) {
            parameters.setParameter("socketTimeout", socketTimeout);
        }
        if ((retryInterval = variableContext.getParameter("retryInterval")) != null) {
            parameters.setParameter("retryInterval", retryInterval);
        }
        if ((retryIntervalTikaDown = variableContext.getParameter("retryIntervalTikaDown")) != null) {
            parameters.setParameter("retryIntervalTikaDown", retryIntervalTikaDown);
        }
        if ((retryNumber = variableContext.getParameter("retryNumber")) != null) {
            parameters.setParameter("retryNumber", retryNumber);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        TikaExtractor.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String retryNumber;
        String retryIntervalTikaDown;
        String retryInterval;
        String socketTimeout;
        String connectionTimeout;
        String tikaPort;
        String tikaHostname = parameters.getParameter("tikaHostname");
        if (tikaHostname == null) {
            tikaHostname = "localhost";
        }
        if ((tikaPort = parameters.getParameter("tikaPort")) == null) {
            tikaPort = "9998";
        }
        if ((connectionTimeout = parameters.getParameter("connectionTimeout")) == null) {
            connectionTimeout = "60000";
        }
        if ((socketTimeout = parameters.getParameter("socketTimeout")) == null) {
            socketTimeout = "60000";
        }
        if ((retryInterval = parameters.getParameter("retryInterval")) == null) {
            retryInterval = "20000";
        }
        if ((retryIntervalTikaDown = parameters.getParameter("retryIntervalTikaDown")) == null) {
            retryIntervalTikaDown = "120000";
        }
        if ((retryNumber = parameters.getParameter("retryNumber")) == null) {
            retryNumber = "1";
        }
        velocityContext.put("TIKAHOSTNAME", tikaHostname);
        velocityContext.put("TIKAPORT", tikaPort);
        velocityContext.put("CONNECTIONTIMEOUT", connectionTimeout);
        velocityContext.put("SOCKETTIMEOUT", socketTimeout);
        velocityContext.put("RETRYINTERVAL", retryInterval);
        velocityContext.put("RETRYINTERVALTIKADOWN", retryIntervalTikaDown);
        velocityContext.put("RETRYNUMBER", retryNumber);
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(os);
        return new VersionContext(sp.toPackedString(), this.params, os);
    }

    public boolean checkMimeTypeIndexable(VersionContext pipelineDescription, String mimeType, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        return checkActivity.checkMimeTypeIndexable("text/plain;charset=utf-8");
    }

    public boolean checkDocumentIndexable(VersionContext pipelineDescription, File localFile, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        return true;
    }

    public boolean checkLengthIndexable(VersionContext pipelineDescription, long length, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        return true;
    }

    private void triggerServiceInterruption(String documentURI, Exception e) throws ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server unreachable while trying to process " + documentURI + ", retrying..."), (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("Tika Server connection down: " + e.getMessage(), (Throwable)e, currentTime + this.retryIntervalTikaDown, -1L, this.retryNumber, false);
    }

    private void retryWithoutAbort(Exception e) throws ServiceInterruption {
        Logging.ingest.warn((Object)"Tika Server connection interrupted, retrying...", (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("Tika Server connection interrupted: " + e.getMessage(), (Throwable)e, currentTime + this.retryInterval, -1L, this.retryNumber, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        if (!activities.checkMimeTypeIndexable("text/plain;charset=utf-8")) {
            activities.noDocument();
            activities.recordActivity(null, ACTIVITY_EXTRACT, null, documentURI, "EXCLUDEDMIMETYPE", "Downstream pipeline rejected mime type 'text/plain;charset=utf-8'");
            return 1;
        }
        SpecPacker sp = new SpecPacker(pipelineDescription.getSpecification());
        this.getSession();
        CloseableHttpResponse response = null;
        try (DestinationStorage ds = document.getBinaryLength() <= 65536L ? new MemoryDestinationStorage((int)document.getBinaryLength()) : new FileDestinationStorage();){
            int sendDocumentResultCode;
            InputStream is;
            block114: {
                int n;
                HashMap metadata = new HashMap();
                if (document.getFileName() != null) {
                    metadata.put("resourceName", new ArrayList());
                    metadata.put("stream_name", new ArrayList());
                    ((List)metadata.get("resourceName")).add(document.getFileName());
                    ((List)metadata.get("stream_name")).add(document.getFileName());
                }
                metadata.put("stream_size", new ArrayList());
                ((List)metadata.get("stream_size")).add(String.valueOf(document.getBinaryLength()));
                long startTime = System.currentTimeMillis();
                String resultCode = "OK";
                String description = "";
                Long length = 0L;
                boolean truncated = false;
                boolean resources_limit = false;
                int tikaServerResultCode = 0;
                try {
                    block112: {
                        try {
                            if (!this.isArchive(document.getFileName(), document.getMimeType()) || this.isArchive(document.getFileName(), document.getMimeType()) && sp.extractArchives) {
                                HttpPut httpPut = new HttpPut(rmetaURI);
                                if (sp.writeLimit != -1) {
                                    httpPut.addHeader("writeLimit", String.valueOf(sp.writeLimit));
                                }
                                if (sp.maxEmbeddedResources != -1) {
                                    httpPut.addHeader("maxEmbeddedResources", String.valueOf(sp.maxEmbeddedResources));
                                }
                                InputStreamEntity entity = new InputStreamEntity(document.getBinaryStream());
                                httpPut.setEntity((HttpEntity)entity);
                                try {
                                    response = this.httpClient.execute(this.tikaHost, (HttpRequest)httpPut);
                                }
                                catch (SocketTimeoutException e) {
                                    resultCode = "TIKASERVERRESPONSETIMEOUT";
                                    description = "Socket timeout while processing document " + documentURI + " : " + e.getMessage();
                                    tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                }
                                catch (SocketException e) {
                                    if (!(e instanceof ConnectException || e instanceof BindException || e instanceof NoRouteToHostException || e instanceof PortUnreachableException)) {
                                        resultCode = "TIKASERVERSOCKETEXCEPTION";
                                        description = "Socket exception while processing document " + documentURI + " : " + e.getMessage();
                                        tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                        this.retryWithoutAbort(e);
                                    } else {
                                        resultCode = "TIKASERVEREXCEPTION";
                                        description = "Tika seemed to be down when requested to process document " + documentURI + " : " + e.getMessage();
                                        tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                        this.triggerServiceInterruption(documentURI, e);
                                    }
                                }
                                catch (NoHttpResponseException e) {
                                    resultCode = "TIKASERVERNORESPONSEEXCEPTION";
                                    description = "Tika does not manage to treat " + documentURI + " (potential task timeout): " + e.getMessage();
                                    tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                }
                                catch (IOException e) {
                                    resultCode = "TIKASERVEREXCEPTION";
                                    description = "Unknown Tika problem when processing document " + documentURI + " : " + e.getMessage();
                                    tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                    this.triggerServiceInterruption(documentURI, e);
                                }
                                if (response == null) break block112;
                                int responseCode = response.getStatusLine().getStatusCode();
                                if (responseCode == 200 || responseCode == 204) {
                                    OutputStream os = ds.getOutputStream();
                                    Object object = null;
                                    try (OutputStreamWriter w2 = new OutputStreamWriter(os, StandardCharsets.UTF_8.name());
                                         InputStream is2 = response.getEntity().getContent();){
                                        JsonFactory jfactory = new JsonFactory();
                                        JsonParser jParser = jfactory.createParser(is2);
                                        JsonToken token = null;
                                        boolean inMetadata = false;
                                        while (!inMetadata && (token = jParser.nextToken()) != null) {
                                            if (token != JsonToken.START_OBJECT) continue;
                                            inMetadata = true;
                                        }
                                        int totalMetadataLength = 0;
                                        boolean maxMetadataReached = false;
                                        boolean metadataSkipped = false;
                                        boolean metadataTruncated = false;
                                        if (token != null) {
                                            while ((token = jParser.nextToken()) != null && token != JsonToken.END_OBJECT) {
                                                int fieldNameLength = jParser.getTextLength();
                                                if (fieldNameLength <= 8000) {
                                                    String fieldName = jParser.getCurrentName();
                                                    if (fieldName == null) continue;
                                                    if (fieldName.startsWith("X-Parsed-By")) {
                                                        this.skipMetadata(jParser);
                                                        continue;
                                                    }
                                                    if (fieldName.contentEquals("X-TIKA:content")) {
                                                        jParser.nextToken();
                                                        length = length + (long)jParser.getText((Writer)w2);
                                                        continue;
                                                    }
                                                    if (!fieldName.startsWith("X-TIKA")) {
                                                        int totalMetadataLengthPreview;
                                                        token = jParser.nextToken();
                                                        if (!metadata.containsKey(fieldName)) {
                                                            totalMetadataLength += fieldName.length();
                                                            metadata.put(fieldName, new ArrayList());
                                                        }
                                                        if (token == JsonToken.START_ARRAY) {
                                                            while (jParser.nextToken() != JsonToken.END_ARRAY) {
                                                                if (jParser.getTextLength() <= sp.maxMetadataValueLength) {
                                                                    totalMetadataLengthPreview = totalMetadataLength + jParser.getTextLength();
                                                                    if (totalMetadataLengthPreview <= sp.totalMetadataLimit) {
                                                                        ((List)metadata.get(fieldName)).add(jParser.getText());
                                                                        totalMetadataLength = totalMetadataLengthPreview;
                                                                        continue;
                                                                    }
                                                                    maxMetadataReached = true;
                                                                    continue;
                                                                }
                                                                metadataSkipped = true;
                                                                if (!Logging.ingest.isDebugEnabled()) continue;
                                                                Logging.ingest.debug((Object)("Skip value of metadata " + fieldName + " of document " + documentURI + " because it exceeds the max value limit of " + sp.maxMetadataValueLength));
                                                            }
                                                        } else if (jParser.getTextLength() <= sp.maxMetadataValueLength) {
                                                            totalMetadataLengthPreview = totalMetadataLength + jParser.getTextLength();
                                                            if (totalMetadataLengthPreview <= sp.totalMetadataLimit) {
                                                                ((List)metadata.get(fieldName)).add(jParser.getText());
                                                            } else {
                                                                maxMetadataReached = true;
                                                            }
                                                        } else {
                                                            metadataSkipped = true;
                                                            if (Logging.ingest.isDebugEnabled()) {
                                                                Logging.ingest.debug((Object)("Skip value of metadata " + fieldName + " of document " + documentURI + " because it exceeds the max value limit of " + sp.maxMetadataValueLength));
                                                            }
                                                        }
                                                        if (!((List)metadata.get(fieldName)).isEmpty()) continue;
                                                        totalMetadataLength -= fieldName.length();
                                                        metadata.remove(fieldName);
                                                        continue;
                                                    }
                                                    if (fieldName.startsWith("X-TIKA:EXCEPTION:")) {
                                                        boolean unknownException = false;
                                                        if (fieldName.contentEquals("X-TIKA:EXCEPTION:write_limit_reached")) {
                                                            resultCode = "TRUNCATEDOK";
                                                            truncated = true;
                                                        } else if (fieldName.contentEquals("X-TIKA:EXCEPTION:embedded_resource_limit_reached")) {
                                                            resources_limit = true;
                                                        } else {
                                                            unknownException = true;
                                                            resultCode = "TIKAEXCEPTION";
                                                            jParser.nextToken();
                                                            description = description + fieldName + ": " + jParser.getText() + System.lineSeparator();
                                                        }
                                                        if (unknownException) continue;
                                                        this.skipMetadata(jParser);
                                                        continue;
                                                    }
                                                    if (fieldName.startsWith("X-TIKA:WARN:truncated_metadata")) {
                                                        metadataTruncated = true;
                                                        this.skipMetadata(jParser);
                                                        continue;
                                                    }
                                                    this.skipMetadata(jParser);
                                                    continue;
                                                }
                                                metadataSkipped = true;
                                                if (Logging.ingest.isDebugEnabled()) {
                                                    Logging.ingest.debug((Object)("Skip a metadata of document " + documentURI + " because its name exceeds the max allowed length of " + 8000));
                                                }
                                                this.skipMetadata(jParser);
                                            }
                                            jParser.close();
                                        }
                                        if (maxMetadataReached) {
                                            description = description + "Some metadata have been skipped because the total metadata limit of " + sp.totalMetadataLimit + " has been reached" + System.lineSeparator();
                                        } else if (metadataSkipped) {
                                            description = description + "Some metadata have been skipped because their names or values exceeded the limits" + System.lineSeparator();
                                        }
                                        if (metadataTruncated) {
                                            description = description + "Some metadata have been truncated by Tika because they exceeded the limits specified in the Tika conf" + System.lineSeparator();
                                        }
                                        break block112;
                                    }
                                    catch (Throwable w2) {
                                        object = w2;
                                        throw w2;
                                    }
                                    finally {
                                        if (os != null) {
                                            if (object != null) {
                                                try {
                                                    os.close();
                                                }
                                                catch (Throwable w2) {
                                                    ((Throwable)object).addSuppressed(w2);
                                                }
                                            } else {
                                                os.close();
                                            }
                                        }
                                    }
                                }
                                if (responseCode == 503) {
                                    resultCode = "TIKASERVERUNAVAILABLE";
                                    description = "Tika Server was unavailable: 503 " + response.getStatusLine().getReasonPhrase();
                                    tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                    Logging.ingest.warn((Object)"Tika Server unavailable, retrying...");
                                    long currentTime = System.currentTimeMillis();
                                    throw new ServiceInterruption("Tika Server unavailable, retrying...", (Throwable)new Exception(description), currentTime + this.retryInterval, -1L, -1, false);
                                }
                                if (responseCode == 500) {
                                    resultCode = "TIKASERVERERROR";
                                    description = "Tika Server failed to parse document with the following error: " + response.getStatusLine().getReasonPhrase();
                                    tikaServerResultCode = TikaExtractor.handleTikaServerError(description);
                                } else {
                                    resultCode = "TIKASERVERREJECTS";
                                    description = "Tika Server rejected document " + documentURI + " with the following reason: " + response.getStatusLine().getReasonPhrase();
                                    tikaServerResultCode = TikaExtractor.handleTikaServerRejects(description);
                                }
                                break block112;
                            }
                            resultCode = "EXCLUDED";
                            description = "Detected as an archive file and the extract archives option is set to false";
                        }
                        catch (IOException e) {
                            resultCode = "TIKASERVERRESPONSEISSUE";
                            if (e.getMessage() != null) {
                                description = e.getMessage();
                            }
                            tikaServerResultCode = TikaExtractor.handleTikaServerException(e);
                        }
                        finally {
                            if (response != null) {
                                response.close();
                            }
                        }
                    }
                    if (!activities.checkLengthIndexable(ds.getBinaryLength())) {
                        activities.noDocument();
                        resultCode = "EXCLUDEDLENGTH";
                        description = "Downstream pipeline rejected document with length " + ds.getBinaryLength();
                        int e = 1;
                        return e;
                    }
                }
                finally {
                    description = description.replaceAll("[^\\x20-\\x7e]", "");
                    activities.recordActivity(Long.valueOf(startTime), ACTIVITY_EXTRACT, length, documentURI, resultCode, description);
                }
                RepositoryDocument docCopy = document.duplicate();
                is = ds.getInputStream();
                long newBinaryLength = ds.getBinaryLength();
                try {
                    docCopy.setBinary(is, newBinaryLength);
                    for (String mName : metadata.keySet()) {
                        String target;
                        Object[] values = ((List)metadata.get(mName)).toArray(new String[0]);
                        if (mName.length() >= 8000) continue;
                        if (sp.lowerNames()) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < mName.length(); ++i) {
                                char ch = mName.charAt(i);
                                ch = !Character.isLetterOrDigit(ch) ? (char)'_' : (char)Character.toLowerCase(ch);
                                sb.append(ch);
                            }
                            mName = sb.toString();
                        }
                        if ((target = sp.getMapping(mName)) != null) {
                            if (docCopy.getField(target) != null) {
                                Object[] persistentValues = docCopy.getFieldAsStrings(target);
                                values = (String[])ArrayUtils.addAll((Object[])persistentValues, (Object[])values);
                            }
                            docCopy.addField(target, (String[])values);
                            continue;
                        }
                        if (!sp.keepAllMetadata()) continue;
                        if (docCopy.getField(mName) != null) {
                            Object[] persistentValues = docCopy.getFieldAsStrings(mName);
                            values = (String[])ArrayUtils.addAll((Object[])persistentValues, (Object[])values);
                        }
                        docCopy.addField(mName, (String[])values);
                    }
                    if (truncated) {
                        this.removeField(docCopy, "truncated");
                        docCopy.addField("truncated", "true");
                    } else {
                        this.removeField(docCopy, "truncated");
                        docCopy.addField("truncated", "false");
                    }
                    if (resources_limit) {
                        this.removeField(docCopy, "resources_limit");
                        docCopy.addField("resources_limit", "true");
                    } else {
                        this.removeField(docCopy, "resources_limit");
                        docCopy.addField("resources_limit", "false");
                    }
                    sendDocumentResultCode = activities.sendDocument(documentURI, docCopy);
                    if (sendDocumentResultCode != 0) break block114;
                    n = tikaServerResultCode;
                }
                catch (Throwable throwable) {
                    is.close();
                    throw throwable;
                }
                is.close();
                return n;
            }
            int n = sendDocumentResultCode;
            is.close();
            return n;
        }
    }

    private void skipMetadata(JsonParser jParser) throws IOException {
        JsonToken token = jParser.nextToken();
        if (token == JsonToken.START_OBJECT) {
            while (token != JsonToken.END_OBJECT) {
                token = jParser.nextToken();
            }
        }
        if (token == JsonToken.START_ARRAY) {
            while (token != JsonToken.END_ARRAY) {
                token = jParser.nextToken();
            }
        }
    }

    private void removeField(RepositoryDocument document, String fieldName) {
        Iterator fields = document.getFields();
        while (fields.hasNext()) {
            String fieldname = (String)fields.next();
            if (!fieldname.equalsIgnoreCase(fieldName)) continue;
            document.removeField(fieldname);
            break;
        }
    }

    private String getExtension(String filename) {
        int index;
        String extension = "";
        if (filename != null && (index = filename.lastIndexOf(46)) != -1) {
            extension = filename.substring(index + 1).toLowerCase(Locale.ROOT);
        }
        return extension;
    }

    private boolean isArchive(String filename, String mimeType) {
        boolean filenameCheck = archiveExtensions.contains(this.getExtension(filename));
        boolean mimeCheck = archiveMimes.contains(mimeType.toLowerCase(Locale.ROOT));
        return filenameCheck || mimeCheck;
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "TikaExtractor.TikaServerTabName"));
        TikaExtractor.fillInTikaSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        TikaExtractor.fillInTikaSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_TIKASERVER_HTML, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "fieldmapping_count");
        if (x != null && x.length() > 0) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node = os.getChild(i);
                if (node.getType().equals("fieldmap") || node.getType().equals("keepAllMetadata") || node.getType().equals("lowerNames") || node.getType().equals("writeLimit")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String prefix = seqPrefix + "fieldmapping_";
                String suffix = "_" + Integer.toString(i);
                String op = variableContext.getParameter(prefix + "op" + suffix);
                if (op != null && op.equals("Delete")) continue;
                String source = variableContext.getParameter(prefix + "source" + suffix);
                String target = variableContext.getParameter(prefix + "target" + suffix);
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            String addop = variableContext.getParameter(seqPrefix + "fieldmapping_op");
            if (addop != null && addop.equals("Add")) {
                String source = variableContext.getParameter(seqPrefix + "fieldmapping_source");
                String target = variableContext.getParameter(seqPrefix + "fieldmapping_target");
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            SpecificationNode node = new SpecificationNode("keepAllMetadata");
            String keepAll = variableContext.getParameter(seqPrefix + "keepallmetadata");
            if (keepAll != null) {
                node.setAttribute("value", keepAll);
            } else {
                node.setAttribute("value", "false");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node);
            SpecificationNode node2 = new SpecificationNode("lowerNames");
            String lower = variableContext.getParameter(seqPrefix + "lowernames");
            if (lower != null) {
                node2.setAttribute("value", lower);
            } else {
                node2.setAttribute("value", "false");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node2);
            SpecificationNode node3 = new SpecificationNode("writeLimit");
            String writeLimit = variableContext.getParameter(seqPrefix + "writelimit");
            if (writeLimit != null) {
                node3.setAttribute("value", writeLimit);
            } else {
                node3.setAttribute("value", "");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node3);
            SpecificationNode maxMetadataValueNode = new SpecificationNode("maxMetadataValueLength");
            String maxMetadataValue = variableContext.getParameter(seqPrefix + "maxmetadatavaluelength");
            if (maxMetadataValue != null) {
                maxMetadataValueNode.setAttribute("value", maxMetadataValue);
            } else {
                maxMetadataValueNode.setAttribute("value", "250000");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)maxMetadataValueNode);
            SpecificationNode metadataLimitNode = new SpecificationNode("totalMetadataLimit");
            String metadataLimit = variableContext.getParameter(seqPrefix + "totalmetadatalimit");
            if (metadataLimit != null) {
                metadataLimitNode.setAttribute("value", metadataLimit);
            } else {
                metadataLimitNode.setAttribute("value", "500000");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)metadataLimitNode);
            SpecificationNode node4 = new SpecificationNode("extractArchives");
            String extractArch = variableContext.getParameter(seqPrefix + "extractArchives");
            if (extractArch != null) {
                node4.setAttribute("value", extractArch);
            } else {
                node4.setAttribute("value", "false");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node4);
            SpecificationNode node5 = new SpecificationNode("maxEmbeddedResources");
            String maxEmbeddedResources = variableContext.getParameter(seqPrefix + "maxEmbeddedResources");
            if (maxEmbeddedResources != null) {
                node5.setAttribute("value", maxEmbeddedResources);
            } else {
                node5.setAttribute("value", "0");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node5);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        TikaExtractor.fillInTikaSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, paramMap);
    }

    protected static void fillInTikaSpecificationMap(Map<String, Object> paramMap, Specification os) {
        ArrayList fieldMappings = new ArrayList();
        String keepAllMetadataValue = "true";
        String lowernamesValue = "true";
        String writeLimitValue = "1000000";
        String maxMetadataValueLength = "250000";
        String totalMetadataLimit = "500000";
        String extractArchives = "false";
        String maxEmbeddedResources = "";
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals("fieldmap")) {
                String targetDisplay;
                String source = sn.getAttributeValue("source");
                String target = sn.getAttributeValue("target");
                if (target == null) {
                    target = "";
                    targetDisplay = "(remove)";
                } else {
                    targetDisplay = target;
                }
                HashMap<String, String> fieldMapping = new HashMap<String, String>();
                fieldMapping.put("SOURCE", source);
                fieldMapping.put("TARGET", target);
                fieldMapping.put("TARGETDISPLAY", targetDisplay);
                fieldMappings.add(fieldMapping);
                continue;
            }
            if (sn.getType().equals("keepAllMetadata")) {
                keepAllMetadataValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("lowerNames")) {
                lowernamesValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("writeLimit")) {
                writeLimitValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("extractArchives")) {
                extractArchives = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("maxEmbeddedResources")) {
                maxEmbeddedResources = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("maxMetadataValueLength")) {
                maxMetadataValueLength = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("totalMetadataLimit")) continue;
            totalMetadataLimit = sn.getAttributeValue("value");
        }
        paramMap.put("FIELDMAPPINGS", fieldMappings);
        paramMap.put("KEEPALLMETADATA", keepAllMetadataValue);
        paramMap.put("LOWERNAMES", lowernamesValue);
        paramMap.put("WRITELIMIT", writeLimitValue);
        paramMap.put("MAXMETADATAVALUELENGTH", maxMetadataValueLength);
        paramMap.put("TOTALMETADATALIMIT", totalMetadataLimit);
        paramMap.put("EXTRACTARCHIVES", extractArchives);
        paramMap.put("MAXEMBEDDEDRESOURCES", maxEmbeddedResources);
    }

    protected static int handleTikaServerRejects(String reason) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server: Tika Server rejects: " + reason));
        return 1;
    }

    protected static int handleTikaServerError(String description) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server: Tika Server error: " + description));
        return 1;
    }

    protected static int handleTikaServerException(IOException e) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server: Tika exception extracting: " + e.getMessage()), (Throwable)e);
        return 1;
    }

    protected static int handleTikaServerException(ParseException e) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server: Tika exception extracting: " + e.getMessage()), (Throwable)e);
        return 1;
    }

    protected static int handleIOException(IOException e) throws ManifoldCFException {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    static {
        archiveMimes = new HashSet<String>();
        archiveMimes.add("application/gzip");
        archiveMimes.add("application/zip");
        archiveMimes.add("application/x-gtar");
        archiveMimes.add("application/x-7z-compressed");
        archiveMimes.add("application/x-xz");
        archiveMimes.add("application/x-bzip2");
        archiveMimes.add("application/x-cpio");
        archiveMimes.add("application/x-java-pack200");
        archiveMimes.add("application/java-archive");
        archiveMimes.add("application/x-archive");
        archiveMimes.add("application/vnd.ms-outlook");
        archiveExtensions = new HashSet<String>();
        archiveExtensions.add("zip");
        archiveExtensions.add("gz");
        archiveExtensions.add("tar");
        archiveExtensions.add("gtar");
        archiveExtensions.add("7z");
        archiveExtensions.add("xz");
        archiveExtensions.add("boz");
        archiveExtensions.add("bz2");
        archiveExtensions.add("cpio");
        archiveExtensions.add("jar");
        archiveExtensions.add("ar");
        archiveExtensions.add("a");
        archiveExtensions.add("pab");
        archiveExtensions.add("ost");
        archiveExtensions.add("pst");
        try {
            rmetaURI = new URI("/rmeta/body");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected static class SpecPacker {
        private final Map<String, String> sourceTargets = new HashMap<String, String>();
        private final boolean keepAllMetadata;
        private final boolean lowerNames;
        private final int writeLimit;
        private final boolean extractArchives;
        private final int maxEmbeddedResources;
        private final int maxMetadataValueLength;
        private final int totalMetadataLimit;

        public SpecPacker(Specification os) {
            boolean keepAllMetadata = true;
            boolean lowerNames = false;
            boolean extractArchives = true;
            int writeLimit = -1;
            int maxEmbeddedResources = -1;
            int maxMetadataValueLength = Integer.parseInt("250000");
            int totalMetadataLimit = Integer.parseInt("500000");
            for (int i = 0; i < os.getChildCount(); ++i) {
                String value;
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("keepAllMetadata")) {
                    value = sn.getAttributeValue("value");
                    keepAllMetadata = Boolean.parseBoolean(value);
                    continue;
                }
                if (sn.getType().equals("lowerNames")) {
                    value = sn.getAttributeValue("value");
                    lowerNames = Boolean.parseBoolean(value);
                    continue;
                }
                if (sn.getType().equals("writeLimit")) {
                    value = sn.getAttributeValue("value");
                    if (value.length() == 0) {
                        writeLimit = -1;
                        continue;
                    }
                    writeLimit = Integer.parseInt(value);
                    continue;
                }
                if (sn.getType().equals("maxMetadataValueLength")) {
                    value = sn.getAttributeValue("value");
                    if (value.length() == 0) {
                        maxMetadataValueLength = Integer.parseInt("250000");
                        continue;
                    }
                    maxMetadataValueLength = Integer.parseInt(value);
                    continue;
                }
                if (sn.getType().equals("totalMetadataLimit")) {
                    value = sn.getAttributeValue("value");
                    if (value.length() == 0) {
                        totalMetadataLimit = Integer.parseInt("500000");
                        continue;
                    }
                    totalMetadataLimit = Integer.parseInt(value);
                    continue;
                }
                if (sn.getType().equals("extractArchives")) {
                    value = sn.getAttributeValue("value");
                    extractArchives = Boolean.parseBoolean(value);
                    continue;
                }
                if (sn.getType().equals("fieldmap")) {
                    String source = sn.getAttributeValue("source");
                    String target = sn.getAttributeValue("target");
                    if (target == null) {
                        target = "";
                    }
                    this.sourceTargets.put(source, target);
                    continue;
                }
                if (!sn.getType().equals("maxEmbeddedResources")) continue;
                value = sn.getAttributeValue("value");
                maxEmbeddedResources = value.length() == 0 ? -1 : Integer.parseInt(value);
            }
            this.keepAllMetadata = keepAllMetadata;
            this.lowerNames = lowerNames;
            this.writeLimit = writeLimit;
            if (maxMetadataValueLength > totalMetadataLimit) {
                maxMetadataValueLength = totalMetadataLimit;
            }
            this.maxMetadataValueLength = maxMetadataValueLength;
            this.totalMetadataLimit = totalMetadataLimit;
            this.extractArchives = extractArchives;
            this.maxEmbeddedResources = maxEmbeddedResources;
        }

        public String toPackedString() {
            StringBuilder sb = new StringBuilder();
            Object[] sortArray = new String[this.sourceTargets.size()];
            int i = 0;
            for (String source : this.sourceTargets.keySet()) {
                sortArray[i++] = source;
            }
            Arrays.sort(sortArray);
            ArrayList<String> packedMappings = new ArrayList<String>();
            String[] fixedList = new String[2];
            for (Object source : sortArray) {
                String target = this.sourceTargets.get(source);
                StringBuilder localBuffer = new StringBuilder();
                fixedList[0] = source;
                fixedList[1] = target;
                TikaExtractor.packFixedList((StringBuilder)localBuffer, (String[])fixedList, (char)':');
                packedMappings.add(localBuffer.toString());
            }
            TikaExtractor.packList((StringBuilder)sb, (List)packedMappings, (char)'+');
            if (this.keepAllMetadata) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (this.lowerNames) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (this.writeLimit != -1) {
                sb.append('+');
                sb.append(this.writeLimit);
            }
            if (this.maxMetadataValueLength != Integer.parseInt("250000")) {
                sb.append('+');
                sb.append(this.maxMetadataValueLength);
            }
            if (this.totalMetadataLimit != Integer.parseInt("500000")) {
                sb.append('+');
                sb.append(this.totalMetadataLimit);
            }
            if (this.extractArchives) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (this.maxEmbeddedResources != -1) {
                sb.append('+');
                sb.append(this.maxEmbeddedResources);
            }
            return sb.toString();
        }

        public String getMapping(String source) {
            return this.sourceTargets.get(source);
        }

        public boolean keepAllMetadata() {
            return this.keepAllMetadata;
        }

        public boolean lowerNames() {
            return this.lowerNames;
        }

        public int writeLimit() {
            return this.writeLimit;
        }

        public boolean extractArchives() {
            return this.extractArchives;
        }

        public int maxEmbeddedResources() {
            return this.maxEmbeddedResources;
        }
    }

    protected static class MemoryDestinationStorage
    implements DestinationStorage {
        protected final ByteArrayOutputStream outputStream;

        public MemoryDestinationStorage(int sizeHint) {
            this.outputStream = new ByteArrayOutputStream(sizeHint);
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputStream.size();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public void close() throws ManifoldCFException {
        }
    }

    protected static class FileDestinationStorage
    implements DestinationStorage {
        protected final File outputFile;
        protected final OutputStream outputStream;

        public FileDestinationStorage() throws ManifoldCFException {
            FileOutputStream outputStream;
            File outputFile;
            try {
                outputFile = File.createTempFile("mcftika", "tmp");
                outputStream = new FileOutputStream(outputFile);
            }
            catch (IOException e) {
                TikaExtractor.handleIOException(e);
                outputFile = null;
                outputStream = null;
            }
            this.outputFile = outputFile;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputFile.length();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            try {
                return new FileInputStream(this.outputFile);
            }
            catch (IOException e) {
                TikaExtractor.handleIOException(e);
                return null;
            }
        }

        @Override
        public void close() throws ManifoldCFException {
            this.outputFile.delete();
        }
    }

    protected static interface DestinationStorage {
        public OutputStream getOutputStream() throws ManifoldCFException;

        public long getBinaryLength() throws ManifoldCFException;

        public InputStream getInputStream() throws ManifoldCFException;

        public void close() throws ManifoldCFException;
    }
}

