/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.forcedmetadata;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.FieldDataFactory;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.FieldSource;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.IDataSource;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.Messages;
import org.apache.manifoldcf.agents.transformation.forcedmetadata.StringSource;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class ForcedMetadataConnector
extends BaseTransformationConnector {
    public static final String _rcsid = "@(#)$Id: ForcedMetadataConnector.java 1865954 2019-08-26 20:27:25Z schuch $";
    public static final String NODE_EXPRESSION = "expression";
    public static final String NODE_PAIR = "pair";
    public static final String ATTRIBUTE_PARAMETER = "parameter";
    public static final String NODE_FIELDMAP = "fieldmap";
    public static final String NODE_KEEPMETADATA = "keepAllMetadata";
    public static final String NODE_FILTEREMPTY = "filterEmpty";
    public static final String ATTRIBUTE_SOURCE = "source";
    public static final String ATTRIBUTE_TARGET = "target";
    public static final String ATTRIBUTE_VALUE = "value";
    private static final String VIEW_SPEC = "viewSpecification.html";
    private static final String EDIT_SPEC_HEADER = "editSpecification.js";
    private static final String EDIT_SPEC_EXPRESSIONS = "editSpecification_Expressions.html";

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(spec);
        return new VersionContext(sp.toPackedString(), this.params, spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        SpecPacker sp = new SpecPacker(pipelineDescription.getSpecification());
        try (FieldDataFactory fdf = new FieldDataFactory(document);){
            String field;
            Iterator fields;
            RepositoryDocument docCopy = document.duplicate();
            docCopy.clearFields();
            if (sp.filterEmpty()) {
                if (sp.keepAllMetadata()) {
                    fields = document.getFields();
                    while (fields.hasNext()) {
                        field = (String)fields.next();
                        ForcedMetadataConnector.moveData(docCopy, field, fdf, field, true);
                    }
                }
            } else if (sp.keepAllMetadata()) {
                fields = document.getFields();
                while (fields.hasNext()) {
                    field = (String)fields.next();
                    ForcedMetadataConnector.moveData(docCopy, field, fdf, field, false);
                }
            }
            Iterator<String> expressionKeys = sp.getExpressionKeys();
            while (expressionKeys.hasNext()) {
                String expressionKey = expressionKeys.next();
                Set<String> values = sp.getExpressionValues(expressionKey);
                IDataSource[] dataSources = new IDataSource[values.size()];
                int k = 0;
                for (String string : values) {
                    dataSources[k++] = ForcedMetadataConnector.processExpression(string, fdf);
                }
                int totalSize = 0;
                for (IDataSource dataSource : dataSources) {
                    if (dataSource == null) continue;
                    totalSize += dataSource.getSize();
                }
                if (totalSize == 0) {
                    docCopy.removeField(expressionKey);
                    continue;
                }
                k = 0;
                if (ForcedMetadataConnector.allDates(dataSources)) {
                    Object[] objectArray = new Date[totalSize];
                    for (IDataSource dataSource : dataSources) {
                        if (dataSource == null) continue;
                        for (Object o : dataSource.getRawForm()) {
                            objectArray[k++] = o;
                        }
                    }
                    docCopy.addField(expressionKey, (Date[])ForcedMetadataConnector.conditionallyRemoveNulls(objectArray, sp.filterEmpty()));
                    continue;
                }
                if (ForcedMetadataConnector.allReaders(dataSources)) {
                    void var15_24;
                    if (sp.filterEmpty()) {
                        String[] stringArray = new String[totalSize];
                    } else {
                        Reader[] readerArray = new Reader[totalSize];
                    }
                    for (IDataSource dataSource : dataSources) {
                        Object[] sources;
                        if (dataSource == null) continue;
                        Object[] objectArray = sources = sp.filterEmpty() ? dataSource.getStringForm() : dataSource.getRawForm();
                        int n = objectArray.length;
                        for (int o = 0; o < n; ++o) {
                            Object o2 = objectArray[o];
                            var15_24[k++] = o2;
                        }
                    }
                    if (sp.filterEmpty()) {
                        docCopy.addField(expressionKey, ForcedMetadataConnector.removeEmpties((String[])var15_24));
                        continue;
                    }
                    docCopy.addField(expressionKey, (Reader[])var15_24);
                    continue;
                }
                String[] stringArray = new String[totalSize];
                for (IDataSource dataSource : dataSources) {
                    if (dataSource == null) continue;
                    for (String o : dataSource.getStringForm()) {
                        stringArray[k++] = o;
                    }
                }
                if (sp.filterEmpty()) {
                    docCopy.addField(expressionKey, ForcedMetadataConnector.removeEmpties(stringArray));
                    continue;
                }
                docCopy.addField(expressionKey, stringArray);
            }
            int n = activities.sendDocument(documentURI, docCopy);
            return n;
        }
    }

    protected static boolean allDates(IDataSource[] dataSources) throws IOException, ManifoldCFException {
        for (IDataSource ds : dataSources) {
            if (ds == null || ds.getRawForm() instanceof Date[]) continue;
            return false;
        }
        return true;
    }

    protected static boolean allReaders(IDataSource[] dataSources) throws IOException, ManifoldCFException {
        for (IDataSource ds : dataSources) {
            if (ds == null || ds.getRawForm() instanceof Reader[]) continue;
            return false;
        }
        return true;
    }

    protected static void moveData(RepositoryDocument docCopy, String target, FieldDataFactory document, String field, boolean filterEmpty) throws ManifoldCFException, IOException {
        Object[] fieldData = document.getField(field);
        if (fieldData instanceof Date[]) {
            docCopy.addField(target, (Date[])ForcedMetadataConnector.conditionallyRemoveNulls(fieldData, filterEmpty));
        } else if (fieldData instanceof Reader[]) {
            if (filterEmpty) {
                docCopy.addField(target, ForcedMetadataConnector.removeEmpties(document.getFieldAsStrings(field)));
            } else {
                docCopy.addField(target, (Reader[])fieldData);
            }
        } else if (fieldData instanceof String[]) {
            String[] processedFieldData = filterEmpty ? ForcedMetadataConnector.removeEmpties((String[])fieldData) : (String[])fieldData;
            docCopy.addField(target, processedFieldData);
        }
    }

    protected static String[] removeEmpties(String[] input) {
        int count = 0;
        for (String s : input) {
            if (s == null || s.length() <= 0) continue;
            ++count;
        }
        if (count == input.length) {
            return input;
        }
        String[] rval = new String[count];
        count = 0;
        for (String s : input) {
            if (s == null || s.length() <= 0) continue;
            rval[count++] = s;
        }
        return rval;
    }

    protected static Object[] conditionallyRemoveNulls(Object[] input, boolean filterEmpty) {
        if (!filterEmpty) {
            return input;
        }
        int count = 0;
        for (Object o : input) {
            if (o == null) continue;
            ++count;
        }
        if (count == input.length) {
            return input;
        }
        Object[] rval = new Object[count];
        count = 0;
        for (Object o : input) {
            if (o == null) continue;
            rval[count++] = o;
        }
        return rval;
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "ForcedMetadata.Expressions"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_HEADER, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        ForcedMetadataConnector.fillInExpressionsTab(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_EXPRESSIONS, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode node;
        String x;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String expressionCount = variableContext.getParameter(seqPrefix + "expression_count");
        if (expressionCount != null) {
            int count = Integer.parseInt(expressionCount);
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode cn = os.getChild(i);
                if (cn.getType().equals(NODE_EXPRESSION) || cn.getType().equals(NODE_PAIR) || cn.getType().equals(NODE_FIELDMAP)) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            for (int j = 0; j < count; ++j) {
                String op = variableContext.getParameter(seqPrefix + "expression_" + j + "_op");
                if (op != null && op.equals("Delete")) continue;
                String paramName = variableContext.getParameter(seqPrefix + "expression_" + j + "_name");
                String paramRemove = variableContext.getParameter(seqPrefix + "expression_" + j + "_remove");
                String paramValue = variableContext.getParameter(seqPrefix + "expression_" + j + "_value");
                SpecificationNode sn = new SpecificationNode(NODE_EXPRESSION);
                sn.setAttribute(ATTRIBUTE_PARAMETER, paramName);
                if (paramRemove == null || !paramRemove.equals("true")) {
                    sn.setAttribute(ATTRIBUTE_VALUE, paramValue);
                }
                os.addChild(os.getChildCount(), (ConfigurationNode)sn);
            }
            String addOp = variableContext.getParameter(seqPrefix + "expression_op");
            if (addOp != null && addOp.equals("Add")) {
                String paramName = variableContext.getParameter(seqPrefix + "expression_name");
                String paramRemove = variableContext.getParameter(seqPrefix + "expression_remove");
                String paramValue = variableContext.getParameter(seqPrefix + "expression_value");
                SpecificationNode sn = new SpecificationNode(NODE_EXPRESSION);
                sn.setAttribute(ATTRIBUTE_PARAMETER, paramName);
                if (paramRemove == null || !paramRemove.equals("true")) {
                    sn.setAttribute(ATTRIBUTE_VALUE, paramValue);
                }
                os.addChild(os.getChildCount(), (ConfigurationNode)sn);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "keepallmetadata_present")) != null && x.length() > 0) {
            String keepAll = variableContext.getParameter(seqPrefix + "keepallmetadata");
            if (keepAll == null) {
                keepAll = "false";
            }
            int i = 0;
            while (i < os.getChildCount()) {
                node = os.getChild(i);
                if (node.getType().equals(NODE_KEEPMETADATA)) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            node = new SpecificationNode(NODE_KEEPMETADATA);
            node.setAttribute(ATTRIBUTE_VALUE, keepAll);
            os.addChild(os.getChildCount(), (ConfigurationNode)node);
        }
        if ((x = variableContext.getParameter(seqPrefix + "filterempty_present")) != null && x.length() > 0) {
            String filterEmpty = variableContext.getParameter(seqPrefix + "filterempty");
            if (filterEmpty == null) {
                filterEmpty = "false";
            }
            int i = 0;
            while (i < os.getChildCount()) {
                node = os.getChild(i);
                if (node.getType().equals(NODE_FILTEREMPTY)) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            node = new SpecificationNode(NODE_FILTEREMPTY);
            node.setAttribute(ATTRIBUTE_VALUE, filterEmpty);
            os.addChild(os.getChildCount(), (ConfigurationNode)node);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        ForcedMetadataConnector.fillInExpressionsTab(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPEC, paramMap);
    }

    protected static void fillInExpressionsTab(Map<String, Object> paramMap, Specification os) {
        HashMap<String, HashSet<Object>> expressions = new HashMap<String, HashSet<Object>>();
        HashMap expressionAdditions = new HashMap();
        HashMap<String, HashSet<String>> additions = new HashMap<String, HashSet<String>>();
        String keepAllMetadataValue = "true";
        String filterEmptyValue = "true";
        for (int i = 0; i < os.getChildCount(); ++i) {
            String value;
            String parameter;
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals(NODE_FIELDMAP)) {
                String source = sn.getAttributeValue(ATTRIBUTE_SOURCE);
                String target = sn.getAttributeValue(ATTRIBUTE_TARGET);
                expressions.put(source, new HashSet());
                if (target == null) continue;
                HashSet<String> sources = new HashSet<String>();
                sources.add("${" + source + "}");
                expressions.put(target, sources);
                continue;
            }
            if (sn.getType().equals(NODE_PAIR)) {
                parameter = sn.getAttributeValue(ATTRIBUTE_PARAMETER);
                value = sn.getAttributeValue(ATTRIBUTE_VALUE);
                HashSet<String> addition = (HashSet<String>)additions.get(parameter);
                if (addition == null) {
                    addition = new HashSet<String>();
                    additions.put(parameter, addition);
                }
                addition.add(ForcedMetadataConnector.nonExpressionEscape(value));
                continue;
            }
            if (sn.getType().equals(NODE_EXPRESSION)) {
                parameter = sn.getAttributeValue(ATTRIBUTE_PARAMETER);
                value = sn.getAttributeValue(ATTRIBUTE_VALUE);
                if (value == null) {
                    expressionAdditions.put(parameter, new HashSet());
                    continue;
                }
                HashSet<String> expressionAddition = (HashSet<String>)expressionAdditions.get(parameter);
                if (expressionAddition == null) {
                    expressionAddition = new HashSet<String>();
                    expressionAdditions.put(parameter, expressionAddition);
                }
                expressionAddition.add(value);
                continue;
            }
            if (sn.getType().equals(NODE_KEEPMETADATA)) {
                keepAllMetadataValue = sn.getAttributeValue(ATTRIBUTE_VALUE);
                continue;
            }
            if (!sn.getType().equals(NODE_FILTEREMPTY)) continue;
            filterEmptyValue = sn.getAttributeValue(ATTRIBUTE_VALUE);
        }
        for (String parameter : additions.keySet()) {
            expressions.put(parameter, (HashSet<Object>)additions.get(parameter));
        }
        for (String parameter : expressionAdditions.keySet()) {
            expressions.put(parameter, (HashSet<Object>)expressionAdditions.get(parameter));
        }
        ArrayList pObject = new ArrayList();
        Object[] keys = expressions.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            Set values = (Set)expressions.get(key);
            if (values.size() == 0) {
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put(ATTRIBUTE_PARAMETER, key);
                record.put(ATTRIBUTE_VALUE, "");
                record.put("isnull", "true");
                pObject.add(record);
                continue;
            }
            Object[] valueArray = values.toArray(new String[0]);
            Arrays.sort(valueArray);
            for (Object value : valueArray) {
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put(ATTRIBUTE_PARAMETER, key);
                record.put(ATTRIBUTE_VALUE, value);
                record.put("isnull", "false");
                pObject.add(record);
            }
        }
        paramMap.put("EXPRESSIONS", pObject);
        paramMap.put("KEEPALLMETADATA", keepAllMetadataValue);
        paramMap.put("FILTEREMPTY", filterEmptyValue);
    }

    protected static String nonExpressionEscape(String input) {
        return input;
    }

    protected static String nonExpressionUnescape(String input) {
        return input;
    }

    protected static IDataSource append(IDataSource currentValues, IDataSource data) throws IOException, ManifoldCFException {
        if (currentValues == null) {
            return data;
        }
        if (currentValues.getSize() == 0) {
            return currentValues;
        }
        String[] currentStrings = currentValues.getStringForm();
        String[] dataStrings = data.getStringForm();
        String[] rval = new String[currentStrings.length * dataStrings.length];
        int rvalIndex = 0;
        for (String currentString : currentStrings) {
            for (String dataString : dataStrings) {
                rval[rvalIndex++] = currentString + dataString;
            }
        }
        return new StringSource(rval);
    }

    public static IDataSource processExpression(String expression, FieldDataFactory sourceDocument) throws IOException, ManifoldCFException {
        int index = 0;
        IDataSource input = null;
        while (index != expression.length()) {
            int field = expression.indexOf("${", index);
            if (field == -1) {
                return ForcedMetadataConnector.append(input, new StringSource(ForcedMetadataConnector.nonExpressionUnescape(expression.substring(index))));
            }
            if (field > 0) {
                input = ForcedMetadataConnector.append(input, new StringSource(ForcedMetadataConnector.nonExpressionUnescape(expression.substring(index, field))));
            }
            StringBuilder fieldNameBuffer = new StringBuilder();
            StringBuilder regExpBuffer = new StringBuilder();
            StringBuilder groupNumberBuffer = new StringBuilder();
            field = ForcedMetadataConnector.parseArgument(expression, field + 2, fieldNameBuffer);
            field = ForcedMetadataConnector.parseArgument(expression, field, regExpBuffer);
            int fieldEnd = ForcedMetadataConnector.parseToEnd(expression, field = ForcedMetadataConnector.parseArgument(expression, field, groupNumberBuffer));
            if (fieldEnd == expression.length()) {
                if (fieldNameBuffer.length() > 0) {
                    return ForcedMetadataConnector.append(input, new FieldSource(sourceDocument, fieldNameBuffer.toString(), regExpBuffer.toString(), groupNumberBuffer.toString()));
                }
                return input;
            }
            if (fieldNameBuffer.length() > 0) {
                input = ForcedMetadataConnector.append(input, new FieldSource(sourceDocument, fieldNameBuffer.toString(), regExpBuffer.toString(), groupNumberBuffer.toString()));
            }
            index = fieldEnd;
        }
        return input;
    }

    protected static int parseArgument(String input, int start, StringBuilder output) {
        while (input.length() != start) {
            char theChar = input.charAt(start);
            if (theChar == '}') {
                return start;
            }
            ++start;
            if (theChar == '|') {
                return start;
            }
            if (theChar == '\\') {
                if (input.length() == start) {
                    return start;
                }
                theChar = input.charAt(start++);
            }
            output.append(theChar);
        }
        return start;
    }

    protected static int parseToEnd(String input, int start) {
        while (input.length() != start) {
            char theChar;
            if ((theChar = input.charAt(start++)) == '}') {
                return start;
            }
            if (theChar != '\\') continue;
            if (input.length() == start) {
                return start;
            }
            ++start;
        }
        return start;
    }

    protected static class SpecPacker {
        private final boolean keepAllMetadata;
        private final boolean filterEmpty;
        private final Map<String, Set<String>> expressions = new HashMap<String, Set<String>>();

        public SpecPacker(Specification os) {
            boolean keepAllMetadata = true;
            boolean filterEmpty = true;
            HashMap<String, HashSet<String>> additions = new HashMap<String, HashSet<String>>();
            HashMap expressionAdditions = new HashMap();
            for (int i = 0; i < os.getChildCount(); ++i) {
                String value;
                String parameter;
                String value2;
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals(ForcedMetadataConnector.NODE_KEEPMETADATA)) {
                    value2 = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_VALUE);
                    keepAllMetadata = Boolean.parseBoolean(value2);
                    continue;
                }
                if (sn.getType().equals(ForcedMetadataConnector.NODE_FILTEREMPTY)) {
                    value2 = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_VALUE);
                    filterEmpty = Boolean.parseBoolean(value2);
                    continue;
                }
                if (sn.getType().equals(ForcedMetadataConnector.NODE_FIELDMAP)) {
                    String source = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_SOURCE);
                    String target = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_TARGET);
                    this.expressions.put(source, new HashSet());
                    if (target == null) continue;
                    HashSet<String> sources = new HashSet<String>();
                    sources.add("${" + source + "}");
                    this.expressions.put(target, sources);
                    continue;
                }
                if (sn.getType().equals(ForcedMetadataConnector.NODE_PAIR)) {
                    parameter = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_PARAMETER);
                    value = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_VALUE);
                    HashSet<String> addition = (HashSet<String>)additions.get(parameter);
                    if (addition == null) {
                        addition = new HashSet<String>();
                        additions.put(parameter, addition);
                    }
                    addition.add(ForcedMetadataConnector.nonExpressionEscape(value));
                    continue;
                }
                if (!sn.getType().equals(ForcedMetadataConnector.NODE_EXPRESSION)) continue;
                parameter = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_PARAMETER);
                value = sn.getAttributeValue(ForcedMetadataConnector.ATTRIBUTE_VALUE);
                if (value == null) {
                    expressionAdditions.put(parameter, new HashSet());
                    continue;
                }
                HashSet<String> expressionAddition = (HashSet<String>)expressionAdditions.get(parameter);
                if (expressionAddition == null) {
                    expressionAddition = new HashSet<String>();
                    expressionAdditions.put(parameter, expressionAddition);
                }
                expressionAddition.add(value);
            }
            for (String parameter : additions.keySet()) {
                this.expressions.put(parameter, (Set<String>)additions.get(parameter));
            }
            for (String parameter : expressionAdditions.keySet()) {
                this.expressions.put(parameter, (Set<String>)expressionAdditions.get(parameter));
            }
            this.keepAllMetadata = keepAllMetadata;
            this.filterEmpty = filterEmpty;
        }

        public String toPackedString() {
            StringBuilder sb = new StringBuilder();
            Object[] sortArray = this.expressions.keySet().toArray(new String[0]);
            Arrays.sort(sortArray);
            ForcedMetadataConnector.packList((StringBuilder)sb, (String[])((String[])sortArray), (char)'+');
            for (Object key : sortArray) {
                Set<String> values = this.expressions.get(key);
                Object[] valueArray = values.toArray(new String[0]);
                Arrays.sort(valueArray);
                ForcedMetadataConnector.packList((StringBuilder)sb, (String[])((String[])valueArray), (char)'+');
            }
            if (this.keepAllMetadata) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (this.filterEmpty) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            return sb.toString();
        }

        public Iterator<String> getExpressionKeys() {
            return this.expressions.keySet().iterator();
        }

        public Set<String> getExpressionValues(String key) {
            return this.expressions.get(key);
        }

        public boolean keepAllMetadata() {
            return this.keepAllMetadata;
        }

        public boolean filterEmpty() {
            return this.filterEmpty;
        }
    }
}

