/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.model;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.crawler.connectors.confluence.model.ConfluenceResource;
import org.apache.manifoldcf.crawler.connectors.confluence.model.Label;
import org.apache.manifoldcf.crawler.connectors.confluence.model.PageType;
import org.apache.manifoldcf.crawler.connectors.confluence.model.builder.ConfluenceResourceBuilder;
import org.json.simple.JSONObject;

public class Page
extends ConfluenceResource {
    protected static final String KEY_LINKS = "_links";
    protected static final String KEY_ID = "id";
    protected static final String KEY_SELF = "self";
    protected static final String KEY_WEBUI = "webui";
    protected static final String KEY_BASE = "base";
    protected static final String KEY_CONTEXT = "context";
    protected static final String KEY_KEY = "key";
    protected static final String KEY_TITLE = "title";
    protected static final String KEY_BODY = "body";
    protected static final String KEY_VIEW = "view";
    protected static final String KEY_VALUE = "value";
    protected static final String KEY_SPACE = "space";
    protected static final String KEY_HISTORY = "history";
    protected static final String KEY_CREATED_DATE = "createdDate";
    protected static final String KEY_CREATED_BY = "createdBy";
    protected static final String KEY_BY = "by";
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_DISPLAY_NAME = "displayName";
    protected static final String KEY_USER_NAME = "username";
    protected static final String KEY_VERSION = "version";
    protected static final String KEY_WHEN = "when";
    protected static final String KEY_MEDIATYPE = "mediaType";
    private static final String PAGE_ID = "confluenceId";
    private static final String PAGE_URL = "url";
    private static final String PAGE_WEBURL = "webUrl";
    private static final String PAGE_LAST_MODIFIED = "lastModified";
    private static final String PAGE_CREATOR = "creator";
    private static final String PAGE_CREATOR_USERNAME = "creatorUsername";
    private static final String PAGE_LAST_MODIFIER = "lastModifier";
    private static final String PAGE_LAST_MODIFIER_USERNAME = "lastModifierUsername";
    private static final String PAGE_SIZE = "size";
    private static final String PAGE_LABEL = "label";
    protected String id;
    protected String space;
    protected String baseUrl;
    protected String urlContext;
    protected String url;
    protected String webUrl;
    protected Date createdDate;
    protected Date lastModified;
    protected PageType type;
    protected String title;
    protected int version;
    protected String creator;
    protected String creatorUsername;
    protected String lastModifier;
    protected String lastModifierUsername;
    protected String mediaType = "text/html; charset=utf-8";
    protected long length;
    protected String content;
    protected List<Label> labels = Lists.newArrayList();
    private JSONObject delegated;

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public PageType getType() {
        return this.type;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUrlContext() {
        return this.urlContext;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSpace() {
        return this.space;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreatorUsername() {
        return this.creatorUsername;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public String getLastModifierUsername() {
        return this.lastModifierUsername;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public boolean hasContent() {
        return this.length > 0L && this.content != null;
    }

    public InputStream getContentStream() {
        String contentStream = this.content != null ? this.content : "";
        return new ByteArrayInputStream(contentStream.getBytes(StandardCharsets.UTF_8));
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public Map<String, Object> getMetadataAsMap() {
        HashMap pageMetadata = Maps.newHashMap();
        pageMetadata.put(KEY_ID, this.id);
        pageMetadata.put(PAGE_ID, this.id);
        pageMetadata.put(KEY_TYPE, this.type.toString());
        pageMetadata.put(KEY_TITLE, this.title);
        pageMetadata.put(KEY_SPACE, this.space);
        pageMetadata.put(PAGE_URL, this.url);
        pageMetadata.put(PAGE_WEBURL, this.webUrl);
        pageMetadata.put(KEY_CREATED_DATE, DateParser.formatISO8601Date((Date)this.createdDate));
        pageMetadata.put(PAGE_LAST_MODIFIED, DateParser.formatISO8601Date((Date)this.lastModified));
        pageMetadata.put(KEY_MEDIATYPE, this.mediaType);
        pageMetadata.put(KEY_VERSION, String.valueOf(this.version));
        pageMetadata.put(PAGE_CREATOR, this.creator);
        pageMetadata.put(PAGE_CREATOR_USERNAME, this.creatorUsername);
        pageMetadata.put(PAGE_LAST_MODIFIER, this.lastModifier);
        pageMetadata.put(PAGE_LAST_MODIFIER_USERNAME, this.lastModifierUsername);
        pageMetadata.put(PAGE_SIZE, String.valueOf(this.length));
        this.putLabelsOnMetadataMap(pageMetadata);
        this.refineMetadata(pageMetadata);
        return pageMetadata;
    }

    private void putLabelsOnMetadataMap(Map<String, Object> pageMetadata) {
        if (this.labels == null || this.labels.isEmpty()) {
            return;
        }
        Iterable labelsString = Iterables.transform(this.labels, (Function)new Function<Label, String>(){

            public String apply(Label input) {
                return input.getName();
            }
        });
        pageMetadata.put(PAGE_LABEL, Lists.newArrayList((Iterable)labelsString));
    }

    protected void refineMetadata(Map<String, Object> metadata) {
    }

    public static ConfluenceResourceBuilder<? extends Page> builder() {
        return new PageBuilder();
    }

    public static class PageBuilder
    implements ConfluenceResourceBuilder<Page> {
        @Override
        public Page fromJson(JSONObject jsonPage) {
            return this.fromJson(jsonPage, new Page());
        }

        @Override
        public Page fromJson(JSONObject jsonPage, Page page) {
            JSONObject view;
            JSONObject body;
            JSONObject version;
            JSONObject history;
            String id = jsonPage.get((Object)Page.KEY_ID).toString();
            String type = jsonPage.get((Object)Page.KEY_TYPE).toString();
            String title = jsonPage.get((Object)Page.KEY_TITLE).toString();
            page.delegated = jsonPage;
            page.id = id;
            page.type = PageType.fromName(type);
            page.title = title;
            page.space = PageBuilder.processSpace(jsonPage);
            JSONObject links = (JSONObject)jsonPage.get((Object)Page.KEY_LINKS);
            if (links != null) {
                page.url = links.get((Object)Page.KEY_SELF) == null ? "" : links.get((Object)Page.KEY_SELF).toString();
                String webUrl = links.get((Object)Page.KEY_WEBUI) == null ? "" : links.get((Object)Page.KEY_WEBUI).toString();
                page.urlContext = links.get((Object)Page.KEY_CONTEXT) == null ? "" : links.get((Object)Page.KEY_CONTEXT).toString();
                page.baseUrl = links.get((Object)Page.KEY_BASE) == null ? "" : links.get((Object)Page.KEY_BASE).toString();
                page.webUrl = page.baseUrl + webUrl;
            }
            if ((history = (JSONObject)jsonPage.get((Object)Page.KEY_HISTORY)) != null) {
                page.createdDate = DateParser.parseISO8601Date((String)(history.get((Object)Page.KEY_CREATED_DATE) == null ? "" : history.get((Object)Page.KEY_CREATED_DATE).toString()));
                JSONObject createdBy = (JSONObject)history.get((Object)Page.KEY_CREATED_BY);
                if (createdBy != null) {
                    page.creator = createdBy.get((Object)Page.KEY_DISPLAY_NAME) == null ? "" : createdBy.get((Object)Page.KEY_DISPLAY_NAME).toString();
                    String string = page.creatorUsername = createdBy.get((Object)Page.KEY_USER_NAME) == null ? "" : createdBy.get((Object)Page.KEY_USER_NAME).toString();
                }
            }
            if ((version = (JSONObject)jsonPage.get((Object)Page.KEY_VERSION)) != null) {
                JSONObject by = (JSONObject)version.get((Object)Page.KEY_BY);
                if (by != null) {
                    page.lastModifier = by.get((Object)Page.KEY_DISPLAY_NAME) == null ? "" : by.get((Object)Page.KEY_DISPLAY_NAME).toString();
                    page.lastModifierUsername = by.get((Object)Page.KEY_USER_NAME) == null ? "" : by.get((Object)Page.KEY_USER_NAME).toString();
                }
                page.lastModified = DateParser.parseISO8601Date((String)(version.get((Object)Page.KEY_WHEN) == null ? "" : version.get((Object)Page.KEY_WHEN).toString()));
            }
            if ((body = (JSONObject)jsonPage.get((Object)Page.KEY_BODY)) != null && (view = (JSONObject)body.get((Object)Page.KEY_VIEW)) != null) {
                page.content = view.get((Object)Page.KEY_VALUE) == null ? "" : view.get((Object)Page.KEY_VALUE).toString();
                page.length = page.content.getBytes(StandardCharsets.UTF_8).length;
            }
            return page;
        }

        private static String processSpace(JSONObject page) {
            JSONObject space = (JSONObject)page.get((Object)Page.KEY_SPACE);
            if (space != null) {
                return space.get((Object)Page.KEY_KEY) == null ? "" : space.get((Object)Page.KEY_KEY).toString();
            }
            return "";
        }

        @Override
        public Class<Page> getType() {
            return Page.class;
        }
    }
}

