/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.v6.client;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.exception.ConfluenceException;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Attachment;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceResource;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceResponse;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceRestrictionsResponse;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceUser;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Group;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Label;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.MutableAttachment;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.MutablePage;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Page;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Restrictions;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Space;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.User;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.builder.ConfluenceResourceBuilder;
import org.apache.manifoldcf.crawler.system.Logging;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceClient {
    private static final String VIEW_PERMISSION = "view";
    private static final String CONTENT_PATH = "/rest/api/content";
    private static final String AUTHORITY_PATH = "/rpc/json-rpc/confluenceservice-v2/";
    private static final String SPACES_PATH = "/rest/api/space";
    private static final String CHILD_PAGE_PATH = "/child/page";
    private static final String USER_PATH = "/rest/api/user";
    private static final String USER_GROUPS_PATH = "/rest/api/user/memberof";
    private static final String READ_RESTRICTIONS_PATH = "/restriction/byOperation/read";
    private static final String EXPANDABLE_PARAMETERS = "expand=body.view,metadata.labels,space,history,version";
    private static final String CHILD_ATTACHMENTS_PATH = "/child/attachment/";
    private static final String LABEL_PATH = "/label";
    private final Logger logger = LoggerFactory.getLogger(ConfluenceClient.class);
    private final String protocol;
    private final Integer port;
    private final String host;
    private final String path;
    private final String username;
    private final String password;
    private int socketTimeout = 900000;
    private int connectionTimeout = 60000;
    private CloseableHttpClient httpClient;
    private HttpClientContext httpContext;

    public ConfluenceClient(String protocol, String host, Integer port, String path, String username, String password, int socketTimeout, int connectionTimeout) throws ManifoldCFException {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.username = username;
        this.password = password;
        this.socketTimeout = socketTimeout;
        this.connectionTimeout = connectionTimeout;
        this.connect();
    }

    private void connect() throws ManifoldCFException {
        SSLSocketFactory httpsSocketFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
        SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(httpsSocketFactory, (long)this.connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
        poolingConnectionManager.setDefaultMaxPerRoute(1);
        poolingConnectionManager.setValidateAfterInactivity(2000);
        poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.socketTimeout).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(this.socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.socketTimeout);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingConnectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setRequestExecutor(new HttpRequestExecutor(this.socketTimeout)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }

    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                this.logger.debug("Error closing http connection. Reason: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public boolean check() throws Exception {
        try {
            if (this.httpClient == null) {
                this.connect();
            }
            String url = String.format(Locale.ROOT, "%s://%s:%s%s%s?limit=1", this.protocol, this.host, this.port, this.path, CONTENT_PATH);
            this.logger.debug("[Processing] Hitting url: {} for confluence status check fetching : ", (Object)"Confluence URL", (Object)this.sanitizeUrl(url));
            HttpGet httpGet = this.createGetRequest(url);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new Exception("[Checking connection] Confluence server appears to be down");
            }
            return true;
        }
        catch (IOException e) {
            this.logger.warn("[Checking connection] Confluence server appears to be down", (Throwable)e);
            throw new Exception("Confluence appears to be down", e);
        }
    }

    public boolean checkAuth() throws Exception {
        try {
            if (this.httpClient == null) {
                this.connect();
            }
            this.getSpaces();
            return true;
        }
        catch (Exception e) {
            this.logger.warn("[Checking connection] Confluence server appears to be down", (Throwable)e);
            throw e;
        }
    }

    private HttpGet createGetRequest(String url) {
        String finalUrl = this.useBasicAuthentication() ? url + "&os_authType=basic" : url;
        String sanitizedUrl = this.sanitizeUrl(finalUrl);
        HttpGet httpGet = new HttpGet(sanitizedUrl);
        httpGet.addHeader("Accept", "application/json");
        if (this.useBasicAuthentication()) {
            httpGet.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])String.format(Locale.ROOT, "%s:%s", this.username, this.password).getBytes(Charset.forName("UTF-8"))));
        }
        return httpGet;
    }

    public ConfluenceResponse<Page> getSpaceRootPages(int start, int limit, String space, Optional<String> pageType) throws Exception {
        String contentType = "page";
        if (pageType.isPresent()) {
            contentType = (String)pageType.get();
        }
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s/content/%s?limit=%s&start=%s&depth=root", this.protocol, this.host, this.port, this.path, SPACES_PATH, space, contentType, limit, start);
        return this.getConfluenceResources(url, Page.builder());
    }

    public ConfluenceResponse<Page> getPageChilds(int start, int limit, String pageId) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s%s?limit=%s&start=%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, pageId, CHILD_PAGE_PATH, limit, start);
        return this.getConfluenceResources(url, Page.builder());
    }

    public ConfluenceResponse<Page> getPages(int start, int limit, Optional<String> space, Optional<String> pageType) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s?limit=%s&start=%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, limit, start);
        if (space.isPresent()) {
            url = String.format(Locale.ROOT, "%s&spaceKey=%s", url, space.get());
        }
        if (pageType.isPresent()) {
            url = String.format(Locale.ROOT, "%s&type=%s", url, pageType.get());
        }
        return this.getConfluenceResources(url, Page.builder());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfluenceResponse<? extends ConfluenceResource> getConfluenceResources(String url, ConfluenceResourceBuilder<? extends ConfluenceResource> builder) throws Exception {
        this.logger.debug("[Processing] Hitting url for get confluence resources: {}", (Object)this.sanitizeUrl(url));
        HttpGet httpGet = this.createGetRequest(url);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)httpGet);){
            ConfluenceResponse<? extends ConfluenceResource> confluenceResponse = this.responseFromHttpEntity(response.getEntity(), builder);
            EntityUtils.consume((HttpEntity)response.getEntity());
            ConfluenceResponse<? extends ConfluenceResource> confluenceResponse2 = confluenceResponse;
            return confluenceResponse2;
        }
        catch (IOException e) {
            this.logger.error("[Processing] Failed to get page(s)", (Throwable)e);
            throw new Exception("Confluence appears to be down", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfluenceRestrictionsResponse<? extends ConfluenceResource> getConfluenceRestrictionsResources(String url, ConfluenceResourceBuilder<? extends ConfluenceResource> builder) throws Exception {
        this.logger.debug("[Processing] Hitting url for get confluence resources: {}", (Object)this.sanitizeUrl(url));
        HttpGet httpGet = this.createGetRequest(url);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)httpGet);){
            ConfluenceRestrictionsResponse<? extends ConfluenceResource> confluenceResponse = this.restrictionsResponseFromHttpEntity(response.getEntity(), builder);
            EntityUtils.consume((HttpEntity)response.getEntity());
            ConfluenceRestrictionsResponse<? extends ConfluenceResource> confluenceRestrictionsResponse = confluenceResponse;
            return confluenceRestrictionsResponse;
        }
        catch (IOException e) {
            this.logger.error("[Processing] Failed to get page(s)", (Throwable)e);
            throw new Exception("Confluence appears to be down", e);
        }
    }

    private <T extends ConfluenceResource> ConfluenceResponse<T> responseFromHttpEntity(HttpEntity entity, ConfluenceResourceBuilder<T> builder) throws Exception {
        JSONParser parser = new JSONParser();
        String stringEntity = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONObject responseObject = (JSONObject)parser.parse((Reader)new StringReader(stringEntity));
        ConfluenceResponse<T> response = ConfluenceResponse.fromJson(responseObject, builder);
        if (response.getResults().size() == 0) {
            this.logger.debug("[Processing] No {} found in the Confluence response", (Object)builder.getType().getSimpleName());
        }
        return response;
    }

    private <T extends ConfluenceResource> ConfluenceRestrictionsResponse<T> restrictionsResponseFromHttpEntity(HttpEntity entity, ConfluenceResourceBuilder<T> builder) throws Exception {
        JSONParser parser = new JSONParser();
        String stringEntity = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONObject responseObject = (JSONObject)parser.parse((Reader)new StringReader(stringEntity));
        ConfluenceRestrictionsResponse<T> response = ConfluenceRestrictionsResponse.fromJson(responseObject, builder);
        if (response.getResult() == null) {
            this.logger.debug("[Processing] No {} found in the Confluence Restrictions response", (Object)builder.getType().getSimpleName());
        }
        return response;
    }

    public ConfluenceResponse<Attachment> getPageAttachments(String pageId) throws Exception {
        return this.getPageAttachments(pageId, 0, 50);
    }

    public ConfluenceResponse<Attachment> getPageAttachments(String pageId, int start, int limit) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s%s?limit=%s&start=%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, pageId, CHILD_ATTACHMENTS_PATH, limit, start);
        ConfluenceResponse<? extends ConfluenceResource> confluenceResources = this.getConfluenceResources(url, Attachment.builder());
        return confluenceResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attachment getAttachment(String attachmentId) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s?%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, attachmentId, EXPANDABLE_PARAMETERS);
        this.logger.debug("[Processing] Hitting url for getting document content : {}", (Object)this.sanitizeUrl(url));
        HttpGet httpGet = this.createGetRequest(url);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            MutableAttachment attachment = this.attachmentFromHttpEntity(entity);
            EntityUtils.consume((HttpEntity)entity);
            this.retrieveAndSetAttachmentContent(attachment);
            MutableAttachment mutableAttachment = attachment;
            return mutableAttachment;
        }
        catch (Exception e) {
            this.logger.error("[Processing] Failed to get attachment {}. Error: {}", (Object)url, (Object)e.getMessage());
            throw e;
        }
    }

    private void retrieveAndSetAttachmentContent(MutableAttachment attachment) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(attachment.getBaseUrl()).append(attachment.getUrlContext()).append(attachment.getDownloadUrl());
        String url = this.sanitizeUrl(sb.toString());
        this.logger.debug("[Processing] Hitting url for getting attachment content : {}", (Object)url);
        HttpGet httpGet = this.createGetRequest(url);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)httpGet);){
            attachment.setLength(response.getEntity().getContentLength());
            byte[] byteContent = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            attachment.setContentStream(new ByteArrayInputStream(byteContent));
        }
        catch (Exception e) {
            this.logger.error("[Processing] Failed to get attachment content from {}. Error: {}", (Object)url, (Object)e.getMessage());
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page getPage(String pageId) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s?%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, pageId, EXPANDABLE_PARAMETERS);
        url = this.sanitizeUrl(url);
        this.logger.debug("[Processing] Hitting url for getting document content : {}", (Object)url);
        HttpGet httpGet = this.createGetRequest(url);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            MutablePage page = this.pageFromHttpEntity(entity);
            EntityUtils.consume((HttpEntity)entity);
            List<Label> labels = this.getLabels(pageId);
            page.setLabels(labels);
            MutablePage mutablePage = page;
            return mutablePage;
        }
        catch (Exception e) {
            this.logger.error("[Processing] Failed to get page {}. Error: {}", (Object)url, (Object)e.getMessage());
            throw e;
        }
    }

    public ConfluenceRestrictionsResponse<Restrictions> getPageReadRestrictions(int start, int limit, String pageId) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s%s?limit=%s&start=%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, pageId, READ_RESTRICTIONS_PATH, limit, start);
        return this.getConfluenceRestrictionsResources(url, Restrictions.builder());
    }

    public List<Label> getLabels(String pageId) {
        ArrayList labels = Lists.newArrayList();
        int lastStart = 0;
        int limit = 50;
        boolean isLast = false;
        do {
            String url = String.format(Locale.ROOT, "%s://%s:%s%s%s/%s/%s?start=%s&limit=%s", this.protocol, this.host, this.port, this.path, CONTENT_PATH, pageId, LABEL_PATH, lastStart, 50);
            url = this.sanitizeUrl(url);
            this.logger.debug("[Processing] Hitting url for getting page labels : {}", (Object)url);
            try {
                ConfluenceResponse<? extends ConfluenceResource> response = this.getConfluenceResources(url, Label.builder());
                labels.addAll(response.getResults());
                lastStart += response.getResults().size();
                isLast = response.isLast();
            }
            catch (Exception e) {
                this.logger.debug("Error getting labels for page {}. Reason: {}", (Object)pageId, (Object)e.getMessage());
            }
        } while (!isLast);
        return labels;
    }

    public ConfluenceUser getUserAuthorities(String username) throws Exception {
        ArrayList authorities = Lists.newArrayList();
        List<Group> groups = this.getUserGroups(username);
        groups.forEach(group -> authorities.add("group-" + group.getName()));
        User user = this.getConfluenceUser(username);
        authorities.add("user-" + user.getUserKey());
        List<Space> spaces = this.getSpaces();
        for (Space space : spaces) {
            List<String> permissions = this.getSpacePermissionsForUser(space, username);
            if (!permissions.contains(VIEW_PERMISSION)) continue;
            authorities.add("space-" + space.getKey());
        }
        return new ConfluenceUser(username, authorities);
    }

    private User getConfluenceUser(String username) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s?username=%s", this.protocol, this.host, this.port, this.path, USER_PATH, username);
        HttpGet httpGet = this.createGetRequest(url);
        try (CloseableHttpResponse response = this.executeRequest((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            User user = this.userFromHttpEntity(entity);
            EntityUtils.consume((HttpEntity)entity);
            User user2 = user;
            return user2;
        }
    }

    private List<Group> getUserGroups(String username) throws Exception {
        long lastStart = 0L;
        long defaultSize = 50L;
        ArrayList<Group> groups = new ArrayList<Group>();
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            String groupsDesc = "groups of user " + username;
            Logging.connectors.debug((Object)new MessageFormat("Starting from {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 50L, groupsDesc}));
        }
        Boolean isLast = true;
        do {
            ConfluenceResponse<Group> response = this.getUserGroups((int)lastStart, 50, username);
            int count = 0;
            for (Group group : response.getResults()) {
                groups.add(group);
                ++count;
            }
            lastStart += (long)count;
            isLast = response.isLast();
            if (Logging.connectors == null || !Logging.connectors.isDebugEnabled()) continue;
            Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1}", Locale.ROOT).format(new Object[]{lastStart, 50L}));
        } while (!isLast.booleanValue());
        return groups;
    }

    public ConfluenceResponse<Group> getUserGroups(int start, int limit, String username) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s?username=%s&limit=%s&start=%s", this.protocol, this.host, this.port, this.path, USER_GROUPS_PATH, username, limit, start);
        return this.getConfluenceResources(url, Group.builder());
    }

    private HttpPost createPostRequest(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-Type", "application/json");
        if (this.useBasicAuthentication()) {
            httpPost.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])String.format(Locale.ROOT, "%s:%s", this.username, this.password).getBytes(Charset.forName("UTF-8"))));
        }
        return httpPost;
    }

    private CloseableHttpResponse executeRequest(HttpUriRequest request) throws Exception {
        String url = request.getURI().toString();
        this.logger.debug("[Processing] Hitting url for getting document content : {}", (Object)url);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute(request, (HttpContext)this.httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                String errorDesc = response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
                response.close();
                throw new Exception("Confluence error. " + errorDesc);
            }
            return response;
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            this.logger.error("[Processing] Failed to get page {}. Error: {}", (Object)url, (Object)e.getMessage());
            throw e;
        }
    }

    private User userFromHttpEntity(HttpEntity entity) throws Exception {
        String stringEntity = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONParser parser = new JSONParser();
        JSONObject responseObject = (JSONObject)parser.parse((Reader)new StringReader(stringEntity));
        User user = User.builder().fromJson(responseObject);
        return user;
    }

    private MutablePage pageFromHttpEntity(HttpEntity entity) throws Exception {
        String stringEntity = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONParser parser = new JSONParser();
        JSONObject responseObject = (JSONObject)parser.parse((Reader)new StringReader(stringEntity));
        MutablePage response = (MutablePage)MutablePage.builder().fromJson(responseObject, new MutablePage());
        return response;
    }

    private MutableAttachment attachmentFromHttpEntity(HttpEntity entity) throws Exception {
        String stringEntity = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONParser parser = new JSONParser();
        JSONObject responseObject = (JSONObject)parser.parse((Reader)new StringReader(stringEntity));
        MutableAttachment response = (MutableAttachment)Attachment.builder().fromJson(responseObject, new MutableAttachment());
        return response;
    }

    private boolean useBasicAuthentication() {
        return this.username != null && !"".equals(this.username) && this.password != null;
    }

    private String sanitizeUrl(String url) {
        int colonIndex = url.indexOf(":");
        String urlWithoutProtocol = url.startsWith("http") ? url.substring(colonIndex + 3) : url;
        String sanitizedUrl = urlWithoutProtocol.replaceAll("\\/+", "/");
        return url.substring(0, colonIndex) + "://" + sanitizedUrl;
    }

    public ConfluenceResponse<Space> getSpaces(int start, int limit, Optional<String> spaceType, Optional<String> spaceStatus) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%s?limit=%s&start=%s", this.protocol, this.host, this.port, this.path, SPACES_PATH, limit, start);
        if (spaceType.isPresent()) {
            url = String.format(Locale.ROOT, "%s&type=%s", url, spaceType.get());
        }
        if (spaceStatus.isPresent()) {
            url = String.format(Locale.ROOT, "%s&status=%s", url, spaceStatus.get());
        }
        return this.getConfluenceResources(url, Space.builder());
    }

    private List<Space> getSpaces() throws Exception {
        ArrayList<Space> spaces = new ArrayList<Space>();
        long lastStart = 0L;
        long defaultSize = 25L;
        Boolean isLast = true;
        do {
            ConfluenceResponse<Space> response = this.getSpaces((int)lastStart, 25, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent());
            spaces.addAll(response.getResults());
            lastStart += (long)response.getResults().size();
            isLast = response.isLast();
            if (Logging.connectors == null || !Logging.connectors.isDebugEnabled()) continue;
            Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 25L, "getSpaces"}));
        } while (!isLast.booleanValue());
        return spaces;
    }

    private List<String> getSpacePermissionsForUser(Space space, String username) throws Exception {
        String url = String.format(Locale.ROOT, "%s://%s:%s%s%sgetPermissionsForUser", this.protocol, this.host, this.port, this.path, AUTHORITY_PATH);
        this.logger.debug("[Processing] Hitting url {} for getting Confluence permissions for user {} in space {}", new Object[]{url, username, space.getKey()});
        HttpPost httpPost = this.createPostRequest(url);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)space.getKey());
        jsonArray.add((Object)username);
        StringEntity stringEntity = new StringEntity(jsonArray.toJSONString());
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new ConfluenceException("Confluence error. " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        HttpEntity entity = response.getEntity();
        List<String> permissions = this.permissionsFromHttpEntity(entity);
        EntityUtils.consume((HttpEntity)entity);
        return permissions;
    }

    private List<String> permissionsFromHttpEntity(HttpEntity entity) throws Exception {
        String stringEntity = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONParser parser = new JSONParser();
        Object parsedReponse = parser.parse((Reader)new StringReader(stringEntity));
        ArrayList permissions = Lists.newArrayList();
        if (parsedReponse instanceof JSONArray) {
            JSONArray responseObject = (JSONArray)parsedReponse;
            int len = responseObject.size();
            for (int i = 0; i < len; ++i) {
                permissions.add(responseObject.get(i).toString());
            }
        } else {
            JSONObject responseObject = (JSONObject)parsedReponse;
            if (responseObject.containsKey((Object)"error")) {
                JSONObject error = (JSONObject)responseObject.get((Object)"error");
                String message = error.get((Object)"message").toString();
                this.logger.warn("Confluence authority: Can't get user permissions; " + message);
                return new ArrayList<String>(0);
            }
            throw new Exception("Unexpected JSON format: " + responseObject);
        }
        return permissions;
    }
}

