/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Angle;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="CartesianCSType")
@XmlRootElement(name="CartesianCS")
public class DefaultCartesianCS
extends DefaultAffineCS
implements CartesianCS {
    private static final long serialVersionUID = -6182037957705712945L;

    private DefaultCartesianCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
        this.ensurePerpendicularAxis(map);
    }

    public DefaultCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        this.ensurePerpendicularAxis(map);
    }

    protected DefaultCartesianCS(CartesianCS cartesianCS) {
        super((AffineCS)cartesianCS);
        this.ensurePerpendicularAxis(null);
    }

    public static DefaultCartesianCS castOrCopy(CartesianCS cartesianCS) {
        return cartesianCS == null || cartesianCS instanceof DefaultCartesianCS ? (DefaultCartesianCS)cartesianCS : new DefaultCartesianCS(cartesianCS);
    }

    private void ensurePerpendicularAxis(Map<String, ?> map) throws IllegalArgumentException {
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            AxisDirection axisDirection = this.getAxis(i).getDirection();
            int n2 = i;
            while (++n2 < n) {
                AxisDirection axisDirection2 = this.getAxis(n2).getDirection();
                Angle angle = CoordinateSystems.angle(axisDirection, axisDirection2);
                if (angle == null || Math.abs(angle.degrees()) == 90.0) continue;
                throw new IllegalArgumentException(Resources.forProperties(map).getString((short)56, axisDirection, axisDirection2));
            }
        }
    }

    public Class<? extends CartesianCS> getInterface() {
        return CartesianCS.class;
    }

    @Override
    public DefaultCartesianCS forConvention(AxesConvention axesConvention) {
        return (DefaultCartesianCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 2: 
            case 3: {
                return new DefaultCartesianCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultCartesianCS.unexpectedDimension(map, coordinateSystemAxisArray, 2);
    }

    private DefaultCartesianCS() {
    }
}

