/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.IllformedLocaleException;
import java.util.Set;
import javax.measure.format.ParserException;
import org.apache.sis.internal.converter.ObjectToString;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;

abstract class StringConverter<T>
extends SystemConverter<String, T> {
    private static final long serialVersionUID = -7181934724345598473L;
    private final ObjectConverter<T, String> inverse = this.createInverse();

    StringConverter(Class<T> clazz) {
        super(String.class, clazz);
    }

    ObjectConverter<T, String> createInverse() {
        return new ObjectToString(this.targetClass, this);
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.SURJECTIVE, FunctionProperty.INVERTIBLE);
    }

    @Override
    public final ObjectConverter<T, String> inverse() {
        return this.inverse;
    }

    @Override
    public final T apply(String string) throws UnconvertibleObjectException {
        if ((string = CharSequences.trimWhitespaces(string)) == null || string.isEmpty()) {
            return null;
        }
        try {
            return this.doConvert(string);
        }
        catch (UnconvertibleObjectException unconvertibleObjectException) {
            throw unconvertibleObjectException;
        }
        catch (Exception exception) {
            throw new UnconvertibleObjectException(this.formatErrorMessage(string), exception);
        }
    }

    abstract T doConvert(String var1) throws Exception;

    static final class Enum<T extends java.lang.Enum<T>>
    extends StringConverter<T> {
        private static final long serialVersionUID = -4124617013044304640L;

        Enum(Class<T> clazz) {
            super(clazz);
        }

        @Override
        T doConvert(String string) {
            Object t = Types.forEnumName(this.targetClass, string);
            if (t == null) {
                throw new UnconvertibleObjectException(this.formatErrorMessage(string));
            }
            return t;
        }

        @Override
        ObjectConverter<T, String> createInverse() {
            return new ObjectToString.Enum(this.targetClass, this);
        }
    }

    static final class CodeList<T extends org.opengis.util.CodeList<T>>
    extends StringConverter<T> {
        private static final long serialVersionUID = -6351669842222010105L;

        CodeList(Class<T> clazz) {
            super(clazz);
        }

        @Override
        T doConvert(String string) {
            Object t = Types.forCodeName(this.targetClass, string, false);
            if (t == null) {
                throw new UnconvertibleObjectException(this.formatErrorMessage(string));
            }
            return t;
        }

        @Override
        ObjectConverter<T, String> createInverse() {
            return new ObjectToString.CodeList(this.targetClass, this);
        }
    }

    public static final class InternationalString
    extends StringConverter<org.opengis.util.InternationalString> {
        private static final long serialVersionUID = -7386778914761469877L;

        public InternationalString() {
            super(org.opengis.util.InternationalString.class);
        }

        @Override
        org.opengis.util.InternationalString doConvert(String string) {
            return new SimpleInternationalString(string);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return InternationalString.bijective();
        }
    }

    public static final class Angle
    extends StringConverter<org.apache.sis.measure.Angle> {
        private static final long serialVersionUID = -6937967772504961327L;

        public Angle() {
            super(org.apache.sis.measure.Angle.class);
        }

        @Override
        org.apache.sis.measure.Angle doConvert(String string) throws NumberFormatException {
            return new org.apache.sis.measure.Angle(string);
        }
    }

    public static final class Unit
    extends StringConverter<javax.measure.Unit<?>> {
        private static final long serialVersionUID = -1809497218136016210L;

        public Unit() {
            super(javax.measure.Unit.class);
        }

        @Override
        javax.measure.Unit<?> doConvert(String string) throws ParserException {
            return Units.valueOf(string);
        }
    }

    public static final class URL
    extends StringConverter<java.net.URL> {
        private static final long serialVersionUID = -6518011235037500143L;

        public URL() {
            super(java.net.URL.class);
        }

        @Override
        java.net.URL doConvert(String string) throws MalformedURLException {
            return new java.net.URL(string);
        }
    }

    public static final class URI
    extends StringConverter<java.net.URI> {
        private static final long serialVersionUID = 7266486748714603336L;

        public URI() {
            super(java.net.URI.class);
        }

        @Override
        java.net.URI doConvert(String string) throws URISyntaxException {
            return new java.net.URI(string);
        }
    }

    public static final class Path
    extends StringConverter<java.nio.file.Path> {
        private static final long serialVersionUID = -1737315635965906042L;

        public Path() {
            super(java.nio.file.Path.class);
        }

        @Override
        java.nio.file.Path doConvert(String string) throws InvalidPathException {
            return Paths.get(string, new String[0]);
        }
    }

    public static final class File
    extends StringConverter<java.io.File> {
        private static final long serialVersionUID = -2157537605361631529L;

        public File() {
            super(java.io.File.class);
        }

        @Override
        java.io.File doConvert(String string) {
            return new java.io.File(string);
        }
    }

    public static final class Charset
    extends StringConverter<java.nio.charset.Charset> {
        private static final long serialVersionUID = 4375157214436581095L;

        public Charset() {
            super(java.nio.charset.Charset.class);
        }

        @Override
        java.nio.charset.Charset doConvert(String string) throws UnsupportedCharsetException {
            return java.nio.charset.Charset.forName(string);
        }
    }

    public static final class Locale
    extends StringConverter<java.util.Locale> {
        private static final long serialVersionUID = -794933131690043494L;

        public Locale() {
            super(java.util.Locale.class);
        }

        @Override
        java.util.Locale doConvert(String string) throws IllformedLocaleException {
            return Locales.parse(string);
        }
    }

    public static final class Boolean
    extends StringConverter<java.lang.Boolean> {
        private static final long serialVersionUID = 4689076223535035309L;

        public Boolean() {
            super(java.lang.Boolean.class);
        }

        @Override
        java.lang.Boolean doConvert(String string) throws UnconvertibleObjectException {
            switch (string.toLowerCase(java.util.Locale.ROOT)) {
                case "true": 
                case "yes": 
                case "on": 
                case "1": {
                    return java.lang.Boolean.TRUE;
                }
                case "false": 
                case "no": 
                case "off": 
                case "0": {
                    return java.lang.Boolean.FALSE;
                }
            }
            throw new UnconvertibleObjectException(this.formatErrorMessage(string));
        }
    }

    public static final class BigInteger
    extends StringConverter<java.math.BigInteger> {
        private static final long serialVersionUID = 6387019773702794255L;

        public BigInteger() {
            super(java.math.BigInteger.class);
        }

        @Override
        java.math.BigInteger doConvert(String string) throws NumberFormatException {
            return new java.math.BigInteger(string);
        }
    }

    public static final class BigDecimal
    extends StringConverter<java.math.BigDecimal> {
        private static final long serialVersionUID = -5949128086478498785L;

        public BigDecimal() {
            super(java.math.BigDecimal.class);
        }

        @Override
        java.math.BigDecimal doConvert(String string) throws NumberFormatException {
            return new java.math.BigDecimal(string);
        }
    }

    public static final class Byte
    extends StringConverter<java.lang.Byte> {
        private static final long serialVersionUID = 6934470534898203474L;

        public Byte() {
            super(java.lang.Byte.class);
        }

        @Override
        java.lang.Byte doConvert(String string) throws NumberFormatException {
            return java.lang.Byte.parseByte(string);
        }
    }

    public static final class Short
    extends StringConverter<java.lang.Short> {
        private static final long serialVersionUID = 4067703596268901375L;

        public Short() {
            super(java.lang.Short.class);
        }

        @Override
        java.lang.Short doConvert(String string) throws NumberFormatException {
            return java.lang.Short.parseShort(string);
        }
    }

    public static final class Integer
    extends StringConverter<java.lang.Integer> {
        private static final long serialVersionUID = -5024227987148221073L;

        public Integer() {
            super(java.lang.Integer.class);
        }

        @Override
        java.lang.Integer doConvert(String string) throws NumberFormatException {
            return java.lang.Integer.parseInt(string);
        }
    }

    public static final class Long
    extends StringConverter<java.lang.Long> {
        private static final long serialVersionUID = 4711495660311641145L;

        public Long() {
            super(java.lang.Long.class);
        }

        @Override
        java.lang.Long doConvert(String string) throws NumberFormatException {
            return java.lang.Long.parseLong(string);
        }
    }

    public static final class Float
    extends StringConverter<java.lang.Float> {
        private static final long serialVersionUID = 2301101264860653956L;

        public Float() {
            super(java.lang.Float.class);
        }

        @Override
        java.lang.Float doConvert(String string) throws NumberFormatException {
            return java.lang.Float.valueOf(java.lang.Float.parseFloat(string));
        }
    }

    public static final class Double
    extends StringConverter<java.lang.Double> {
        private static final long serialVersionUID = -8576620873911755486L;

        public Double() {
            super(java.lang.Double.class);
        }

        @Override
        java.lang.Double doConvert(String string) throws NumberFormatException {
            return java.lang.Double.parseDouble(string);
        }
    }

    public static final class Number
    extends StringConverter<java.lang.Number> {
        private static final long serialVersionUID = 8356246549731207392L;

        public Number() {
            super(java.lang.Number.class);
        }

        @Override
        java.lang.Number doConvert(String string) throws NumberFormatException {
            return Numbers.narrowestNumber(string);
        }
    }
}

