/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class ScaleTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 8527439133082104085L;
    private final double[] factors;
    private final double[] errors;
    private final int numDroppedDimensions;

    ScaleTransform(int n, int n2, double[] dArray) {
        this.numDroppedDimensions = n2 - n;
        int n3 = n * n2;
        this.factors = new double[n - 1];
        double[] dArray2 = null;
        int n4 = -1;
        for (int i = 0; i < this.factors.length; ++i) {
            double d;
            int n5 = n2 * i + i;
            this.factors[i] = dArray[n5];
            if ((n5 += n3) >= dArray.length || (d = dArray[n5]) == 0.0) continue;
            if (dArray2 == null) {
                dArray2 = new double[n];
            }
            dArray2[i] = d;
            n4 = i;
        }
        this.errors = ArraysExt.resize(dArray2, n4 + 1);
    }

    @Override
    public double[] getExtendedElements() {
        int n = this.getNumCol();
        int n2 = this.getNumRow() * n;
        double[] dArray = new double[this.errors == null ? n2 : n2 << 1];
        for (int i = 0; i < this.factors.length; ++i) {
            int n3 = n * i + i;
            dArray[n3] = this.factors[i];
            if (this.errors == null || i >= this.errors.length) continue;
            dArray[n3 + n2] = this.errors[i];
        }
        dArray[n2 - 1] = 1.0;
        return dArray;
    }

    @Override
    public int getSourceDimensions() {
        return this.factors.length + this.numDroppedDimensions;
    }

    @Override
    public int getTargetDimensions() {
        return this.factors.length;
    }

    public double getElement(int n, int n2) {
        int n3 = this.factors.length;
        int n4 = n3 + this.numDroppedDimensions;
        ArgumentChecks.ensureBetween("row", 0, n3, n);
        ArgumentChecks.ensureBetween("column", 0, n4, n2);
        if (n == n3) {
            return n2 == n4 ? 1.0 : 0.0;
        }
        return n == n2 ? this.factors[n] : 0.0;
    }

    @Override
    public boolean isIdentity() {
        if (this.numDroppedDimensions != 0) {
            return false;
        }
        for (int i = 0; i < this.factors.length; ++i) {
            if (this.factors[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        this.transform(dArray, n, dArray2, n2, 1);
        return bl ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5;
        if (dArray == dArray2 && IterationStrategy.suggest(n, n5 = (n4 = this.factors.length) + this.numDroppedDimensions, n2, n4, n3) != IterationStrategy.ASCENDING) {
            dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
            n = 0;
        }
        while (--n3 >= 0) {
            for (n4 = 0; n4 < this.factors.length; ++n4) {
                dArray2[n2++] = dArray[n++] * this.factors[n4];
            }
            n += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5;
        if (fArray == fArray2 && IterationStrategy.suggest(n, n5 = (n4 = this.factors.length) + this.numDroppedDimensions, n2, n4, n3) != IterationStrategy.ASCENDING) {
            fArray = Arrays.copyOfRange(fArray, n, n + n3 * n5);
            n = 0;
        }
        while (--n3 >= 0) {
            for (n4 = 0; n4 < this.factors.length; ++n4) {
                fArray2[n2++] = (float)((double)fArray[n++] * this.factors[n4]);
            }
            n += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                fArray[n2++] = (float)(dArray[n++] * this.factors[i]);
            }
            n += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dArray[n2++] = (double)fArray[n++] * this.factors[i];
            }
            n += this.numDroppedDimensions;
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        int n = this.factors.length;
        MatrixSIS matrixSIS = Matrices.createZero(n, n + this.numDroppedDimensions);
        for (int i = 0; i < n; ++i) {
            matrixSIS.setElement(i, i, this.factors[i]);
        }
        return matrixSIS;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.factors) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        ScaleTransform scaleTransform = (ScaleTransform)object;
        return this.numDroppedDimensions == scaleTransform.numDroppedDimensions && Arrays.equals(this.factors, scaleTransform.factors) && Arrays.equals(this.errors, scaleTransform.errors);
    }
}

