/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.NTv2;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = -8962688502524486475L;
    private static final int GRID_DIMENSION = 2;
    private final int dimension;
    private final Inverse inverse;

    protected <T extends Quantity<T>> InterpolatedTransform(DatumShiftGrid<T, T> datumShiftGrid) throws NoninvertibleMatrixException {
        super(datumShiftGrid instanceof DatumShiftGridFile ? ((DatumShiftGridFile)datumShiftGrid).descriptor : NTv2.PARAMETERS, datumShiftGrid);
        Serializable serializable;
        Unit<Angle> unit;
        if (!datumShiftGrid.isCellValueRatio()) {
            throw new IllegalArgumentException(Resources.format((short)25, "isCellValueRatio", Boolean.FALSE));
        }
        Unit<T> unit2 = datumShiftGrid.getTranslationUnit();
        if (unit2 != datumShiftGrid.getCoordinateUnit()) {
            throw new IllegalArgumentException(Resources.format((short)26, "translation", unit2));
        }
        this.dimension = datumShiftGrid.getTranslationDimensions();
        if (datumShiftGrid instanceof DatumShiftGridFile) {
            ((DatumShiftGridFile)datumShiftGrid).setFileParameters(this.context);
        }
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        matrixSIS.setMatrix(datumShiftGrid.getCoordinateToGrid().getMatrix());
        Unit<Angle> unit3 = unit = Units.isAngular(unit2) ? Units.DEGREE : unit2.getSystemUnit();
        if (!unit2.equals(unit)) {
            serializable = 1.0;
            Number number = 0.0;
            Number[] numberArray = Units.coefficients(unit.getConverterTo(unit2));
            switch (numberArray != null ? numberArray.length : -1) {
                case 2: {
                    serializable = numberArray[1];
                }
                case 1: {
                    number = numberArray[0];
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Resources.format((short)54, unit, unit2));
                }
            }
            for (int i = 0; i < this.dimension; ++i) {
                matrixSIS.convertBefore(i, (Number)serializable, number);
            }
        }
        serializable = null;
        if (datumShiftGrid instanceof DatumShiftGridFile) {
            serializable = ((DatumShiftGridFile)datumShiftGrid).gridToTarget();
        }
        if (serializable == null) {
            serializable = matrixSIS.inverse();
        }
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).setMatrix((Matrix)serializable);
        this.inverse = this.createInverse();
    }

    public static <T extends Quantity<T>> MathTransform createGeodeticTransformation(MathTransformFactory mathTransformFactory, DatumShiftGrid<T, T> datumShiftGrid) throws FactoryException {
        InterpolatedTransform interpolatedTransform;
        ArgumentChecks.ensureNonNull("grid", datumShiftGrid);
        try {
            interpolatedTransform = datumShiftGrid.getTranslationDimensions() == 2 ? new InterpolatedTransform2D(datumShiftGrid) : new InterpolatedTransform(datumShiftGrid);
        }
        catch (NoninvertibleMatrixException noninvertibleMatrixException) {
            throw new FactoryException(noninvertibleMatrixException.getLocalizedMessage(), (Throwable)((Object)noninvertibleMatrixException));
        }
        return interpolatedTransform.context.completeTransform(mathTransformFactory, interpolatedTransform);
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        if (dArray2 != null) {
            double[] dArray3 = new double[this.dimension];
            this.grid.interpolateInCell(d, d2, dArray3);
            if (this.dimension > 2) {
                System.arraycopy(dArray, n + 2, dArray2, n2 + 2, this.dimension - 2);
                int n3 = this.dimension;
                do {
                    int n4 = n2 + --n3;
                    dArray2[n4] = dArray2[n4] + dArray3[n3];
                } while (n3 > 2);
            }
            dArray2[n2 + 1] = d2 + dArray3[1];
            dArray2[n2] = d + dArray3[0];
        }
        if (!bl) {
            return null;
        }
        return this.grid.derivativeInCell(d, d2);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = this.dimension;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n2 += (n3 - 1) * n4;
                    n4 = -n4;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                    n = 0;
                }
            }
        }
        double[] dArray3 = new double[this.dimension];
        while (--n3 >= 0) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            this.grid.interpolateInCell(d, d2, dArray3);
            if (this.dimension > 2) {
                System.arraycopy(dArray, n + 2, dArray2, n2 + 2, this.dimension - 2);
                int n5 = this.dimension;
                do {
                    int n6 = n2 + --n5;
                    dArray2[n6] = dArray2[n6] + dArray3[n5];
                } while (n5 > 2);
            }
            dArray2[n2 + 1] = d2 + dArray3[1];
            dArray2[n2] = d + dArray3[0];
            n2 += n4;
            n += n4;
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    Inverse createInverse() {
        return new Inverse();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        return super.equals(object, comparisonMode) && Objects.equals(this.grid, ((InterpolatedTransform)object).grid);
    }

    class Inverse
    extends AbstractMathTransform.Inverse {
        private static final long serialVersionUID = -6779719408779847014L;
        private final double tolerance;

        Inverse() {
            this.tolerance = InterpolatedTransform.this.grid.getCellPrecision();
            if (!(this.tolerance > 0.0)) {
                throw new IllegalArgumentException(Errors.format((short)165, "grid.cellPrecision", this.tolerance));
            }
        }

        @Override
        public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double d;
            double d2;
            if (dArray2 == null) {
                dArray2 = new double[InterpolatedTransform.this.dimension];
                n2 = 0;
            }
            double d3 = d2 = dArray[n];
            double d4 = d = dArray[n + 1];
            double[] dArray3 = new double[InterpolatedTransform.this.dimension];
            int n3 = 15;
            do {
                InterpolatedTransform.this.grid.interpolateInCell(d2, d, dArray3);
                double d5 = d2;
                double d6 = d;
                d2 = d3 - dArray3[0];
                d = d4 - dArray3[1];
                if (Math.abs(d2 - d5) > this.tolerance || Math.abs(d - d6) > this.tolerance) continue;
                if (InterpolatedTransform.this.dimension > 2) {
                    System.arraycopy(dArray, n + 2, dArray2, n2 + 2, InterpolatedTransform.this.dimension - 2);
                    int n4 = InterpolatedTransform.this.dimension;
                    do {
                        int n5 = n2 + --n4;
                        dArray2[n5] = dArray2[n5] + dArray3[n4];
                    } while (n4 > 2);
                }
                dArray2[n2] = d2;
                dArray2[n2 + 1] = d;
                if (bl) {
                    return Matrices.inverse(InterpolatedTransform.this.derivative(new DirectPositionView(dArray2, n2, InterpolatedTransform.this.dimension)));
                }
                return null;
            } while (--n3 >= 0);
            throw new TransformException(Resources.format((short)46));
        }

        @Override
        public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            int n4 = InterpolatedTransform.this.dimension;
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, n4, n2, n4, n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        n += (n3 - 1) * n4;
                        n2 += (n3 - 1) * n4;
                        n4 = -n4;
                        break;
                    }
                    default: {
                        dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                        n = 0;
                    }
                }
            }
            double[] dArray3 = new double[InterpolatedTransform.this.dimension];
            block4: while (--n3 >= 0) {
                double d;
                double d2;
                double d3 = d2 = dArray[n];
                double d4 = d = dArray[n + 1];
                int n5 = 15;
                do {
                    InterpolatedTransform.this.grid.interpolateInCell(d2, d, dArray3);
                    double d5 = d2;
                    double d6 = d;
                    d2 = d3 - dArray3[0];
                    d = d4 - dArray3[1];
                    if (Math.abs(d2 - d5) > this.tolerance || Math.abs(d - d6) > this.tolerance) continue;
                    if (InterpolatedTransform.this.dimension > 2) {
                        System.arraycopy(dArray, n + 2, dArray2, n2 + 2, InterpolatedTransform.this.dimension - 2);
                        int n6 = InterpolatedTransform.this.dimension;
                        do {
                            int n7 = n2 + --n6;
                            dArray2[n7] = dArray2[n7] + dArray3[n6];
                        } while (n6 > 2);
                    }
                    dArray2[n2] = d2;
                    dArray2[n2 + 1] = d;
                    n2 += n4;
                    n += n4;
                    continue block4;
                } while (--n5 >= 0);
                throw new TransformException(Resources.format((short)46));
            }
        }
    }
}

