/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class IdentifiedObjectSet<T extends IdentifiedObject>
extends AbstractSet<T>
implements CheckedContainer<T>,
Localized {
    final Map<String, T> objects = new LinkedHashMap<String, T>();
    private transient String[] codes;
    protected final AuthorityFactory factory;
    private final AuthorityFactoryProxy<? super T> proxy;
    private final Class<T> type;

    public IdentifiedObjectSet(AuthorityFactory authorityFactory, Class<T> clazz) {
        ArgumentChecks.ensureNonNull("factory", authorityFactory);
        ArgumentChecks.ensureNonNull("type", clazz);
        this.proxy = AuthorityFactoryProxy.getInstance(clazz);
        this.factory = authorityFactory;
        this.type = clazz;
    }

    @Override
    public Locale getLocale() {
        return this.factory instanceof Localized ? ((Localized)this.factory).getLocale() : null;
    }

    @Override
    public Class<T> getElementType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.codes = null;
            this.objects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<String, T> map = this.objects;
        synchronized (map) {
            return this.objects.size();
        }
    }

    public String[] getAuthorityCodes() {
        return (String[])this.codes().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String[] codes() {
        Map<String, T> map = this.objects;
        synchronized (map) {
            if (this.codes == null) {
                Set<String> set = this.objects.keySet();
                this.codes = set.toArray(new String[set.size()]);
            }
            return this.codes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorityCodes(String ... stringArray) {
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.codes = null;
            HashMap<String, T> hashMap = new HashMap<String, T>(this.objects);
            this.objects.clear();
            for (String string : stringArray) {
                this.objects.put(string, hashMap.get(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorityCode(String string) {
        Map<String, T> map = this.objects;
        synchronized (map) {
            if (JDK8.putIfAbsent(this.objects, string, null) == null) {
                this.codes = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        IdentifiedObject identifiedObject;
        String string = this.getAuthorityCode(t);
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.codes = null;
            identifiedObject = (IdentifiedObject)this.objects.put(string, t);
        }
        return !Objects.equals(identifiedObject, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final T get(String string) throws BackingStoreException {
        boolean bl;
        Object object;
        Map<String, T> map = this.objects;
        synchronized (map) {
            object = (IdentifiedObject)this.objects.get(string);
            bl = object != null || !this.objects.containsKey(string);
        }
        if (!bl) {
            LogRecord logRecord;
            try {
                object = this.createObject(string);
                bl = true;
            }
            catch (FactoryException factoryException) {
                if (!this.isRecoverableFailure(factoryException)) {
                    throw new BackingStoreException(factoryException);
                }
                logRecord = Messages.getResources(this.getLocale()).getLogRecord(Level.WARNING, (short)3, this.type, string, IdentifiedObjectSet.getCause(factoryException));
                logRecord.setLoggerName("org.apache.sis.referencing.factory");
                Logging.log(IdentifiedObjectSet.class, "createObject", logRecord);
            }
            map = this.objects;
            synchronized (map) {
                if (bl) {
                    if (this.objects.containsKey(string) && (logRecord = JDK8.putIfAbsent(this.objects, string, object)) != null) {
                        object = logRecord;
                    }
                } else if (JDK8.remove(this.objects, string, null)) {
                    this.codes = null;
                }
            }
        }
        return (T)object;
    }

    @Override
    public boolean contains(Object object) {
        return object != null && object.equals(this.get(this.getAuthorityCode((IdentifiedObject)this.type.cast(object))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeAuthorityCode(String string) {
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.objects.remove(string);
            this.codes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        String string;
        T t;
        if (object != null && object.equals(t = this.get(string = this.getAuthorityCode((IdentifiedObject)this.type.cast(object))))) {
            Map<String, T> map = this.objects;
            synchronized (map) {
                this.objects.remove(string);
                this.codes = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public Iterator<T> iterator() throws BackingStoreException {
        return new Iterator<T>(){
            private final String[] keys;
            private int index;
            private T next;
            private boolean canRemove;
            {
                this.keys = IdentifiedObjectSet.this.codes();
            }

            @Override
            public boolean hasNext() throws BackingStoreException {
                while (this.next == null) {
                    if (this.index >= this.keys.length) {
                        return false;
                    }
                    this.next = IdentifiedObjectSet.this.get(this.keys[this.index++]);
                }
                return true;
            }

            @Override
            public T next() throws NoSuchElementException {
                this.canRemove = this.hasNext();
                if (this.canRemove) {
                    Object t = this.next;
                    this.next = null;
                    return t;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException();
                }
                IdentifiedObjectSet.this.removeAuthorityCode(this.keys[this.index - 1]);
                this.canRemove = false;
            }
        };
    }

    public void resolve(int n) throws FactoryException {
        if (n > 0) {
            try {
                Iterator<T> iterator = this.iterator();
                while (iterator.hasNext() && --n != 0) {
                    iterator.next();
                }
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(FactoryException.class);
            }
        }
    }

    protected String getAuthorityCode(T t) {
        Identifier identifier = IdentifiedObjects.getIdentifier(t, this.factory.getAuthority());
        return identifier != null ? identifier.getCode() : IdentifiedObjects.getIdentifierOrName(t);
    }

    protected T createObject(String string) throws FactoryException {
        return (T)((IdentifiedObject)this.type.cast(this.proxy.createFromAPI(this.factory, string)));
    }

    protected boolean isRecoverableFailure(FactoryException factoryException) {
        if (factoryException instanceof NoSuchIdentifierException) {
            return !(factoryException instanceof NoSuchAuthorityCodeException);
        }
        return factoryException instanceof MissingFactoryResourceException;
    }

    private static String getCause(Throwable throwable) {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder(180);
        while (throwable != null) {
            stringBuilder.append(string).append("  \u2022 ").append(Classes.getShortClassName(throwable));
            String string2 = throwable.getMessage();
            if (string2 != null) {
                stringBuilder.append(": ").append(string2);
            }
            throwable = throwable.getCause();
        }
        return stringBuilder.toString();
    }
}

