/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class UnitEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public UnitEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (null == value) {
            return null;
        }
        if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            double[][] data = matrix.getData();
            double[][] unitData = new double[data.length][];
            for (int i = 0; i < data.length; ++i) {
                double[] row = data[i];
                ArrayRealVector vector = new ArrayRealVector(row);
                double[] unitRow = vector.unitVector().toArray();
                unitData[i] = unitRow;
            }
            Matrix m = new Matrix(unitData);
            m.setRowLabels(matrix.getRowLabels());
            m.setColumnLabels(matrix.getColumnLabels());
            return m;
        }
        if (value instanceof List) {
            double[] unitArray;
            List values = (List)value;
            double[] doubles = new double[values.size()];
            for (int i = 0; i < doubles.length; ++i) {
                doubles[i] = ((Number)values.get(i)).doubleValue();
            }
            ArrayRealVector vector = new ArrayRealVector(doubles);
            RealVector unitVector = vector.unitVector();
            ArrayList<Double> unitList = new ArrayList<Double>(doubles.length);
            for (double d : unitArray = unitVector.toArray()) {
                unitList.add(d);
            }
            return unitList;
        }
        throw new IOException("The unit function expects either a numeric array or matrix as a parameter");
    }
}

