/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.ArrayList;
import java.util.Date;
import javax.measure.Unit;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

public final class Extents
extends Static {
    public static final Extent WORLD;

    private Extents() {
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        GeographicBoundingBox geographicBoundingBox = null;
        if (extent != null) {
            GeographicBoundingBox geographicBoundingBox2;
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
            ArrayList arrayList = new ArrayList();
            for (GeographicExtent object : extent.getGeographicElements()) {
                if (!(object instanceof GeographicBoundingBox)) continue;
                geographicBoundingBox2 = (GeographicBoundingBox)object;
                if (geographicBoundingBox == null) {
                    if (!DefaultGeographicBoundingBox.getInclusion(geographicBoundingBox2.getInclusion())) continue;
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (defaultGeographicBoundingBox == null) {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
                    geographicBoundingBox = defaultGeographicBoundingBox;
                }
                defaultGeographicBoundingBox.add(geographicBoundingBox2);
            }
            if (geographicBoundingBox == null) {
                try {
                    for (Envelope envelope : arrayList) {
                        geographicBoundingBox2 = new DefaultGeographicBoundingBox();
                        ((DefaultGeographicBoundingBox)geographicBoundingBox2).setBounds(envelope);
                        if (geographicBoundingBox == null) {
                            geographicBoundingBox = geographicBoundingBox2;
                            continue;
                        }
                        if (defaultGeographicBoundingBox == null) {
                            defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
                            geographicBoundingBox = defaultGeographicBoundingBox;
                        }
                        defaultGeographicBoundingBox.add(geographicBoundingBox2);
                    }
                }
                catch (TransformException transformException) {
                    throw new InvalidMetadataException(Errors.format((short)16), transformException);
                }
            }
        }
        return geographicBoundingBox;
    }

    public static MeasurementRange<Double> getVerticalRange(Extent extent) {
        MeasurementRange measurementRange = null;
        VerticalDatumType verticalDatumType = null;
        if (extent != null) {
            for (VerticalExtent verticalExtent : extent.getVerticalElements()) {
                Object object;
                double d = verticalExtent.getMinimumValue();
                double d2 = verticalExtent.getMaximumValue();
                VerticalCRS verticalCRS = verticalExtent.getVerticalCRS();
                VerticalDatumType verticalDatumType2 = null;
                Unit<?> unit = null;
                if (verticalCRS != null) {
                    object = verticalCRS.getDatum();
                    if (object != null && VerticalDatumType.DEPTH.equals(verticalDatumType2 = object.getVerticalDatumType())) {
                        verticalDatumType2 = VerticalDatumType.GEOIDAL;
                    }
                    CoordinateSystemAxis coordinateSystemAxis = verticalCRS.getCoordinateSystem().getAxis(0);
                    unit = coordinateSystemAxis.getUnit();
                    if (AxisDirection.DOWN.equals(coordinateSystemAxis.getDirection())) {
                        double d3 = d;
                        d = -d2;
                        d2 = -d3;
                    }
                }
                if (measurementRange != null) {
                    if (verticalDatumType2 == null || unit == null) continue;
                    if (!verticalDatumType2.equals(verticalDatumType)) {
                        if (!verticalDatumType2.equals(VerticalDatumType.GEOIDAL)) {
                            continue;
                        }
                    } else if (verticalDatumType != null && (object = measurementRange.unit()) != null) {
                        if (!object.isCompatible(unit)) continue;
                        measurementRange = (MeasurementRange)measurementRange.union(MeasurementRange.create(d, true, d2, true, unit));
                        continue;
                    }
                }
                measurementRange = MeasurementRange.create(d, true, d2, true, unit);
                verticalDatumType = verticalDatumType2;
            }
        }
        return measurementRange;
    }

    public static Range<Date> getTimeRange(Extent extent) {
        Date date = null;
        Date date2 = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : extent.getTemporalElements()) {
                Date date3;
                Date date4;
                Object object;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    object = (DefaultTemporalExtent)temporalExtent;
                    date4 = ((DefaultTemporalExtent)object).getStartTime();
                    date3 = ((DefaultTemporalExtent)object).getEndTime();
                } else {
                    object = temporalExtent.getExtent();
                    date4 = DefaultTemporalExtent.getTime((TemporalPrimitive)object, true);
                    date3 = DefaultTemporalExtent.getTime((TemporalPrimitive)object, false);
                }
                if (date4 != null && (date == null || date4.before(date))) {
                    date = date4;
                }
                if (date3 == null || date2 != null && !date3.after(date2)) continue;
                date2 = date3;
            }
        }
        if (date == null && date2 == null) {
            return null;
        }
        return new Range<Object>((Class<Object>)Date.class, date, true, date2, true);
    }

    public static Date getDate(Extent extent, double d) {
        ArgumentChecks.ensureFinite("location", d);
        Date date = null;
        Date date2 = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : extent.getTemporalElements()) {
                Object object;
                Date date3 = null;
                Date date4 = null;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    object = (DefaultTemporalExtent)temporalExtent;
                    if (d != 1.0) {
                        date3 = ((DefaultTemporalExtent)object).getStartTime();
                    }
                    if (d != 0.0) {
                        date4 = ((DefaultTemporalExtent)object).getEndTime();
                    }
                } else {
                    object = temporalExtent.getExtent();
                    if (d != 1.0) {
                        date3 = DefaultTemporalExtent.getTime((TemporalPrimitive)object, true);
                    }
                    if (d != 0.0) {
                        date4 = DefaultTemporalExtent.getTime((TemporalPrimitive)object, false);
                    }
                }
                if (date3 != null && (date == null || date3.before(date))) {
                    date = date3;
                }
                if (date4 == null || date2 != null && !date4.after(date2)) continue;
                date2 = date4;
            }
        }
        if (date == null) {
            return date2;
        }
        if (date2 == null) {
            return date;
        }
        long l = date.getTime();
        return new Date(l + Math.round((double)(date2.getTime() - l) * d));
    }

    public static DirectPosition centroid(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox != null) {
            double d = (geographicBoundingBox.getNorthBoundLatitude() + geographicBoundingBox.getSouthBoundLatitude()) / 2.0;
            double d2 = geographicBoundingBox.getWestBoundLongitude();
            double d3 = geographicBoundingBox.getEastBoundLongitude();
            if (d3 < d2) {
                d3 += 360.0;
            }
            if (JDK8.isFinite(d2 = Longitude.normalize((d2 + d3) / 2.0)) || JDK8.isFinite(d)) {
                return ReferencingServices.getInstance().geographic(d2, d);
            }
        }
        return null;
    }

    public static double area(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox == null) {
            return Double.NaN;
        }
        double d = geographicBoundingBox.getEastBoundLongitude() - geographicBoundingBox.getWestBoundLongitude();
        if (d > 360.0) {
            d = 360.0;
        } else if (d < 0.0) {
            d = d < -360.0 ? -360.0 : (d += 360.0);
        }
        return 4.0589730194049E13 * Math.toRadians(d) * Math.max(0.0, Math.sin(Math.toRadians(geographicBoundingBox.getNorthBoundLatitude())) - Math.sin(Math.toRadians(geographicBoundingBox.getSouthBoundLatitude())));
    }

    public static GeographicBoundingBox intersection(GeographicBoundingBox geographicBoundingBox, GeographicBoundingBox geographicBoundingBox2) {
        if (geographicBoundingBox == null) {
            return geographicBoundingBox2;
        }
        if (geographicBoundingBox2 == null || geographicBoundingBox2 == geographicBoundingBox) {
            return geographicBoundingBox;
        }
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
        defaultGeographicBoundingBox.intersect(geographicBoundingBox2);
        if (defaultGeographicBoundingBox.equals(geographicBoundingBox, ComparisonMode.BY_CONTRACT)) {
            return geographicBoundingBox;
        }
        if (defaultGeographicBoundingBox.equals(geographicBoundingBox2, ComparisonMode.BY_CONTRACT)) {
            return geographicBoundingBox2;
        }
        return defaultGeographicBoundingBox;
    }

    static GeographicExtent intersection(GeographicExtent geographicExtent, GeographicExtent geographicExtent2) {
        return Extents.intersection(geographicExtent instanceof GeographicBoundingBox ? (GeographicBoundingBox)geographicExtent : null, geographicExtent2 instanceof GeographicBoundingBox ? (GeographicBoundingBox)geographicExtent2 : null);
    }

    public static VerticalExtent intersection(VerticalExtent verticalExtent, VerticalExtent verticalExtent2) {
        if (verticalExtent == null) {
            return verticalExtent2;
        }
        if (verticalExtent2 == null || verticalExtent2 == verticalExtent) {
            return verticalExtent;
        }
        DefaultVerticalExtent defaultVerticalExtent = new DefaultVerticalExtent(verticalExtent);
        defaultVerticalExtent.intersect(verticalExtent2);
        if (defaultVerticalExtent.equals(verticalExtent, ComparisonMode.BY_CONTRACT)) {
            return verticalExtent;
        }
        if (defaultVerticalExtent.equals(verticalExtent2, ComparisonMode.BY_CONTRACT)) {
            return verticalExtent2;
        }
        return defaultVerticalExtent;
    }

    public static TemporalExtent intersection(TemporalExtent temporalExtent, TemporalExtent temporalExtent2) {
        if (temporalExtent == null) {
            return temporalExtent2;
        }
        if (temporalExtent2 == null || temporalExtent2 == temporalExtent) {
            return temporalExtent;
        }
        DefaultTemporalExtent defaultTemporalExtent = new DefaultTemporalExtent(temporalExtent);
        defaultTemporalExtent.intersect(temporalExtent2);
        if (defaultTemporalExtent.equals(temporalExtent, ComparisonMode.BY_CONTRACT)) {
            return temporalExtent;
        }
        if (defaultTemporalExtent.equals(temporalExtent2, ComparisonMode.BY_CONTRACT)) {
            return temporalExtent2;
        }
        return defaultTemporalExtent;
    }

    public static Extent intersection(Extent extent, Extent extent2) {
        if (extent == null) {
            return extent2;
        }
        if (extent2 == null || extent2 == extent) {
            return extent;
        }
        DefaultExtent defaultExtent = new DefaultExtent(extent);
        defaultExtent.intersect(extent2);
        if (defaultExtent.equals(extent, ComparisonMode.BY_CONTRACT)) {
            return extent;
        }
        if (defaultExtent.equals(extent2, ComparisonMode.BY_CONTRACT)) {
            return extent2;
        }
        return defaultExtent;
    }

    static {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        defaultGeographicBoundingBox.freeze();
        DefaultExtent defaultExtent = new DefaultExtent(Vocabulary.formatInternational((short)118), defaultGeographicBoundingBox, null, null);
        defaultExtent.freeze();
        WORLD = defaultExtent;
    }
}

