/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.resources.Errors;

public class MetadataCopier {
    private final MetadataStandard standard;
    final Map<Object, Object> copies;

    public MetadataCopier(MetadataStandard metadataStandard) {
        this.standard = metadataStandard;
        this.copies = new IdentityHashMap<Object, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copy(Object object) {
        try {
            Object object2 = this.copyRecursively(null, object);
            return object2;
        }
        finally {
            this.copies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(Class<T> clazz, T t) {
        ArgumentChecks.ensureNonNull("type", clazz);
        try {
            T t2 = clazz.cast(this.copyRecursively(clazz, t));
            return t2;
        }
        finally {
            this.copies.clear();
        }
    }

    protected Object copyRecursively(Class<?> clazz, Object object) {
        if (object != null) {
            PropertyAccessor propertyAccessor;
            MetadataStandard metadataStandard = this.standard;
            if (object instanceof AbstractMetadata) {
                metadataStandard = ((AbstractMetadata)object).getStandard();
            }
            if (metadataStandard != null && (propertyAccessor = metadataStandard.getAccessor(new CacheKey(object.getClass(), clazz), false)) != null) {
                try {
                    return propertyAccessor.copy(object, this);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new UnsupportedOperationException(Errors.format((short)169, propertyAccessor.type), exception);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    final Object copyAny(Class<?> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            if (object instanceof Collection) {
                SequencedCollection<Object> sequencedCollection = (List<Object>)object;
                if (sequencedCollection.isEmpty()) {
                    return null;
                }
                if (!(sequencedCollection instanceof EnumSet) && !(sequencedCollection instanceof CodeListSet)) {
                    void entry;
                    Object[] objectArray = sequencedCollection.toArray();
                    boolean i = false;
                    while (entry < objectArray.length) {
                        objectArray[entry] = this.copyRecursively(clazz, objectArray[entry]);
                        ++entry;
                    }
                    sequencedCollection = Arrays.asList(objectArray);
                    if (object instanceof Set) {
                        sequencedCollection = new LinkedHashSet<Object>(sequencedCollection);
                    }
                }
                return sequencedCollection;
            }
            if (object instanceof Map) {
                LinkedHashMap linkedHashMap = new LinkedHashMap((Map)object);
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    entry.setValue(this.copyRecursively(clazz, entry.getValue()));
                }
                return linkedHashMap;
            }
        }
        return this.copyRecursively(clazz, object);
    }
}

