/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultReliabilityStrategy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="logger", category="Core", printObject=true)
public class LoggerConfig
extends AbstractFilterable {
    public static final String ROOT = "root";
    private static final long serialVersionUID = 1L;
    private static LogEventFactory LOG_EVENT_FACTORY = null;
    private List<AppenderRef> appenderRefs = new ArrayList<AppenderRef>();
    private final Set<AppenderControl> appenders = new CopyOnWriteArraySet<AppenderControl>();
    private final String name;
    private LogEventFactory logEventFactory = LOG_EVENT_FACTORY;
    private Level level;
    private boolean additive = true;
    private boolean includeLocation = true;
    private LoggerConfig parent;
    private final Map<Property, Boolean> properties;
    private final Configuration config;
    private final ReliabilityStrategy reliabilityStrategy;

    public LoggerConfig() {
        this.level = Level.ERROR;
        this.name = "";
        this.properties = null;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    public LoggerConfig(String name, Level level, boolean additive) {
        this.name = name;
        this.level = level;
        this.additive = additive;
        this.properties = null;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    protected LoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super(filter);
        this.name = name;
        this.appenderRefs = appenders;
        this.level = level;
        this.additive = additive;
        this.includeLocation = includeLocation;
        this.config = config;
        if (properties != null && properties.length > 0) {
            this.properties = new HashMap<Property, Boolean>(properties.length);
            for (Property prop : properties) {
                boolean interpolate = prop.getValue().contains("${");
                this.properties.put(prop, interpolate);
            }
        } else {
            this.properties = null;
        }
        this.reliabilityStrategy = config.getConfigurationMonitor().getReliabilityStrategy(this);
    }

    @Override
    public Filter getFilter() {
        return super.getFilter();
    }

    public String getName() {
        return this.name;
    }

    public void setParent(LoggerConfig parent) {
        this.parent = parent;
    }

    public LoggerConfig getParent() {
        return this.parent;
    }

    public void addAppender(Appender appender, Level level, Filter filter) {
        this.appenders.add(new AppenderControl(appender, level, filter));
    }

    public void removeAppender(String name) {
        for (AppenderControl appenderControl : this.appenders) {
            if (!Objects.equals(name, appenderControl.getAppenderName()) || !this.appenders.remove(appenderControl)) continue;
            this.cleanupFilter(appenderControl);
        }
    }

    public Map<String, Appender> getAppenders() {
        HashMap<String, Appender> map = new HashMap<String, Appender>();
        for (AppenderControl appenderControl : this.appenders) {
            map.put(appenderControl.getAppenderName(), appenderControl.getAppender());
        }
        return map;
    }

    protected void clearAppenders() {
        ArrayList<AppenderControl> copy = new ArrayList<AppenderControl>(this.appenders);
        while (!copy.isEmpty()) {
            this.appenders.removeAll(copy);
            for (AppenderControl ctl : copy) {
                this.cleanupFilter(ctl);
            }
            copy = new ArrayList<AppenderControl>(this.appenders);
        }
    }

    private void cleanupFilter(AppenderControl ctl) {
        Filter filter = ctl.getFilter();
        if (filter != null) {
            ctl.removeFilter(filter);
            filter.stop();
        }
    }

    public List<AppenderRef> getAppenderRefs() {
        return this.appenderRefs;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level == null ? this.parent.getLevel() : this.level;
    }

    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }

    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.logEventFactory = logEventFactory;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public Map<Property, Boolean> getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public void log(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        ArrayList<Property> props = null;
        if (this.properties != null) {
            props = new ArrayList<Property>(this.properties.size());
            Log4jLogEvent.Builder builder = new Log4jLogEvent.Builder();
            builder.setMessage(data).setMarker(marker).setLevel(level).setLoggerName(loggerName);
            builder.setLoggerFqcn(fqcn).setThrown(t);
            Log4jLogEvent event = builder.build();
            for (Map.Entry<Property, Boolean> entry : this.properties.entrySet()) {
                Property prop = entry.getKey();
                String value = entry.getValue() != false ? this.config.getStrSubstitutor().replace((LogEvent)event, prop.getValue()) : prop.getValue();
                props.add(Property.createProperty(prop.getName(), value));
            }
        }
        this.log(this.logEventFactory.createEvent(loggerName, marker, fqcn, level, data, props, t));
    }

    public void log(LogEvent event) {
        if (!this.isFiltered(event)) {
            this.processLogEvent(event);
        }
    }

    public ReliabilityStrategy getReliabilityStrategy() {
        return this.reliabilityStrategy;
    }

    private void processLogEvent(LogEvent event) {
        event.setIncludeLocation(this.isIncludeLocation());
        this.callAppenders(event);
        this.logParent(event);
    }

    private void logParent(LogEvent event) {
        if (this.additive && this.parent != null) {
            this.parent.log(event);
        }
    }

    protected void callAppenders(LogEvent event) {
        for (AppenderControl control : this.appenders) {
            control.callAppender(event);
        }
    }

    public String toString() {
        return Strings.isEmpty((CharSequence)this.name) ? ROOT : this.name;
    }

    @PluginFactory
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String additivity, @PluginAttribute(value="level") Level level, @PluginAttribute(value="name") String loggerName, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
        if (loggerName == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> appenderRefs = Arrays.asList(refs);
        String name = loggerName.equals(ROOT) ? "" : loggerName;
        boolean additive = Booleans.parseBoolean(additivity, true);
        return new LoggerConfig(name, appenderRefs, filter, level, additive, properties, config, LoggerConfig.includeLocation(includeLocation));
    }

    protected static boolean includeLocation(String includeLocationConfigValue) {
        if (includeLocationConfigValue == null) {
            boolean sync = !AsyncLoggerContextSelector.class.getName().equals(PropertiesUtil.getProperties().getStringProperty("Log4jContextSelector"));
            return sync;
        }
        return Boolean.parseBoolean(includeLocationConfigValue);
    }

    static {
        String factory = PropertiesUtil.getProperties().getStringProperty("Log4jLogEventFactory");
        if (factory != null) {
            try {
                Class<?> clazz = Loader.loadClass(factory);
                if (clazz != null && LogEventFactory.class.isAssignableFrom(clazz)) {
                    LOG_EVENT_FACTORY = (LogEventFactory)clazz.newInstance();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create LogEventFactory {}", new Object[]{factory, ex});
            }
        }
        if (LOG_EVENT_FACTORY == null) {
            LOG_EVENT_FACTORY = new DefaultLogEventFactory();
        }
    }

    @Plugin(name="root", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        private static final long serialVersionUID = 1L;

        @PluginFactory
        public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String additivity, @PluginAttribute(value="level") Level level, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            Level actualLevel = level == null ? Level.ERROR : level;
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new LoggerConfig("", appenderRefs, filter, actualLevel, additive, properties, config, RootLogger.includeLocation(includeLocation));
        }
    }
}

