/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.extractors;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.annotations.LinkHeaderParam;
import org.jboss.resteasy.annotations.Status;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.util.IsHttpMethod;

public class ResponseObjectEntityExtractorFactory
extends DefaultEntityExtractorFactory {
    @Override
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (method.isAnnotationPresent(Status.class)) {
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return new EntityExtractor<Integer>(){

                    @Override
                    public Integer extractEntity(ClientContext context, Object ... args) {
                        return context.getClientResponse().getStatus();
                    }
                };
            }
            if (returnType == Response.Status.class) {
                return ResponseObjectEntityExtractorFactory.createStatusExtractor(false);
            }
        }
        if (method.isAnnotationPresent(Body.class)) {
            return new BodyEntityExtractor(method);
        }
        final HeaderParam headerParam = method.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            return new EntityExtractor(){

                public Object extractEntity(ClientContext context, Object ... args) {
                    return context.getClientResponse().getHeaderString(headerParam.value());
                }
            };
        }
        LinkHeaderParam link = method.getAnnotation(LinkHeaderParam.class);
        if (link != null) {
            return this.processLinkHeader(method, returnType, link);
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return clientResponseExtractor;
        }
        return null;
    }

    private EntityExtractor processLinkHeader(final Method method, Class<?> returnType, final LinkHeaderParam link) {
        if ("".equals(link.rel()) && "".equals(link.title())) {
            throw new RuntimeException(Messages.MESSAGES.mustSetLinkHeaderParam(method.getClass().getName(), method.getName()));
        }
        if (!"".equals(link.rel()) && !"".equals(link.title())) {
            throw new RuntimeException(Messages.MESSAGES.canOnlySetOneLinkHeaderParam(method.getClass().getName(), method.getName()));
        }
        if (returnType == Link.class) {
            return new EntityExtractor(){

                public Object extractEntity(ClientContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getLink(link, context);
                }
            };
        }
        if (ResponseObjectEntityExtractorFactory.isInvokerMethod(method)) {
            return new EntityExtractor(){

                public Object extractEntity(ClientContext context, Object ... args) {
                    URI uri = ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                    if (uri == null) {
                        return null;
                    }
                    return new ClientInvoker(context.getInvocation().getClient().target(uri), method.getDeclaringClass(), method, new ProxyConfig(Thread.currentThread().getContextClassLoader(), null, null)).invoke(args);
                }
            };
        }
        if (returnType == String.class) {
            return new EntityExtractor<String>(){

                @Override
                public String extractEntity(ClientContext context, Object ... args) {
                    Link link2 = ResponseObjectEntityExtractorFactory.this.getLink(link, context);
                    return link2 == null ? null : link2.getUri().toString();
                }
            };
        }
        if (returnType == URL.class) {
            return new EntityExtractor<URL>(){

                @Override
                public URL extractEntity(ClientContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getURL(method, link, context);
                }
            };
        }
        if (returnType == URI.class) {
            return new EntityExtractor<URI>(){

                @Override
                public URI extractEntity(ClientContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                }
            };
        }
        if (returnType.equals(Invocation.Builder.class)) {
            return new EntityExtractor<Invocation.Builder>(){

                @Override
                public Invocation.Builder extractEntity(ClientContext context, Object ... args) {
                    return context.getInvocation().getClient().target(ResponseObjectEntityExtractorFactory.this.getLink(link, context)).request();
                }
            };
        }
        if (returnType.equals(WebTarget.class)) {
            return new EntityExtractor<WebTarget>(){

                @Override
                public WebTarget extractEntity(ClientContext context, Object ... args) {
                    return context.getInvocation().getClient().target(ResponseObjectEntityExtractorFactory.this.getLink(link, context));
                }
            };
        }
        return null;
    }

    private static boolean isInvokerMethod(Method method) {
        Set httpMethods = IsHttpMethod.getHttpMethods((Method)method);
        return httpMethods != null && httpMethods.size() == 1;
    }

    private Link getLink(LinkHeaderParam link, ClientContext context) {
        return context.getClientResponse().getLink(link.rel());
    }

    private URI getURI(Method method, Link link) {
        if (link == null) {
            return null;
        }
        return link.getUri();
    }

    private URI getURI(Method method, LinkHeaderParam link, ClientContext context) {
        return this.getURI(method, this.getLink(link, context));
    }

    private URL getURL(Method method, LinkHeaderParam link, ClientContext context) {
        URI uri = this.getURI(method, link, context);
        try {
            return uri == null ? null : uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(Messages.MESSAGES.couldNotCreateURL(uri.toASCIIString(), method.getClass().getName(), method.getName()), e);
        }
    }
}

