/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.referencing.provider.Mercator2SP;
import org.apache.sis.internal.referencing.provider.RegionalMercator;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Mercator
extends ConformalProjection {
    private static final long serialVersionUID = 2564172914329253286L;
    private static final byte SPHERICAL = 1;
    private static final byte PSEUDO = 3;
    private static final byte REGIONAL = 2;
    private static final byte MILLER = 4;
    private final byte variant;

    private static byte getVariant(OperationMethod operationMethod) {
        if (Mercator.identMatch(operationMethod, "(?i).*\\bvariant\\s*C\\b.*", "1044")) {
            return 2;
        }
        if (Mercator.identMatch(operationMethod, "(?i).*\\bSpherical\\b.*", "1026")) {
            return 1;
        }
        if (Mercator.identMatch(operationMethod, "(?i).*\\bPseudo.*", "1024")) {
            return 3;
        }
        if (Mercator.identMatch(operationMethod, "(?i).*\\bMiller.*", null)) {
            return 4;
        }
        return 0;
    }

    public Mercator(OperationMethod operationMethod, Parameters parameters) {
        this(Mercator.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        byte by = Mercator.getVariant(operationMethod);
        EnumMap<NormalizedProjection.ParameterRole, Object> enumMap = new EnumMap<NormalizedProjection.ParameterRole, Object>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, Mercator1SP.SCALE_FACTOR);
        switch (by) {
            case 2: {
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, RegionalMercator.EASTING_AT_FALSE_ORIGIN);
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, RegionalMercator.NORTHING_AT_FALSE_ORIGIN);
                break;
            }
            case 1: {
                enumMap.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, Mercator1SP.LATITUDE_OF_ORIGIN);
            }
            default: {
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, Mercator1SP.FALSE_EASTING);
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, Mercator1SP.FALSE_NORTHING);
            }
        }
        return new Initializer(operationMethod, parameters, enumMap, by);
    }

    private Mercator(Initializer initializer) {
        super(initializer);
        DoubleDouble doubleDouble;
        super.computeCoefficients();
        this.variant = initializer.variant;
        double d = initializer.getAndStore(Mercator1SP.LONGITUDE_OF_ORIGIN);
        double d2 = Math.toRadians(initializer.getAndStore(this.variant == 2 ? RegionalMercator.LATITUDE_OF_FALSE_ORIGIN : Mercator1SP.LATITUDE_OF_ORIGIN));
        double d3 = Math.toRadians(initializer.getAndStore(Mercator2SP.STANDARD_PARALLEL));
        DoubleDouble doubleDouble2 = DoubleDouble.verbatim(initializer.scaleAt\u03c6(Math.sin(d3), Math.cos(d3)));
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS2.convertBefore(0, doubleDouble2, null);
        matrixSIS2.convertBefore(1, doubleDouble2, null);
        if (d != 0.0) {
            doubleDouble = DoubleDouble.createDegreesToRadians();
            doubleDouble.multiply(-d);
            matrixSIS2.convertBefore(0, null, doubleDouble);
        }
        if (d2 != 0.0) {
            matrixSIS2.convertBefore(1, null, DoubleDouble.verbatim(-Math.log(this.expOfNorthing(d2, this.eccentricity * Math.sin(d2)))));
        }
        if (this.variant == 4) {
            matrixSIS.convertBefore(1, 0.8, null);
            matrixSIS2.convertBefore(1, 1.25, null);
        }
        if (d2 == 0.0 && MathFunctions.isPositive(d3 != 0.0 ? d3 : d2)) {
            doubleDouble = DoubleDouble.verbatim(-1.0);
            matrixSIS.convertBefore(1, doubleDouble, null);
            matrixSIS2.convertBefore(1, doubleDouble, null);
        }
    }

    Mercator(Mercator mercator) {
        super(mercator);
        this.variant = mercator.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        Mercator mercator = this;
        if ((this.variant & 1) != 0 || this.eccentricity == 0.0) {
            mercator = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, mercator);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n + 1];
        double d2 = Math.sin(d);
        if (dArray2 != null) {
            double d3;
            double d4 = d == 0.0 ? d : ((d3 = Math.abs(d)) < 1.5707963267948966 ? Math.log(this.expOfNorthing(d, this.eccentricity * d2)) : (d3 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN));
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = d4;
        }
        return bl ? new Matrix2(1.0, 0.0, 0.0, this.dy_d\u03c6(d2, Math.cos(d))) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2 || this.getClass() != Mercator.class) {
            super.transform(dArray, n, dArray2, n2, n3);
        } else {
            --n2;
            while (--n3 >= 0) {
                double d = dArray2[n2 += 2];
                if (d == 0.0) continue;
                double d2 = Math.abs(d);
                double d3 = d2 < 1.5707963267948966 ? Math.log(this.expOfNorthing(d, this.eccentricity * Math.sin(d))) : (d2 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN);
                dArray2[n2] = d3;
            }
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = dArray[n];
        dArray2[n2 + 1] = this.\u03c6(Math.exp(-d));
    }

    @Override
    final MathTransform tryConcatenate(boolean bl, Matrix matrix, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (matrix.getElement(1, 0) == 0.0 && matrix.getElement(1, 2) == 0.0 && Math.abs(matrix.getElement(1, 1)) == 1.0) {
            if (mathTransformFactory != null) {
                return mathTransformFactory.createAffineTransform(matrix);
            }
            return MathTransforms.linear(matrix);
        }
        return super.tryConcatenate(bl, matrix, mathTransformFactory);
    }

    static final class Spherical
    extends Mercator {
        private static final long serialVersionUID = 2383414176395616561L;

        Spherical(Mercator mercator) {
            super(mercator);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = dArray[n + 1];
            if (dArray2 != null) {
                double d2;
                double d3 = d == 0.0 ? d : ((d2 = Math.abs(d)) < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d)) : (d2 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN));
                dArray2[n2] = dArray[n];
                dArray2[n2 + 1] = d3;
            }
            return bl ? new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.cos(d)) : null;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray != dArray2 || n != n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                --n2;
                while (--n3 >= 0) {
                    double d = dArray2[n2 += 2];
                    if (d == 0.0) continue;
                    double d2 = Math.abs(d);
                    double d3 = d2 < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d)) : (d2 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN);
                    dArray2[n2] = d3;
                }
            }
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n + 1];
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-d));
        }
    }
}

