/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.TransformationAccuracy;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.referencing.DeferredCoordinateOperation;
import org.apache.sis.internal.referencing.DeprecatedCode;
import org.apache.sis.internal.referencing.EPSGParameterDomain;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.SignReversalComment;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.AxisName;
import org.apache.sis.referencing.factory.sql.BursaWolfInfo;
import org.apache.sis.referencing.factory.sql.CloseableReference;
import org.apache.sis.referencing.factory.sql.CoordinateOperationSet;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.referencing.factory.sql.SQLTranslator;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;

public class EPSGDataAccess
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
Localized,
AutoCloseable {
    private static final Map<Integer, Integer> DEPRECATED_CS = EPSGDataAccess.deprecatedCS();
    private final NameSpace namespace;
    private String lastTableForName;
    private Calendar calendar;
    private DateFormat dateFormat;
    private final Map<String, PreparedStatement> statements = new HashMap<String, PreparedStatement>();
    private final Map<Class<?>, CloseableReference<AuthorityCodes>> authorityCodes = new HashMap();
    private final Map<Integer, AxisName> axisNames = new HashMap<Integer, AxisName>();
    private final Map<Integer, Integer> csDimensions = new HashMap<Integer, Integer>();
    private final Map<Integer, Boolean> isProjection = new HashMap<Integer, Boolean>();
    private final Map<String, NameSpace> namingSystems = new HashMap<String, NameSpace>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<Integer, Class<?>> safetyGuard = new HashMap();
    private transient boolean quiet;
    private transient boolean replaceDeprecatedCS;
    protected final EPSGFactory owner;
    protected final Connection connection;
    protected final SQLTranslator translator;

    static Map<Integer, Integer> deprecatedCS() {
        int n;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(24);
        Integer n2 = 6422;
        hashMap.put(6402, n2);
        for (n = 6405; n <= 6412; ++n) {
            hashMap.put(n, n2);
        }
        n2 = 6423;
        hashMap.put(6401, n2);
        for (n = 6413; n <= 6420; ++n) {
            hashMap.put(n, n2);
        }
        return hashMap;
    }

    protected EPSGDataAccess(EPSGFactory ePSGFactory, Connection connection, SQLTranslator sQLTranslator) {
        ArgumentChecks.ensureNonNull("connection", connection);
        ArgumentChecks.ensureNonNull("translator", sQLTranslator);
        this.owner = ePSGFactory;
        this.connection = connection;
        this.translator = sQLTranslator;
        this.namespace = ePSGFactory.nameFactory.createNameSpace((GenericName)ePSGFactory.nameFactory.createLocalName(null, (CharSequence)"IOGP"), null);
    }

    @Override
    public Locale getLocale() {
        return this.owner.getLocale();
    }

    private Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.CANADA);
        }
        this.calendar.clear();
        return this.calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Citation getAuthority() {
        DefaultCitation defaultCitation;
        block39: {
            defaultCitation = new DefaultCitation("EPSG Geodetic Parameter Dataset");
            defaultCitation.setIdentifiers(Collections.singleton(new ImmutableIdentifier(null, null, "EPSG")));
            try {
                java.sql.Date date;
                Throwable throwable;
                Object object;
                String string = this.translator.apply("SELECT VERSION_NUMBER, VERSION_DATE FROM [Version History] ORDER BY VERSION_DATE DESC, VERSION_HISTORY_CODE DESC");
                String string2 = null;
                try (Wrapper wrapper = this.connection.createStatement();){
                    object = wrapper.executeQuery(string);
                    throwable = null;
                    try {
                        while (object.next()) {
                            string2 = EPSGDataAccess.getOptionalString((ResultSet)object, 1);
                            date = object.getDate(2);
                            if (string2 == null || date == null) continue;
                            defaultCitation.setEdition(new SimpleInternationalString(string2));
                            defaultCitation.setEditionDate(date);
                            break;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                wrapper = this.connection.getMetaData();
                int n = 0;
                while (true) {
                    date = null;
                    switch (n) {
                        case 0: {
                            object = "http://epsg-registry.org/";
                            throwable = OnLineFunction.SEARCH;
                            break;
                        }
                        case 1: {
                            object = "http://www.epsg.org/";
                            throwable = OnLineFunction.DOWNLOAD;
                            break;
                        }
                        case 2: {
                            object = SQLUtilities.getSimplifiedURL((DatabaseMetaData)wrapper);
                            throwable = OnLineFunction.valueOf((String)"CONNECTION");
                            date = Resources.formatInternational((short)18, "EPSG", string2, wrapper.getDatabaseProductName(), Version.valueOf(wrapper.getDatabaseMajorVersion(), wrapper.getDatabaseMinorVersion()));
                            break;
                        }
                        default: {
                            break block39;
                        }
                    }
                    DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource();
                    try {
                        defaultOnlineResource.setLinkage(new URI((String)object));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        EPSGDataAccess.unexpectedException("getAuthority", uRISyntaxException);
                    }
                    defaultOnlineResource.setFunction((OnLineFunction)throwable);
                    defaultOnlineResource.setDescription((InternationalString)date);
                    defaultCitation.getOnlineResources().add(defaultOnlineResource);
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                EPSGDataAccess.unexpectedException("getAuthority", sQLException);
            }
            finally {
                defaultCitation.freeze();
            }
        }
        return defaultCitation;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        try {
            return this.getCodeMap(clazz).keySet();
        }
        catch (SQLException sQLException) {
            throw new FactoryException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    private synchronized Map<String, String> getCodeMap(Class<?> clazz) throws SQLException {
        Map<String, String> map;
        CloseableReference<AuthorityCodes> closeableReference = this.authorityCodes.get(clazz);
        if (closeableReference != null && (map = (AuthorityCodes)closeableReference.get()) != null) {
            return map;
        }
        map = Collections.emptyMap();
        for (TableInfo tableInfo : TableInfo.EPSG) {
            if (!tableInfo.type.isAssignableFrom(clazz) && !clazz.isAssignableFrom(tableInfo.type)) continue;
            AuthorityCodes authorityCodes = new AuthorityCodes(this.connection, tableInfo, clazz, this);
            closeableReference = this.authorityCodes.get(authorityCodes.type);
            if (closeableReference != null) {
                AuthorityCodes authorityCodes2 = (AuthorityCodes)closeableReference.get();
                if (authorityCodes2 != null) {
                    authorityCodes = authorityCodes2;
                } else {
                    closeableReference = null;
                }
            }
            if (closeableReference == null) {
                closeableReference = authorityCodes.createReference();
                this.authorityCodes.put(authorityCodes.type, closeableReference);
            }
            if (clazz != authorityCodes.type) {
                this.authorityCodes.put(clazz, closeableReference);
            }
            if (map.isEmpty()) {
                map = authorityCodes;
                continue;
            }
            if (map instanceof AuthorityCodes) {
                map = new LinkedHashMap<String, String>(map);
            }
            map.putAll(authorityCodes);
        }
        return map;
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Collections.emptySet();
    }

    @Override
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        try {
            for (TableInfo tableInfo : TableInfo.EPSG) {
                String string2 = this.getCodeMap(tableInfo.type).get(string);
                if (string2 == null) continue;
                return tableInfo.nameColumn != null ? new SimpleInternationalString(string2) : null;
            }
        }
        catch (SQLException sQLException) {
            throw new FactoryException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
        throw this.noSuchAuthorityCode(IdentifiedObject.class, string);
    }

    private boolean isPrimaryKey(String string) throws FactoryException {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        do {
            char c;
            if ((c = string.charAt(--n)) >= '0' && c <= '9') continue;
            return false;
        } while (n != 0);
        return true;
    }

    private int[] toPrimaryKeys(String string, String string2, String string3, String ... stringArray) throws SQLException, FactoryException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string2 != null && string3 != null && !this.isPrimaryKey(string4)) {
                PreparedStatement preparedStatement = this.statements.get("PrimaryKey");
                if (preparedStatement != null && !string.equals(this.lastTableForName)) {
                    this.statements.remove("PrimaryKey");
                    preparedStatement.close();
                    preparedStatement = null;
                    this.lastTableForName = null;
                }
                if (preparedStatement == null) {
                    preparedStatement = this.connection.prepareStatement(this.translator.apply("SELECT " + string2 + ", " + string3 + " FROM [" + string + "] WHERE " + string3 + " LIKE ?"));
                    this.statements.put("PrimaryKey", preparedStatement);
                    this.lastTableForName = string;
                }
                preparedStatement.setString(1, EPSGDataAccess.toLikePattern(string4));
                Integer n = null;
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        if (!SQLUtilities.filterFalsePositive(string4, resultSet.getString(2))) continue;
                        n = this.ensureSingleton((Object)EPSGDataAccess.getOptionalInteger(resultSet, 1), (Object)n, (Comparable<?>)((Object)string4));
                    }
                }
                if (n != null) {
                    nArray[i] = n;
                    continue;
                }
            }
            try {
                nArray[i] = Integer.parseInt(string4);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw (NoSuchAuthorityCodeException)new NoSuchAuthorityCodeException(this.error().getString((short)53, "EPSG", string4), "EPSG", string4).initCause((Throwable)numberFormatException);
            }
        }
        return nArray;
    }

    private ResultSet executeQuery(String string, String string2, String string3, String string4, String ... stringArray) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        assert (string4.contains('[' + string + ']')) : string;
        assert (string2 == null || string4.contains(string2) || string.equals("Area")) : string2;
        assert (string3 == null || string4.contains(string3) || string.equals("Area")) : string3;
        return this.executeQuery(string, string4, this.toPrimaryKeys(string, string2, string3, stringArray));
    }

    private ResultSet executeQuery(String string, String string2, int ... nArray) throws SQLException {
        assert (Thread.holdsLock(this));
        PreparedStatement preparedStatement = this.statements.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.connection.prepareStatement(this.translator.apply(string2));
            this.statements.put(string, preparedStatement);
        }
        assert (preparedStatement.getParameterMetaData().getParameterCount() == CharSequences.count((CharSequence)string2, '?'));
        for (int i = 0; i < nArray.length; ++i) {
            preparedStatement.setInt(i + 1, nArray[i]);
        }
        return preparedStatement.executeQuery();
    }

    private static String getOptionalString(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        return string != null && !(string = string.trim()).isEmpty() && !resultSet.wasNull() ? string : null;
    }

    private static double getOptionalDouble(ResultSet resultSet, int n) throws SQLException {
        double d = resultSet.getDouble(n);
        return resultSet.wasNull() ? Double.NaN : d;
    }

    private static Integer getOptionalInteger(ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        return resultSet.wasNull() ? null : Integer.valueOf(n2);
    }

    private boolean getOptionalBoolean(ResultSet resultSet, int n) throws SQLException {
        return this.translator.useBoolean() ? resultSet.getBoolean(n) : resultSet.getInt(n) != 0;
    }

    private String nullValue(ResultSet resultSet, int n, Comparable<?> comparable) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = resultSetMetaData.getColumnName(n);
        String string2 = resultSetMetaData.getTableName(n);
        resultSet.close();
        return this.error().getString((short)117, string2, string, comparable);
    }

    private String getString(String string, ResultSet resultSet, int n, int n2) throws SQLException, FactoryDataException {
        String string2 = resultSet.getString(n);
        if (string2 == null || (string2 = string2.trim()).isEmpty() || resultSet.wasNull()) {
            throw new FactoryDataException(this.nullValue(resultSet, n2, (Comparable<?>)((Object)string)));
        }
        return string2;
    }

    private String getString(Comparable<?> comparable, ResultSet resultSet, int n) throws SQLException, FactoryDataException {
        String string = resultSet.getString(n);
        if (string == null || (string = string.trim()).isEmpty() || resultSet.wasNull()) {
            throw new FactoryDataException(this.nullValue(resultSet, n, comparable));
        }
        return string;
    }

    private double getDouble(Comparable<?> comparable, ResultSet resultSet, int n) throws SQLException, FactoryDataException {
        double d = resultSet.getDouble(n);
        if (Double.isNaN(d) || resultSet.wasNull()) {
            throw new FactoryDataException(this.nullValue(resultSet, n, comparable));
        }
        return d;
    }

    private Integer getInteger(Comparable<?> comparable, ResultSet resultSet, int n) throws SQLException, FactoryDataException {
        int n2 = resultSet.getInt(n);
        if (resultSet.wasNull()) {
            throw new FactoryDataException(this.nullValue(resultSet, n, comparable));
        }
        return n2;
    }

    private <T> T ensureSingleton(T t, T t2, Comparable<?> comparable) throws FactoryDataException {
        if (t2 == null) {
            return t;
        }
        if (t2.equals(t)) {
            return t2;
        }
        throw new FactoryDataException(this.error().getString((short)25, comparable));
    }

    private void ensureNoCycle(Class<?> clazz, Integer n) throws FactoryException {
        if (JDK8.putIfAbsent(this.safetyGuard, n, clazz) != null) {
            throw new FactoryException(this.resources().getString((short)62, clazz, n));
        }
    }

    private void endOfRecursivity(Class<?> clazz, Integer n) throws FactoryException {
        if (this.safetyGuard.remove(n) != clazz) {
            throw new FactoryException(String.valueOf(n));
        }
    }

    static boolean tableMatches(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.startsWith("epsg_")) {
            string2 = string2.substring("epsg_".length());
        }
        return CharSequences.isAcronymForWords(string2, string);
    }

    private String getSupersession(String string, Integer n, Locale locale) throws SQLException {
        String string2 = null;
        Object object = null;
        Object object2 = this.executeQuery("Deprecation", "SELECT OBJECT_TABLE_NAME, DEPRECATION_REASON, REPLACED_BY FROM [Deprecation] WHERE OBJECT_CODE = ?", n);
        Object object3 = null;
        try {
            while (object2.next()) {
                if (!EPSGDataAccess.tableMatches(string, object2.getString(1))) continue;
                string2 = EPSGDataAccess.getOptionalString((ResultSet)object2, 2);
                object = EPSGDataAccess.getOptionalInteger((ResultSet)object2, 3);
                break;
            }
        }
        catch (Throwable object4) {
            object3 = object4;
            throw object4;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        object2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    object2.close();
                }
            }
        }
        object = object == null ? '(' + Vocabulary.getResources(locale).getString((short)73).toLowerCase(locale) + ')' : object.toString();
        object2 = "create";
        for (TableInfo tableInfo : TableInfo.EPSG) {
            if (!EPSGDataAccess.tableMatches(tableInfo.table, string)) continue;
            object2 = (String)object2 + tableInfo.type.getSimpleName();
            break;
        }
        if (!this.quiet) {
            object3 = Resources.forLocale(locale).getLogRecord(Level.WARNING, (short)15, "EPSG:" + n, object, string2);
            ((LogRecord)object3).setLoggerName("org.apache.sis.referencing.factory");
            Logging.log(EPSGDataAccess.class, (String)object2, (LogRecord)object3);
        }
        return (String)object;
    }

    private Map<String, Object> createProperties(String string, String string2, Integer n, CharSequence charSequence, boolean bl) throws SQLException, FactoryDataException {
        Object object;
        String string3;
        String string4;
        String string5;
        ArrayList<LocalName> arrayList = new ArrayList<LocalName>();
        Serializable serializable = null;
        try (ResultSet resultSet = this.executeQuery("Alias", "SELECT OBJECT_TABLE_NAME, NAMING_SYSTEM_NAME, ALIAS FROM [Alias] INNER JOIN [Naming System] ON [Alias].NAMING_SYSTEM_CODE = [Naming System].NAMING_SYSTEM_CODE WHERE OBJECT_CODE = ?", n);){
            while (resultSet.next()) {
                if (!EPSGDataAccess.tableMatches(string, resultSet.getString(1))) continue;
                string5 = EPSGDataAccess.getOptionalString(resultSet, 2);
                string4 = this.getString(n, resultSet, 3);
                string3 = null;
                if (string5 != null && (string3 = this.namingSystems.get(string5)) == null) {
                    string3 = this.owner.nameFactory.createNameSpace((GenericName)this.owner.nameFactory.createLocalName(null, (CharSequence)string5), null);
                    this.namingSystems.put(string5, (NameSpace)string3);
                }
                if (CharSequences.toASCII(string4).toString().equals(string2)) {
                    string2 = string4;
                    continue;
                }
                arrayList.add(this.owner.nameFactory.createLocalName((NameSpace)string3, (CharSequence)string4));
            }
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        this.properties.clear();
        resultSet = null;
        serializable = this.getLocale();
        string5 = this.owner.getAuthority();
        string4 = string5.getEdition();
        String string6 = string3 = string4 != null ? string4.toString() : null;
        if (string2 != null) {
            resultSet = this.owner.nameFactory.createGenericName(this.namespace, new CharSequence[]{"EPSG", string2});
            this.properties.put("name", resultSet);
            this.properties.put("code", string2);
            this.properties.put("version", string3);
            this.properties.put("authority", string5);
            this.properties.put("locale", serializable);
            object = new NamedIdentifier(this.properties);
            this.properties.clear();
            this.properties.put("name", object);
        }
        if (!arrayList.isEmpty()) {
            this.properties.put("alias", arrayList.toArray(new GenericName[arrayList.size()]));
        }
        if (n != null) {
            ImmutableIdentifier immutableIdentifier;
            object = n.toString();
            if (bl) {
                String string7 = this.getSupersession(string, n, (Locale)serializable);
                immutableIdentifier = new DeprecatedCode((Citation)string5, "EPSG", (String)object, string3, Character.isDigit(string7.charAt(0)) ? string7 : null, Vocabulary.formatInternational((short)96, (Object)string7));
                this.properties.put("deprecated", Boolean.TRUE);
            } else {
                immutableIdentifier = new ImmutableIdentifier((Citation)string5, "EPSG", (String)object, string3, resultSet != null ? resultSet.toInternationalString() : null);
            }
            this.properties.put("identifiers", immutableIdentifier);
        }
        this.properties.put("remarks", charSequence);
        this.properties.put("locale", serializable);
        this.properties.put("mtFactory", this.owner.mtFactory);
        return this.properties;
    }

    private Map<String, Object> createProperties(String string, String string2, Integer n, String string3, String string4, String string5, boolean bl) throws SQLException, FactoryException {
        if ("?".equals(string4)) {
            string4 = null;
        }
        Map<String, Object> map = this.createProperties(string, string2, n, string5, bl);
        if (string3 != null) {
            map.put("domainOfValidity", this.owner.createExtent(string3));
        }
        map.put("scope", string4);
        return map;
    }

    private static String toLikePattern(String string) {
        return SQLUtilities.toLikePattern(CharSequences.toASCII(string).toString());
    }

    @Override
    public synchronized IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        boolean bl = this.isPrimaryKey(string);
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        int n = stringBuilder.length();
        int n2 = -1;
        try {
            int n3 = bl ? this.toPrimaryKeys(null, null, null, string)[0] : 0;
            for (int i = 0; i < TableInfo.EPSG.length; ++i) {
                String string2;
                TableInfo tableInfo = TableInfo.EPSG[i];
                String string3 = string2 = bl ? tableInfo.codeColumn : tableInfo.nameColumn;
                if (string2 == null) continue;
                stringBuilder.setLength(n);
                stringBuilder.append(tableInfo.codeColumn);
                if (!bl) {
                    stringBuilder.append(", ").append(string2);
                }
                stringBuilder.append(" FROM ").append(tableInfo.table).append(" WHERE ").append(string2).append(bl ? " = ?" : " LIKE ?");
                try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.translator.apply(stringBuilder.toString()));){
                    if (bl) {
                        preparedStatement.setInt(1, n3);
                    } else {
                        preparedStatement.setString(1, EPSGDataAccess.toLikePattern(string));
                    }
                    Integer n4 = null;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            if (!bl && !SQLUtilities.filterFalsePositive(string, resultSet.getString(2))) continue;
                            n4 = this.ensureSingleton((Object)EPSGDataAccess.getOptionalInteger(resultSet, 1), (Object)n4, (Comparable<?>)((Object)string));
                        }
                    }
                    if (n4 == null) continue;
                    if (n2 >= 0) {
                        throw new FactoryDataException(this.error().getString((short)25, string));
                    }
                    n2 = i;
                    continue;
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(IdentifiedObject.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (n2 >= 0) {
            switch (n2) {
                case 0: {
                    return this.createCoordinateReferenceSystem(string);
                }
                case 1: {
                    return this.createCoordinateSystem(string);
                }
                case 2: {
                    return this.createCoordinateSystemAxis(string);
                }
                case 3: {
                    return this.createDatum(string);
                }
                case 4: {
                    return this.createEllipsoid(string);
                }
                case 5: {
                    return this.createPrimeMeridian(string);
                }
                case 6: {
                    return this.createCoordinateOperation(string);
                }
                case 7: {
                    return this.createOperationMethod(string);
                }
                case 8: {
                    return this.createParameterDescriptor(string);
                }
                case 9: {
                    break;
                }
                default: {
                    throw new AssertionError(n2);
                }
            }
        }
        throw this.noSuchAuthorityCode(IdentifiedObject.class, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String var1_1) throws NoSuchAuthorityCodeException, FactoryException {
        block62: {
            block61: {
                ArgumentChecks.ensureNonNull("code", var1_1);
                var2_2 = null;
                try {
                    var3_3 = this.executeQuery("Coordinate Reference System", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, DEPRECATED, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?", new String[]{var1_1});
                    var4_5 = null;
                    ** try [egrp 1[TRYBLOCK] [13, 15 : 36->1521)] { 
lbl7:
                    // 1 sources

                    break block61;
lbl8:
                    // 1 sources

                    catch (Throwable var5_8) {
                        var4_5 = var5_8;
                        throw var5_8;
                    }
                }
                catch (SQLException var3_4) {
                    throw this.databaseFailure(CoordinateReferenceSystem.class, (Comparable<?>)var1_1, var3_4);
                }
            }
            while (var3_3.next()) {
                var5_6 = this.getInteger((Comparable<?>)var1_1, var3_3, 1);
                var6_9 = this.getString((Comparable<?>)var1_1, var3_3, 2);
                var7_10 = EPSGDataAccess.getOptionalString(var3_3, 3);
                var8_11 = EPSGDataAccess.getOptionalString(var3_3, 4);
                var9_12 = EPSGDataAccess.getOptionalString(var3_3, 5);
                var10_13 = this.getOptionalBoolean(var3_3, 6);
                var11_14 = this.getString((Comparable<?>)var1_1, var3_3, 7);
                var12_15 = this.owner.crsFactory;
                var14_17 = var11_14.toLowerCase(Locale.US);
                var15_18 = -1;
                switch (var14_17.hashCode()) {
                    case 393633979: {
                        if (!var14_17.equals("geographic 2d")) break;
                        var15_18 = 0;
                        break;
                    }
                    case 393634010: {
                        if (!var14_17.equals("geographic 3d")) break;
                        var15_18 = 1;
                        break;
                    }
                    case -894831240: {
                        if (!var14_17.equals("projected")) break;
                        var15_18 = 2;
                        break;
                    }
                    case -1984141450: {
                        if (!var14_17.equals("vertical")) break;
                        var15_18 = 3;
                        break;
                    }
                    case 3560141: {
                        if (!var14_17.equals("time")) break;
                        var15_18 = 4;
                        break;
                    }
                    case -1321441502: {
                        if (!var14_17.equals("temporal")) break;
                        var15_18 = 5;
                        break;
                    }
                    case -599340629: {
                        if (!var14_17.equals("compound")) break;
                        var15_18 = 6;
                        break;
                    }
                    case -86658573: {
                        if (!var14_17.equals("geocentric")) break;
                        var15_18 = 7;
                        break;
                    }
                    case 1706610451: {
                        if (!var14_17.equals("engineering")) break;
                        var15_18 = 8;
                        break;
                    }
                    case 458748304: {
                        if (!var14_17.equals("parametric")) break;
                        var15_18 = 9;
                        break;
                    }
                }
                switch (var15_18) {
                    case 0: 
                    case 1: {
                        var16_20 = this.getInteger((Comparable<?>)var1_1, var3_3, 8);
                        if (this.replaceDeprecatedCS) {
                            var16_20 = (Integer)JDK8.getOrDefault(EPSGDataAccess.DEPRECATED_CS, var16_20, var16_20);
                        }
                        var17_21 = this.owner.createEllipsoidalCS(var16_20.toString());
                        var18_22 = EPSGDataAccess.getOptionalString(var3_3, 9);
                        if (var18_22 == null) ** GOTO lbl76
                        var19_23 = this.owner.createGeodeticDatum((String)var18_22);
                        ** GOTO lbl85
lbl76:
                        // 1 sources

                        var20_24 = this.getString(var1_1, var3_3, 10, 9);
                        var3_3.close();
                        this.ensureNoCycle(GeographicCRS.class, var5_6);
                        try {
                            var19_23 = this.owner.createGeographicCRS(var20_24).getDatum();
                        }
                        finally {
                            this.endOfRecursivity(GeographicCRS.class, var5_6);
                        }
lbl85:
                        // 2 sources

                        var13_16 = var12_15.createGeographicCRS(this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13), var19_23, (EllipsoidalCS)var17_21);
                        break;
                    }
                    case 2: {
                        var16_20 = this.getString((Comparable<?>)var1_1, var3_3, 8);
                        var17_21 = this.getString((Comparable<?>)var1_1, var3_3, 10);
                        var18_22 = this.getString((Comparable<?>)var1_1, var3_3, 11);
                        var3_3.close();
                        this.ensureNoCycle(ProjectedCRS.class, var5_6);
                        var19_23 = this.owner.createCartesianCS((String)var16_20);
                        try {
                            var20_24 = (Conversion)this.owner.createCoordinateOperation((String)var18_22);
                        }
                        catch (ClassCastException var21_27) {
                            throw (NoSuchAuthorityCodeException)this.noSuchAuthorityCode(Projection.class, (String)var18_22).initCause((Throwable)var21_27);
                        }
                        if (var10_13) ** GOTO lbl104
                        var21_25 = this.owner.createCoordinateReferenceSystem((String)var17_21);
                        var22_28 = false;
                        ** GOTO lbl115
lbl104:
                        // 1 sources

                        var23_30 = this.quiet;
                        try {
                            this.quiet = true;
                            this.replaceDeprecatedCS = true;
                            var21_25 = this.createCoordinateReferenceSystem((String)var17_21);
                        }
                        finally {
                            this.replaceDeprecatedCS = false;
                            this.quiet = var23_30;
                        }
                        var22_28 = Semaphores.queryAndSet(16) == false;
lbl115:
                        // 2 sources

                        try {
                            var23_29 = this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13);
                            if (var21_25 instanceof GeographicCRS) {
                                var13_16 = var12_15.createProjectedCRS(var23_29, (GeographicCRS)var21_25, (Conversion)var20_24, (CartesianCS)var19_23);
                                break;
                            }
                            var13_16 = var12_15.createDerivedCRS(var23_29, var21_25, (Conversion)var20_24, (CoordinateSystem)var19_23);
                            break;
                        }
                        finally {
                            if (var22_28) {
                                Semaphores.clear(16);
                            }
                        }
                    }
                    finally {
                        this.endOfRecursivity(ProjectedCRS.class, var5_6);
                    }
                    case 3: {
                        var16_20 = this.owner.createVerticalCS(this.getString((Comparable<?>)var1_1, var3_3, 8));
                        var17_21 = this.owner.createVerticalDatum(this.getString((Comparable<?>)var1_1, var3_3, 9));
                        var13_16 = var12_15.createVerticalCRS(this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13), (VerticalDatum)var17_21, (VerticalCS)var16_20);
                        break;
                    }
                    case 4: 
                    case 5: {
                        var16_20 = this.owner.createTimeCS(this.getString((Comparable<?>)var1_1, var3_3, 8));
                        var17_21 = this.owner.createTemporalDatum(this.getString((Comparable<?>)var1_1, var3_3, 9));
                        var13_16 = var12_15.createTemporalCRS(this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13), (TemporalDatum)var17_21, (TimeCS)var16_20);
                        break;
                    }
                    case 6: {
                        var16_20 = this.getString((Comparable<?>)var1_1, var3_3, 12);
                        var17_21 = this.getString((Comparable<?>)var1_1, var3_3, 13);
                        var3_3.close();
                        this.ensureNoCycle(CompoundCRS.class, var5_6);
                        try {
                            var18_22 = this.owner.createCoordinateReferenceSystem((String)var16_20);
                            var19_23 = this.owner.createCoordinateReferenceSystem((String)var17_21);
                        }
                        finally {
                            this.endOfRecursivity(CompoundCRS.class, var5_6);
                        }
                        var13_16 = var12_15.createCompoundCRS(this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13), new CoordinateReferenceSystem[]{var18_22, var19_23});
                        break;
                    }
                    case 7: {
                        var16_20 = this.owner.createCoordinateSystem(this.getString((Comparable<?>)var1_1, var3_3, 8));
                        var17_21 = this.owner.createGeodeticDatum(this.getString((Comparable<?>)var1_1, var3_3, 9));
                        var18_22 = this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13);
                        if (var16_20 instanceof CartesianCS) {
                            var13_16 = var12_15.createGeocentricCRS((Map)var18_22, (GeodeticDatum)var17_21, (CartesianCS)var16_20);
                            break;
                        }
                        if (var16_20 instanceof SphericalCS == false) throw new FactoryDataException(this.error().getString((short)51, var16_20.getName()));
                        var13_16 = var12_15.createGeocentricCRS((Map)var18_22, (GeodeticDatum)var17_21, (SphericalCS)var16_20);
                        break;
                    }
                    case 8: {
                        var16_20 = this.owner.createCoordinateSystem(this.getString((Comparable<?>)var1_1, var3_3, 8));
                        var17_21 = this.owner.createEngineeringDatum(this.getString((Comparable<?>)var1_1, var3_3, 9));
                        var13_16 = var12_15.createEngineeringCRS(this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13), (EngineeringDatum)var17_21, (CoordinateSystem)var16_20);
                        break;
                    }
                    case 9: {
                        var16_20 = this.owner.createParametricCS(this.getString((Comparable<?>)var1_1, var3_3, 8));
                        var17_21 = this.owner.createParametricDatum(this.getString((Comparable<?>)var1_1, var3_3, 9));
                        var13_16 = ReferencingServices.getInstance().createParametricCRS(this.createProperties("Coordinate Reference System", var6_9, var5_6, var7_10, var8_11, var9_12, var10_13), (Datum)var17_21, (CoordinateSystem)var16_20, var12_15);
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)149, var11_14));
                    }
                }
                var2_2 = this.ensureSingleton((T)var13_16, (T)var2_2, (Comparable<?>)var1_1);
                if (!var3_3.isClosed()) continue;
                return var2_2;
            }
            break block62;
lbl179:
            // 1 sources

            finally {
                if (var3_3 != null) {
                    if (var4_5 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (Throwable var15_19) {
                            var4_5.addSuppressed(var15_19);
                        }
                    } else {
                        var3_3.close();
                    }
                }
            }
        }
        if (var2_2 != null) return var2_2;
        throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, var1_1);
    }

    @Override
    public synchronized Datum createDatum(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        Datum datum = null;
        try (ResultSet resultSet = this.executeQuery("Datum", "DATUM_CODE", "DATUM_NAME", "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, REALIZATION_EPOCH, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, DEPRECATED, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE FROM [Datum] WHERE DATUM_CODE = ?", string);){
            while (resultSet.next()) {
                EngineeringDatum engineeringDatum;
                CharSequence[] charSequenceArray;
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                String string3 = this.getString((Comparable<?>)((Object)string), resultSet, 3);
                String string4 = EPSGDataAccess.getOptionalString(resultSet, 4);
                String string5 = EPSGDataAccess.getOptionalString(resultSet, 5);
                String string6 = EPSGDataAccess.getOptionalString(resultSet, 6);
                String string7 = EPSGDataAccess.getOptionalString(resultSet, 7);
                String string8 = EPSGDataAccess.getOptionalString(resultSet, 8);
                boolean bl = this.getOptionalBoolean(resultSet, 9);
                Map<String, Object> map = this.createProperties("Datum", string2, n, string6, string7, string8, bl);
                if (string4 != null) {
                    map.put("anchorPoint", string4);
                }
                if (string5 != null) {
                    try {
                        charSequenceArray = CharSequences.split(string5, '-');
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 1;
                        int n5 = Math.min(charSequenceArray.length, 3);
                        while (--n5 >= 0) {
                            int n6 = Integer.parseInt(charSequenceArray[n5].toString());
                            switch (n5) {
                                case 0: {
                                    n2 = n6;
                                    break;
                                }
                                case 1: {
                                    n3 = n6 - 1;
                                    break;
                                }
                                case 2: {
                                    n4 = n6;
                                }
                            }
                        }
                        if (n2 != 0) {
                            Calendar calendar = this.getCalendar();
                            calendar.set(n2, n3, n4);
                            map.put("realizationEpoch", calendar.getTime());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        EPSGDataAccess.unexpectedException("createDatum", numberFormatException);
                    }
                }
                charSequenceArray = this.owner.datumFactory;
                switch (string3.toLowerCase(Locale.US)) {
                    case "geodetic": {
                        map = new HashMap<String, Object>(map);
                        Ellipsoid ellipsoid = this.owner.createEllipsoid(this.getString((Comparable<?>)((Object)string), resultSet, 10));
                        PrimeMeridian primeMeridian = this.owner.createPrimeMeridian(this.getString((Comparable<?>)((Object)string), resultSet, 11));
                        BursaWolfParameters[] bursaWolfParametersArray = this.createBursaWolfParameters(primeMeridian, n);
                        if (bursaWolfParametersArray != null) {
                            map.put("bursaWolf", bursaWolfParametersArray);
                        }
                        engineeringDatum = charSequenceArray.createGeodeticDatum(map, ellipsoid, primeMeridian);
                        break;
                    }
                    case "vertical": {
                        engineeringDatum = charSequenceArray.createVerticalDatum(map, VerticalDatumType.GEOIDAL);
                        break;
                    }
                    case "temporal": {
                        Date date;
                        if (string4 == null || string4.isEmpty()) {
                            throw new FactoryDataException(this.resources().getString((short)14));
                        }
                        if (this.dateFormat == null) {
                            this.dateFormat = new StandardDateFormat();
                            this.dateFormat.setCalendar(this.getCalendar());
                        }
                        try {
                            date = this.dateFormat.parse(string4);
                        }
                        catch (ParseException parseException) {
                            throw new FactoryDataException(this.resources().getString((short)14), parseException);
                        }
                        engineeringDatum = charSequenceArray.createTemporalDatum(map, date);
                        break;
                    }
                    case "engineering": {
                        engineeringDatum = charSequenceArray.createEngineeringDatum(map);
                        break;
                    }
                    case "parametric": {
                        engineeringDatum = ReferencingServices.getInstance().createParametricDatum(map, (DatumFactory)charSequenceArray);
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)149, string3));
                    }
                }
                datum = this.ensureSingleton((Object)engineeringDatum, (Object)datum, (Comparable<?>)((Object)string));
                if (!resultSet.isClosed()) continue;
                break;
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(Datum.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (datum == null) {
            throw this.noSuchAuthorityCode(Datum.class, string);
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BursaWolfParameters[] createBursaWolfParameters(PrimeMeridian primeMeridian, Integer n) throws SQLException, FactoryException {
        Object object;
        if (n == 6326) {
            return null;
        }
        ArrayList<BursaWolfInfo> arrayList = new ArrayList<BursaWolfInfo>();
        Object[] objectArray = null;
        try (ResultSet resultSet = this.executeQuery("BursaWolfParametersSet", "SELECT COORD_OP_CODE, COORD_OP_METHOD_CODE, TARGET_CRS_CODE, AREA_OF_USE_CODE FROM [Coordinate_Operation] WHERE DEPRECATED=0 AND TARGET_CRS_CODE = 4326 AND COORD_OP_METHOD_CODE >= 9603 AND COORD_OP_METHOD_CODE <= 9607 AND SOURCE_CRS_CODE IN (SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE DATUM_CODE = ?) ORDER BY TARGET_CRS_CODE, COORD_OP_ACCURACY, COORD_OP_CODE DESC", n);){
            while (resultSet.next()) {
                object = new BursaWolfInfo(this.getInteger(n, resultSet, 1), this.getInteger(n, resultSet, 2), this.getInteger(n, resultSet, 3), this.getInteger(n, resultSet, 4));
                if (((BursaWolfInfo)object).target == n) continue;
                arrayList.add((BursaWolfInfo)object);
            }
        }
        catch (Throwable object2) {
            objectArray = object2;
            throw object2;
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            return null;
        }
        if (n2 > 1) {
            objectArray = arrayList.toArray(new BursaWolfInfo[n2]);
            this.sort("Coordinate_Operation", objectArray);
            arrayList.clear();
            BursaWolfInfo.filter(this.owner, (BursaWolfInfo[])objectArray, arrayList);
            n2 = arrayList.size();
        }
        objectArray = new BursaWolfParameters[n2];
        object = this.getLocale();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            GeodeticDatum geodeticDatum;
            BursaWolfInfo bursaWolfInfo = (BursaWolfInfo)arrayList.get(i);
            this.ensureNoCycle(BursaWolfParameters.class, n);
            try {
                geodeticDatum = this.owner.createGeodeticDatum(String.valueOf(bursaWolfInfo.target));
            }
            finally {
                this.endOfRecursivity(BursaWolfParameters.class, n);
            }
            if (!Utilities.equalsIgnoreMetadata(primeMeridian, geodeticDatum.getPrimeMeridian())) continue;
            BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(geodeticDatum, bursaWolfInfo.getDomainOfValidity(this.owner));
            try (ResultSet resultSet = this.executeQuery("BursaWolfParameters", "SELECT PARAMETER_CODE, PARAMETER_VALUE, UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE COORD_OP_CODE = ? AND COORD_OP_METHOD_CODE = ?", bursaWolfInfo.operation, bursaWolfInfo.method);){
                while (resultSet.next()) {
                    BursaWolfInfo.setBursaWolfParameter(bursaWolfParameters, this.getInteger(Integer.valueOf(bursaWolfInfo.operation), resultSet, 1), this.getDouble(Integer.valueOf(bursaWolfInfo.operation), resultSet, 2), this.owner.createUnit(this.getString(Integer.valueOf(bursaWolfInfo.operation), resultSet, 3)), (Locale)object);
                }
            }
            if (bursaWolfInfo.isFrameRotation()) {
                bursaWolfParameters.reverseRotation();
            }
            objectArray[n3++] = bursaWolfParameters;
        }
        return (BursaWolfParameters[])ArraysExt.resize(objectArray, n3);
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        Ellipsoid ellipsoid = null;
        try (ResultSet resultSet = this.executeQuery("Ellipsoid", "ELLIPSOID_CODE", "ELLIPSOID_NAME", "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS, DEPRECATED FROM [Ellipsoid] WHERE ELLIPSOID_CODE = ?", string);){
            while (resultSet.next()) {
                Ellipsoid ellipsoid2;
                Object object;
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                double d = this.getDouble((Comparable<?>)((Object)string), resultSet, 3);
                double d2 = EPSGDataAccess.getOptionalDouble(resultSet, 4);
                double d3 = EPSGDataAccess.getOptionalDouble(resultSet, 5);
                String string3 = this.getString((Comparable<?>)((Object)string), resultSet, 6);
                String string4 = EPSGDataAccess.getOptionalString(resultSet, 7);
                boolean bl = this.getOptionalBoolean(resultSet, 8);
                Unit<Length> unit = this.owner.createUnit(string3).asType(Length.class);
                Map<String, Object> map = this.createProperties("Ellipsoid", string2, n, string4, bl);
                if (Double.isNaN(d2)) {
                    if (Double.isNaN(d3)) {
                        object = resultSet.getMetaData().getColumnName(3);
                        throw new FactoryDataException(this.error().getString((short)117, string, object));
                    }
                    ellipsoid2 = this.owner.datumFactory.createEllipsoid(map, d, d3, unit);
                } else {
                    if (!Double.isNaN(d3)) {
                        object = this.resources().getLogRecord(Level.WARNING, (short)1, "EPSG:" + string);
                        ((LogRecord)object).setLoggerName("org.apache.sis.referencing.factory");
                        Logging.log(EPSGDataAccess.class, "createEllipsoid", (LogRecord)object);
                    }
                    ellipsoid2 = this.owner.datumFactory.createFlattenedSphere(map, d, d2, unit);
                }
                ellipsoid = this.ensureSingleton((Object)ellipsoid2, (Object)ellipsoid, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(Ellipsoid.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (ellipsoid == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, string);
        }
        return ellipsoid;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        PrimeMeridian primeMeridian = null;
        try (ResultSet resultSet = this.executeQuery("Prime Meridian", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME", "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS, DEPRECATED FROM [Prime Meridian] WHERE PRIME_MERIDIAN_CODE = ?", string);){
            while (resultSet.next()) {
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                double d = this.getDouble((Comparable<?>)((Object)string), resultSet, 3);
                String string3 = this.getString((Comparable<?>)((Object)string), resultSet, 4);
                String string4 = EPSGDataAccess.getOptionalString(resultSet, 5);
                boolean bl = this.getOptionalBoolean(resultSet, 6);
                Unit<Angle> unit = this.owner.createUnit(string3).asType(Angle.class);
                PrimeMeridian primeMeridian2 = this.owner.datumFactory.createPrimeMeridian(this.createProperties("Prime Meridian", string2, n, string4, bl), d, unit);
                primeMeridian = this.ensureSingleton((Object)primeMeridian2, (Object)primeMeridian, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(PrimeMeridian.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (primeMeridian == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, string);
        }
        return primeMeridian;
    }

    @Override
    public synchronized Extent createExtent(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        Extent extent = null;
        try (ResultSet resultSet = this.executeQuery("Area", "AREA_CODE", "AREA_NAME", "SELECT AREA_OF_USE, AREA_SOUTH_BOUND_LAT, AREA_NORTH_BOUND_LAT, AREA_WEST_BOUND_LON, AREA_EAST_BOUND_LON FROM [Area] WHERE AREA_CODE = ?", string);){
            while (resultSet.next()) {
                String string2 = EPSGDataAccess.getOptionalString(resultSet, 1);
                double d = EPSGDataAccess.getOptionalDouble(resultSet, 2);
                double d2 = EPSGDataAccess.getOptionalDouble(resultSet, 3);
                double d3 = EPSGDataAccess.getOptionalDouble(resultSet, 4);
                double d4 = EPSGDataAccess.getOptionalDouble(resultSet, 5);
                DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
                if (!(Double.isNaN(d) && Double.isNaN(d2) && Double.isNaN(d3) && Double.isNaN(d4))) {
                    if (d > d2) {
                        double d5 = d;
                        d = d2;
                        d2 = d5;
                    }
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(d3, d4, d, d2);
                }
                if (string2 == null && defaultGeographicBoundingBox == null) continue;
                DefaultExtent defaultExtent = new DefaultExtent(string2, defaultGeographicBoundingBox, null, null);
                defaultExtent.freeze();
                extent = this.ensureSingleton((Object)defaultExtent, (Object)extent, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(Extent.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (extent == null) {
            throw this.noSuchAuthorityCode(Extent.class, string);
        }
        return extent;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        CoordinateSystem coordinateSystem = null;
        try (ResultSet resultSet = this.executeQuery("Coordinate System", "COORD_SYS_CODE", "COORD_SYS_NAME", "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS, DEPRECATED FROM [Coordinate System] WHERE COORD_SYS_CODE = ?", string);){
            while (resultSet.next()) {
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                String string3 = this.getString((Comparable<?>)((Object)string), resultSet, 3);
                int n2 = this.getInteger((Comparable<?>)((Object)string), resultSet, 4);
                String string4 = EPSGDataAccess.getOptionalString(resultSet, 5);
                boolean bl = this.getOptionalBoolean(resultSet, 6);
                CoordinateSystemAxis[] coordinateSystemAxisArray = this.createCoordinateSystemAxes(n, n2);
                Map<String, Object> map = this.createProperties("Coordinate System", string2, n, string4, bl);
                CSFactory cSFactory = this.owner.csFactory;
                VerticalCS verticalCS = null;
                switch (string3.toLowerCase(Locale.US)) {
                    case "ellipsoidal": {
                        switch (n2) {
                            case 2: {
                                verticalCS = cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                                break;
                            }
                            case 3: {
                                verticalCS = cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                        break;
                    }
                    case "cartesian": {
                        switch (n2) {
                            case 2: {
                                verticalCS = cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                                break;
                            }
                            case 3: {
                                verticalCS = cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                        break;
                    }
                    case "spherical": {
                        switch (n2) {
                            case 3: {
                                verticalCS = cSFactory.createSphericalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                        break;
                    }
                    case "vertical": 
                    case "gravity-related": {
                        switch (n2) {
                            case 1: {
                                verticalCS = cSFactory.createVerticalCS(map, coordinateSystemAxisArray[0]);
                            }
                        }
                        break;
                    }
                    case "time": 
                    case "temporal": {
                        switch (n2) {
                            case 1: {
                                verticalCS = cSFactory.createTimeCS(map, coordinateSystemAxisArray[0]);
                            }
                        }
                        break;
                    }
                    case "parametric": {
                        switch (n2) {
                            case 1: {
                                verticalCS = ReferencingServices.getInstance().createParametricCS(map, coordinateSystemAxisArray[0], cSFactory);
                            }
                        }
                        break;
                    }
                    case "linear": {
                        switch (n2) {
                            case 1: {
                                verticalCS = cSFactory.createLinearCS(map, coordinateSystemAxisArray[0]);
                            }
                        }
                        break;
                    }
                    case "polar": {
                        switch (n2) {
                            case 2: {
                                verticalCS = cSFactory.createPolarCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                            }
                        }
                        break;
                    }
                    case "cylindrical": {
                        switch (n2) {
                            case 3: {
                                verticalCS = cSFactory.createCylindricalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                        break;
                    }
                    case "affine": {
                        switch (n2) {
                            case 2: {
                                verticalCS = cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                                break;
                            }
                            case 3: {
                                verticalCS = cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                            }
                        }
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)149, string3));
                    }
                }
                if (verticalCS == null) {
                    throw new FactoryDataException(this.resources().getString((short)64, string3));
                }
                coordinateSystem = this.ensureSingleton((Object)verticalCS, (Object)coordinateSystem, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(CoordinateSystem.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (coordinateSystem == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, string);
        }
        return coordinateSystem;
    }

    private Integer getDimensionForCS(Integer n) throws SQLException {
        Integer n2 = this.csDimensions.get(n);
        if (n2 == null) {
            try (ResultSet resultSet = this.executeQuery("Dimension", " SELECT COUNT(COORD_AXIS_CODE) FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ?", n);){
                n2 = resultSet.next() ? resultSet.getInt(1) : 0;
                this.csDimensions.put(n, n2);
            }
        }
        return n2 != 0 ? n2 : null;
    }

    private CoordinateSystemAxis[] createCoordinateSystemAxes(Integer n, int n2) throws SQLException, FactoryException {
        int n3 = 0;
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n2];
        try (ResultSet resultSet = this.executeQuery("AxisOrder", "SELECT COORD_AXIS_CODE FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ? ORDER BY [ORDER]", n);){
            while (resultSet.next()) {
                String string = this.getString(n, resultSet, 1);
                if (n3 < coordinateSystemAxisArray.length) {
                    coordinateSystemAxisArray[n3] = this.owner.createCoordinateSystemAxis(string);
                }
                ++n3;
            }
        }
        if (n3 != coordinateSystemAxisArray.length) {
            throw new FactoryDataException(this.error().getString((short)80, coordinateSystemAxisArray.length, n3));
        }
        return coordinateSystemAxisArray;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        CoordinateSystemAxis coordinateSystemAxis = null;
        try (ResultSet resultSet = this.executeQuery("Coordinate Axis", "COORD_AXIS_CODE", null, "SELECT COORD_AXIS_CODE, COORD_AXIS_NAME_CODE, COORD_AXIS_ORIENTATION, COORD_AXIS_ABBREVIATION, UOM_CODE FROM [Coordinate Axis] WHERE COORD_AXIS_CODE = ?", string);){
            while (resultSet.next()) {
                AxisDirection axisDirection;
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                Integer n2 = this.getInteger((Comparable<?>)((Object)string), resultSet, 2);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 3);
                String string3 = this.getString((Comparable<?>)((Object)string), resultSet, 4);
                String string4 = this.getString((Comparable<?>)((Object)string), resultSet, 5);
                try {
                    axisDirection = CoordinateSystems.parseAxisDirection(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new FactoryDataException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
                }
                AxisName axisName = this.getAxisName(n2);
                CoordinateSystemAxis coordinateSystemAxis2 = this.owner.csFactory.createCoordinateSystemAxis(this.createProperties("Coordinate Axis", axisName.name, n, axisName.description, false), string3, axisDirection, this.owner.createUnit(string4));
                coordinateSystemAxis = this.ensureSingleton((Object)coordinateSystemAxis2, (Object)coordinateSystemAxis, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(CoordinateSystemAxis.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (coordinateSystemAxis == null) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, string);
        }
        return coordinateSystemAxis;
    }

    private AxisName getAxisName(Integer n) throws FactoryException, SQLException {
        assert (Thread.holdsLock(this));
        AxisName axisName = this.axisNames.get(n);
        if (axisName == null) {
            try (ResultSet resultSet = this.executeQuery("Coordinate Axis Name", "SELECT COORD_AXIS_NAME, DESCRIPTION, REMARKS FROM [Coordinate Axis Name] WHERE COORD_AXIS_NAME_CODE = ?", n);){
                while (resultSet.next()) {
                    String string = this.getString(n, resultSet, 1);
                    String string2 = EPSGDataAccess.getOptionalString(resultSet, 2);
                    String string3 = EPSGDataAccess.getOptionalString(resultSet, 3);
                    if (string2 == null) {
                        string2 = string3;
                    } else if (string3 != null) {
                        string2 = string2 + System.lineSeparator() + string3;
                    }
                    AxisName axisName2 = new AxisName(string, string2);
                    axisName = this.ensureSingleton(axisName2, axisName, n);
                }
            }
            if (axisName == null) {
                throw this.noSuchAuthorityCode(AxisName.class, String.valueOf(n));
            }
            this.axisNames.put(n, axisName);
        }
        return axisName;
    }

    @Override
    public synchronized Unit<?> createUnit(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        Unit unit = null;
        try (ResultSet resultSet = this.executeQuery("Unit of Measure", "UOM_CODE", "UNIT_OF_MEAS_NAME", "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE, UNIT_OF_MEAS_NAME FROM [Unit of Measure] WHERE UOM_CODE = ?", string);){
            while (resultSet.next()) {
                Unit<?> unit2;
                int n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                double d = EPSGDataAccess.getOptionalDouble(resultSet, 2);
                double d2 = EPSGDataAccess.getOptionalDouble(resultSet, 3);
                int n2 = this.getInteger((Comparable<?>)((Object)string), resultSet, 4);
                if (n == n2) {
                    boolean bl;
                    boolean bl2 = bl = d != 1.0;
                    if (bl || d2 != 1.0) {
                        throw new FactoryDataException(this.error().getString((short)67, bl ? "FACTOR_B" : "FACTOR_C", bl ? d : d2));
                    }
                }
                if ((unit2 = Units.valueOfEPSG(n)) == null) {
                    Unit<?> unit3 = Units.valueOfEPSG(n2);
                    if (unit3 != null && !Double.isNaN(d) && !Double.isNaN(d2)) {
                        unit2 = Units.multiply(unit3, d, d2);
                    } else {
                        try {
                            unit2 = Units.valueOf(this.getString((Comparable<?>)((Object)string), resultSet, 5));
                        }
                        catch (ParserException parserException) {
                            throw new FactoryDataException(this.error().getString((short)150, string), parserException);
                        }
                    }
                }
                unit = this.ensureSingleton((Object)unit2, (Object)unit, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(Unit.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (unit == null) {
            throw this.noSuchAuthorityCode(Unit.class, string);
        }
        return unit;
    }

    @Override
    public synchronized ParameterDescriptor<?> createParameterDescriptor(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        ParameterDescriptor parameterDescriptor = null;
        try (ResultSet resultSet = this.executeQuery("Coordinate_Operation Parameter", "PARAMETER_CODE", "PARAMETER_NAME", "SELECT PARAMETER_CODE, PARAMETER_NAME, DESCRIPTION, DEPRECATED FROM [Coordinate_Operation Parameter] WHERE PARAMETER_CODE = ?", string);){
            while (resultSet.next()) {
                DefaultParameterDescriptor<Object> defaultParameterDescriptor;
                Object object;
                Object object2;
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                String string3 = EPSGDataAccess.getOptionalString(resultSet, 3);
                boolean bl = this.getOptionalBoolean(resultSet, 4);
                Class clazz = Double.class;
                Object object3 = this.executeQuery("ParameterType", "SELECT PARAM_VALUE_FILE_REF FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) AND PARAM_VALUE_FILE_REF IS NOT NULL", n);
                Object object4 = null;
                try {
                    while (object3.next()) {
                        object2 = EPSGDataAccess.getOptionalString((ResultSet)object3, 1);
                        if (object2 == null || ((String)object2).isEmpty()) continue;
                        clazz = String.class;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    object4 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object4 != null) {
                            try {
                                object3.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object4).addSuppressed(throwable);
                            }
                        } else {
                            object3.close();
                        }
                    }
                }
                object3 = new LinkedHashSet();
                object4 = this.executeQuery("ParameterUnit", "SELECT UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) GROUP BY UOM_CODE ORDER BY COUNT(UOM_CODE) DESC", n);
                object2 = null;
                try {
                    block44: while (object4.next()) {
                        object = EPSGDataAccess.getOptionalString((ResultSet)object4, 1);
                        if (object == null) continue;
                        defaultParameterDescriptor = this.owner.createUnit((String)object);
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            Unit unit = (Unit)iterator.next();
                            if (!defaultParameterDescriptor.isCompatible(unit)) continue;
                            continue block44;
                        }
                        object3.add(defaultParameterDescriptor);
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object4 != null) {
                        if (object2 != null) {
                            try {
                                object4.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            object4.close();
                        }
                    }
                }
                object4 = null;
                object2 = this.executeQuery("ParameterSign", "SELECT DISTINCT PARAM_SIGN_REVERSAL FROM [Coordinate_Operation Parameter Usage] WHERE (PARAMETER_CODE = ?)", n);
                object = null;
                try {
                    if (object2.next()) {
                        if (this.translator.useBoolean()) {
                            defaultParameterDescriptor = object2.getBoolean(1);
                            if (object2.wasNull()) {
                                defaultParameterDescriptor = null;
                            }
                        } else {
                            defaultParameterDescriptor = SQLUtilities.toBoolean(object2.getString(1));
                        }
                        if (defaultParameterDescriptor != null) {
                            object4 = ((Boolean)((Object)defaultParameterDescriptor)).booleanValue() ? SignReversalComment.OPPOSITE : SignReversalComment.SAME;
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                object2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            object2.close();
                        }
                    }
                }
                switch (object3.size()) {
                    case 0: {
                        object2 = null;
                        break;
                    }
                    default: {
                        object2 = new EPSGParameterDomain((Set<Unit<?>>)object3);
                        break;
                    }
                    case 1: {
                        object2 = MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, (Unit)CollectionsExt.first(object3));
                    }
                }
                object = this.createProperties("Coordinate_Operation Parameter", string2, n, (CharSequence)object4, bl);
                object.put((String)"description", (Object)string3);
                defaultParameterDescriptor = new DefaultParameterDescriptor<Object>((Map<String, ?>)object, 1, 1, clazz, (Range<?>)object2, null, null);
                parameterDescriptor = this.ensureSingleton((Object)defaultParameterDescriptor, (Object)parameterDescriptor, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (parameterDescriptor == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, string);
        }
        return parameterDescriptor;
    }

    private ParameterDescriptor<?>[] createParameterDescriptors(Integer n) throws FactoryException, SQLException {
        ArrayList arrayList = new ArrayList();
        try (ResultSet resultSet = this.executeQuery("Coordinate_Operation Parameter Usage", "SELECT PARAMETER_CODE FROM [Coordinate_Operation Parameter Usage] WHERE COORD_OP_METHOD_CODE = ? ORDER BY SORT_ORDER", n);){
            while (resultSet.next()) {
                arrayList.add(this.owner.createParameterDescriptor(this.getString(n, resultSet, 1)));
            }
        }
        return arrayList.toArray(new ParameterDescriptor[arrayList.size()]);
    }

    /*
     * Exception decompiling
     */
    private void fillParameterValues(Integer var1_1, Integer var2_2, ParameterValueGroup var3_3) throws FactoryException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP], 2[TRYBLOCK]], but top level block is 21[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        OperationMethod operationMethod = null;
        try (ResultSet resultSet = this.executeQuery("Coordinate_Operation Method", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME", "SELECT COORD_OP_METHOD_CODE, COORD_OP_METHOD_NAME, REMARKS, DEPRECATED FROM [Coordinate_Operation Method] WHERE COORD_OP_METHOD_CODE = ?", string);){
            while (resultSet.next()) {
                Integer n = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string2 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                String string3 = EPSGDataAccess.getOptionalString(resultSet, 3);
                boolean bl = this.getOptionalBoolean(resultSet, 4);
                Integer[] integerArray = this.getDimensionsForMethod(n);
                ParameterDescriptor<?>[] parameterDescriptorArray = this.createParameterDescriptors(n);
                Map<String, Object> map = this.createProperties("Coordinate_Operation Method", string2, n, string3, bl);
                DefaultOperationMethod defaultOperationMethod = new DefaultOperationMethod(map, integerArray[0], integerArray[1], new DefaultParameterDescriptorGroup(map, 1, 1, (GeneralParameterDescriptor[])parameterDescriptorArray));
                operationMethod = this.ensureSingleton((Object)defaultOperationMethod, (Object)operationMethod, (Comparable<?>)((Object)string));
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (operationMethod == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, string);
        }
        return operationMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        CoordinateOperation coordinateOperation = null;
        try (ResultSet resultSet = this.executeQuery("Coordinate_Operation", "COORD_OP_CODE", "COORD_OP_NAME", "SELECT COORD_OP_CODE, COORD_OP_NAME, COORD_OP_TYPE, SOURCE_CRS_CODE, TARGET_CRS_CODE, COORD_OP_METHOD_CODE, COORD_TFM_VERSION, COORD_OP_ACCURACY, AREA_OF_USE_CODE, COORD_OP_SCOPE, REMARKS, DEPRECATED FROM [Coordinate_Operation] WHERE COORD_OP_CODE = ?", string);){
            while (resultSet.next()) {
                MathTransform mathTransform;
                DeferredCoordinateOperation deferredCoordinateOperation;
                int n;
                CoordinateReferenceSystem coordinateReferenceSystem;
                int n2;
                CoordinateReferenceSystem coordinateReferenceSystem2;
                String string2;
                String string3;
                Integer n3 = this.getInteger((Comparable<?>)((Object)string), resultSet, 1);
                String string4 = this.getString((Comparable<?>)((Object)string), resultSet, 2);
                String string5 = this.getString((Comparable<?>)((Object)string), resultSet, 3).toLowerCase(Locale.US);
                boolean bl = string5.equals("transformation");
                boolean bl2 = string5.equals("conversion");
                boolean bl3 = string5.equals("concatenated operation");
                if (bl2) {
                    string3 = EPSGDataAccess.getOptionalString(resultSet, 4);
                    string2 = EPSGDataAccess.getOptionalString(resultSet, 5);
                } else {
                    string3 = this.getString((Comparable<?>)((Object)string), resultSet, 4);
                    string2 = this.getString((Comparable<?>)((Object)string), resultSet, 5);
                }
                Integer n4 = bl3 ? EPSGDataAccess.getOptionalInteger(resultSet, 6) : this.getInteger((Comparable<?>)((Object)string), resultSet, 6);
                String string6 = EPSGDataAccess.getOptionalString(resultSet, 7);
                double d = EPSGDataAccess.getOptionalDouble(resultSet, 8);
                String string7 = EPSGDataAccess.getOptionalString(resultSet, 9);
                String string8 = EPSGDataAccess.getOptionalString(resultSet, 10);
                String string9 = EPSGDataAccess.getOptionalString(resultSet, 11);
                boolean bl4 = this.getOptionalBoolean(resultSet, 12);
                boolean bl5 = true;
                if (string3 != null) {
                    coordinateReferenceSystem2 = this.owner.createCoordinateReferenceSystem(string3);
                    n2 = coordinateReferenceSystem2.getCoordinateSystem().getDimension();
                } else {
                    coordinateReferenceSystem2 = null;
                    n2 = 2;
                    bl5 = false;
                }
                if (string2 != null) {
                    coordinateReferenceSystem = this.owner.createCoordinateReferenceSystem(string2);
                    n = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                } else {
                    coordinateReferenceSystem = null;
                    n = 2;
                    bl5 = false;
                }
                boolean bl6 = Semaphores.query(2);
                ParameterValueGroup parameterValueGroup = null;
                OperationMethod operationMethod = null;
                if (n4 != null && !bl6) {
                    operationMethod = this.owner.createOperationMethod(n4.toString());
                    if (bl5) {
                        operationMethod = DefaultOperationMethod.redimension(operationMethod, n2, n);
                    }
                    parameterValueGroup = operationMethod.getParameters().createValue();
                    this.fillParameterValues(n4, n3, parameterValueGroup);
                }
                Map<String, Object> map = this.createProperties("Coordinate_Operation", string4, n3, string7, string8, string9, bl4);
                map.put("operationVersion", string6);
                if (!Double.isNaN(d)) {
                    map.put("coordinateOperationAccuracy", TransformationAccuracy.create(d));
                }
                CoordinateOperationFactory coordinateOperationFactory = this.owner.copFactory;
                if (bl6) {
                    deferredCoordinateOperation = new DeferredCoordinateOperation(map, coordinateReferenceSystem2, coordinateReferenceSystem, this.owner);
                } else if (bl2 && (coordinateReferenceSystem2 == null || coordinateReferenceSystem == null)) {
                    deferredCoordinateOperation = coordinateOperationFactory.createDefiningConversion(map, operationMethod, parameterValueGroup);
                } else {
                    Class<? extends SingleOperation> clazz;
                    Class clazz2;
                    Object object;
                    if (bl3) {
                        resultSet.close();
                        map = new HashMap<String, Object>(map);
                        mathTransform = new ArrayList();
                        object = this.executeQuery("Coordinate_Operation Path", "SELECT SINGLE_OPERATION_CODE FROM [Coordinate_Operation Path] WHERE (CONCAT_OPERATION_CODE = ?) ORDER BY OP_PATH_STEP", n3);
                        clazz2 = null;
                        try {
                            while (object.next()) {
                                mathTransform.add(this.getString((Comparable<?>)((Object)string), (ResultSet)object, 1));
                            }
                        }
                        catch (Throwable throwable) {
                            clazz2 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object != null) {
                                if (clazz2 != null) {
                                    try {
                                        object.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)((Object)clazz2)).addSuppressed(throwable);
                                    }
                                } else {
                                    object.close();
                                }
                            }
                        }
                        object = new CoordinateOperation[mathTransform.size()];
                        this.ensureNoCycle(CoordinateOperation.class, n3);
                        try {
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                object[i] = this.owner.createCoordinateOperation((String)mathTransform.get(i));
                            }
                        }
                        finally {
                            this.endOfRecursivity(CoordinateOperation.class, n3);
                        }
                        CoordinateOperation coordinateOperation2 = coordinateOperationFactory.createConcatenatedOperation(map, (CoordinateOperation[])object);
                        return coordinateOperation2;
                    }
                    object = this.owner.mtFactory;
                    mathTransform = object instanceof DefaultMathTransformFactory ? ((DefaultMathTransformFactory)object).createParameterizedTransform(parameterValueGroup, ReferencingUtilities.createTransformContext(coordinateReferenceSystem2, coordinateReferenceSystem, null)) : object.createBaseToDerived(coordinateReferenceSystem2, parameterValueGroup, coordinateReferenceSystem.getCoordinateSystem());
                    clazz2 = bl ? Transformation.class : (bl2 ? Conversion.class : SingleOperation.class);
                    OperationMethod operationMethod2 = object.getLastMethodUsed();
                    if (operationMethod2 instanceof DefaultOperationMethod && (clazz = ((DefaultOperationMethod)operationMethod2).getOperationType()) != null && clazz2.isAssignableFrom(clazz)) {
                        clazz2 = clazz.asSubclass(SingleOperation.class);
                    }
                    map.put("operationType", clazz2);
                    map.put("parameters", parameterValueGroup);
                    if (!(coordinateOperationFactory instanceof DefaultCoordinateOperationFactory)) {
                        throw new UnsupportedOperationException(this.error().getString((short)160, coordinateOperationFactory.getClass()));
                    }
                    deferredCoordinateOperation = ((DefaultCoordinateOperationFactory)coordinateOperationFactory).createSingleOperation(map, coordinateReferenceSystem2, coordinateReferenceSystem, null, operationMethod, mathTransform);
                }
                coordinateOperation = this.ensureSingleton((Object)deferredCoordinateOperation, (Object)coordinateOperation, (Comparable<?>)((Object)string));
                if (!resultSet.isClosed()) continue;
                mathTransform = coordinateOperation;
                return mathTransform;
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(CoordinateOperation.class, (Comparable<?>)((Object)string), sQLException);
        }
        if (coordinateOperation != null) return coordinateOperation;
        throw this.noSuchAuthorityCode(CoordinateOperation.class, string);
    }

    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        ArgumentChecks.ensureNonNull("sourceCRS", string);
        ArgumentChecks.ensureNonNull("targetCRS", string2);
        String string3 = string + " \u21e8 " + string2;
        CoordinateOperationSet coordinateOperationSet = new CoordinateOperationSet(this.owner);
        try {
            Object[] objectArray;
            int[] nArray = this.toPrimaryKeys(null, null, null, string, string2);
            boolean bl = false;
            do {
                String string4;
                if (bl) {
                    objectArray = "TransformationFromCRS";
                    string4 = "SELECT COORD_OP_CODE FROM [Coordinate_Operation] AS CO JOIN [Area] ON AREA_OF_USE_CODE = AREA_CODE WHERE CO.DEPRECATED=0 AND SOURCE_CRS_CODE = ? AND TARGET_CRS_CODE = ? ORDER BY COORD_OP_ACCURACY ASC NULLS LAST,  (AREA_EAST_BOUND_LON - AREA_WEST_BOUND_LON + CASE WHEN AREA_EAST_BOUND_LON < AREA_WEST_BOUND_LON THEN 360 ELSE 0 END) * (AREA_NORTH_BOUND_LAT - AREA_SOUTH_BOUND_LAT) * COS(RADIANS(AREA_NORTH_BOUND_LAT + AREA_SOUTH_BOUND_LAT)/2) DESC";
                } else {
                    objectArray = "ConversionFromCRS";
                    string4 = "SELECT PROJECTION_CONV_CODE FROM [Coordinate Reference System] WHERE SOURCE_GEOGCRS_CODE = ? AND COORD_REF_SYS_CODE = ?";
                }
                Integer n = bl ? null : Integer.valueOf(nArray[1]);
                try (ResultSet resultSet = this.executeQuery((String)objectArray, string4, nArray);){
                    while (resultSet.next()) {
                        coordinateOperationSet.addAuthorityCode(this.getString((Comparable<?>)((Object)string3), resultSet, 1), n);
                    }
                }
            } while (bl = !bl);
            objectArray = coordinateOperationSet.getAuthorityCodes();
            if (objectArray.length > 1 && this.sort("Coordinate_Operation", objectArray)) {
                coordinateOperationSet.setAuthorityCodes((String[])objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw this.databaseFailure(CoordinateOperation.class, (Comparable<?>)((Object)string3), sQLException);
        }
        if (!Semaphores.query(2)) {
            coordinateOperationSet.resolve(1);
        }
        return coordinateOperationSet;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new Finder();
    }

    final boolean isProjection(Integer n) throws SQLException {
        Boolean bl = this.isProjection.get(n);
        if (bl == null) {
            try (ResultSet resultSet = this.executeQuery("isProjection", "SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE PROJECTION_CONV_CODE = ? AND CAST(COORD_REF_SYS_KIND AS VARCHAR(24)) LIKE 'projected%'", n);){
                bl = resultSet.next();
            }
            this.isProjection.put(n, bl);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer[] getDimensionsForMethod(Integer n) throws SQLException {
        Integer[] integerArray = new Integer[2];
        boolean[] blArray = new boolean[2];
        int n2 = 0;
        boolean bl = false;
        do {
            String string;
            String string2;
            if (!bl) {
                string2 = "MethodDimensions";
                string = "SELECT DISTINCT SRC.COORD_SYS_CODE, TGT.COORD_SYS_CODE FROM [Coordinate_Operation] AS CO INNER JOIN [Coordinate Reference System] AS SRC ON SRC.COORD_REF_SYS_CODE = CO.SOURCE_CRS_CODE INNER JOIN [Coordinate Reference System] AS TGT ON TGT.COORD_REF_SYS_CODE = CO.TARGET_CRS_CODE WHERE CO.DEPRECATED=0 AND COORD_OP_METHOD_CODE = ?";
            } else {
                string2 = "DerivedDimensions";
                string = "SELECT DISTINCT SRC.COORD_SYS_CODE, TGT.COORD_SYS_CODE FROM [Coordinate Reference System] AS TGT INNER JOIN [Coordinate Reference System] AS SRC ON TGT.SOURCE_GEOGCRS_CODE = SRC.COORD_REF_SYS_CODE INNER JOIN [Coordinate_Operation] AS CO ON TGT.PROJECTION_CONV_CODE = CO.COORD_OP_CODE WHERE CO.DEPRECATED=0 AND COORD_OP_METHOD_CODE = ?";
            }
            try (ResultSet resultSet = this.executeQuery(string2, string, n);){
                while (resultSet.next()) {
                    for (int n3 = 0; n3 < integerArray.length; ++n3) {
                        Integer n4;
                        if (blArray[n3] || (n4 = this.getDimensionForCS(resultSet.getInt(n3 + 1))) == null) continue;
                        if (integerArray[n3] == null) {
                            integerArray[n3] = n4;
                            continue;
                        }
                        if (n4.equals(integerArray[n3])) continue;
                        integerArray[n3] = null;
                        blArray[n3] = true;
                        if (++n2 != blArray.length) continue;
                        Integer[] integerArray2 = integerArray;
                        return integerArray2;
                    }
                }
            }
        } while (bl = !bl);
        return integerArray;
    }

    final synchronized boolean sort(String string, Object[] objectArray) throws SQLException, FactoryException {
        int n = 0;
        do {
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                try (ResultSet resultSet = this.executeQuery("Supersession", null, null, "SELECT OBJECT_TABLE_NAME, SUPERSEDED_BY FROM [Supersession] WHERE OBJECT_CODE = ? ORDER BY SUPERSESSION_YEAR DESC", string2);){
                    while (resultSet.next()) {
                        String string3;
                        if (!EPSGDataAccess.tableMatches(string, resultSet.getString(1)) || (string3 = resultSet.getString(2)) == null) continue;
                        for (int j = i + 1; j < objectArray.length; ++j) {
                            Object object = objectArray[j];
                            if (!string3.equals(object.toString())) continue;
                            System.arraycopy(objectArray, i, objectArray, i + 1, j - i);
                            objectArray[i++] = object;
                            bl = true;
                        }
                    }
                    continue;
                }
            }
            if (bl) continue;
            return n != 0;
        } while (++n < 15);
        return true;
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> clazz, String string) {
        return new NoSuchAuthorityCodeException(this.resources().getString((short)49, "EPSG", clazz, string), "EPSG", string, string);
    }

    final FactoryException databaseFailure(Class<?> clazz, Comparable<?> comparable, SQLException sQLException) {
        return new FactoryException(this.error().getString((short)21, clazz, comparable), (Throwable)sQLException);
    }

    private Errors error() {
        return Errors.getResources(this.getLocale());
    }

    private Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    private static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.factory"), EPSGDataAccess.class, string, exception);
    }

    final synchronized boolean canClose() {
        boolean bl = true;
        if (!this.authorityCodes.isEmpty()) {
            System.gc();
            Iterator<CloseableReference<AuthorityCodes>> iterator = this.authorityCodes.values().iterator();
            while (iterator.hasNext()) {
                AuthorityCodes authorityCodes = (AuthorityCodes)iterator.next().get();
                if (authorityCodes == null) {
                    iterator.remove();
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public synchronized void close() throws FactoryException {
        SQLException sQLException = null;
        Iterator<PreparedStatement> iterator = this.statements.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().close();
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                }
                sQLException.addSuppressed(sQLException2);
            }
            iterator.remove();
        }
        Iterator<CloseableReference<AuthorityCodes>> iterator2 = this.authorityCodes.values().iterator();
        while (iterator2.hasNext()) {
            try {
                iterator2.next().close();
            }
            catch (SQLException sQLException3) {
                if (sQLException == null) {
                    sQLException = sQLException3;
                }
                sQLException.addSuppressed(sQLException3);
            }
            iterator2.remove();
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException4) {
            if (sQLException == null) {
                sQLException = sQLException4;
            }
            sQLException4.addSuppressed(sQLException);
        }
        if (sQLException != null) {
            throw new FactoryException((Throwable)sQLException);
        }
    }

    private final class Finder
    extends IdentifiedObjectFinder {
        Finder() {
            super(EPSGDataAccess.this.owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<IdentifiedObject> find(IdentifiedObject identifiedObject) throws FactoryException {
            boolean bl = EPSGDataAccess.this.quiet;
            EPSGDataAccess.this.quiet = true;
            try {
                Set<IdentifiedObject> set = super.find(identifiedObject);
                return set;
            }
            finally {
                EPSGDataAccess.this.quiet = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
            Object[] objectArray;
            Object object;
            Set<Double> set;
            TableInfo tableInfo;
            String string;
            String string2 = "COORD_REF_SYS_CODE";
            String string3 = "Coordinate Reference System";
            boolean bl = false;
            if (identifiedObject instanceof Ellipsoid) {
                string2 = "ELLIPSOID_CODE";
                string3 = "Ellipsoid";
                string = "SEMI_MAJOR_AXIS";
                tableInfo = TableInfo.ELLIPSOID;
                set = Collections.singleton(((Ellipsoid)identifiedObject).getSemiMajorAxis());
                bl = true;
            } else {
                if (identifiedObject instanceof GeneralDerivedCRS) {
                    object = ((GeneralDerivedCRS)identifiedObject).getBaseCRS();
                    string = "SOURCE_GEOGCRS_CODE";
                    tableInfo = TableInfo.CRS;
                } else if (identifiedObject instanceof SingleCRS) {
                    object = ((SingleCRS)identifiedObject).getDatum();
                    string = "DATUM_CODE";
                    tableInfo = TableInfo.CRS;
                } else if (identifiedObject instanceof GeodeticDatum) {
                    object = ((GeodeticDatum)identifiedObject).getEllipsoid();
                    string2 = "DATUM_CODE";
                    string3 = "Datum";
                    string = "ELLIPSOID_CODE";
                    tableInfo = TableInfo.DATUM;
                } else {
                    return super.getCodeCandidates(identifiedObject);
                }
                boolean bl2 = this.isIgnoringAxes();
                try {
                    this.setIgnoringAxes(true);
                    objectArray = this.find((IdentifiedObject)object);
                }
                finally {
                    this.setIgnoringAxes(bl2);
                }
                set = new LinkedHashSet<Double>(Containers.hashMapCapacity(objectArray.size()));
                for (Object object2 : objectArray) {
                    Identifier object3 = IdentifiedObjects.getIdentifier((IdentifiedObject)object2, Citations.EPSG);
                    if (object3 == null) continue;
                    try {
                        set.add((Double)Integer.parseInt(object3.getCode()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.factory"), Finder.class, "getCodeCandidates", numberFormatException);
                    }
                }
                if (set.isEmpty()) {
                    return Collections.emptySet();
                }
            }
            object = new StringBuilder(200);
            ((StringBuilder)object).append("SELECT ").append(string2).append(" FROM [").append(string3).append(']');
            tableInfo.where(identifiedObject.getClass(), (StringBuilder)object);
            ((StringBuilder)object).append(string);
            if (bl) {
                ((StringBuilder)object).append(">=? AND ").append(string).append("<=?");
            } else {
                ((StringBuilder)object).append("=?");
            }
            ((StringBuilder)object).append(this.getSearchDomain() == IdentifiedObjectFinder.Domain.ALL_DATASET ? " ORDER BY ABS(DEPRECATED), " : " AND DEPRECATED=0 ORDER BY ");
            if (bl) {
                ((StringBuilder)object).append("ABS(").append(string2).append("-?), ");
            }
            ((StringBuilder)object).append(string2);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            try {
                Object object2;
                objectArray = EPSGDataAccess.this.connection.prepareStatement(EPSGDataAccess.this.translator.apply(((StringBuilder)object).toString()));
                Object[] objectArray2 = null;
                try {
                    for (Number number : set) {
                        if (bl) {
                            double d = number.doubleValue();
                            double d2 = Math.abs(d * 1.5696105811844188E-9);
                            objectArray.setDouble(1, d - d2);
                            objectArray.setDouble(2, d + d2);
                            objectArray.setDouble(3, d);
                        } else {
                            objectArray.setInt(1, number.intValue());
                        }
                        object2 = objectArray.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (object2.next()) {
                                linkedHashSet.add(object2.getString(1));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object2 == null) continue;
                            if (throwable != null) {
                                try {
                                    object2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            object2.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    objectArray2 = throwable;
                    throw throwable;
                }
                finally {
                    if (objectArray != null) {
                        if (objectArray2 != null) {
                            try {
                                objectArray.close();
                            }
                            catch (Throwable throwable) {
                                objectArray2.addSuppressed(throwable);
                            }
                        } else {
                            objectArray.close();
                        }
                    }
                }
                linkedHashSet.remove(null);
                if (linkedHashSet.size() > 1 && EPSGDataAccess.this.sort(string2, objectArray = linkedHashSet.toArray())) {
                    void var13_23;
                    linkedHashSet.clear();
                    objectArray2 = objectArray;
                    int n = objectArray2.length;
                    boolean bl2 = false;
                    while (var13_23 < n) {
                        object2 = objectArray2[var13_23];
                        linkedHashSet.add((String)object2);
                        ++var13_23;
                    }
                }
            }
            catch (SQLException sQLException) {
                throw EPSGDataAccess.this.databaseFailure(Identifier.class, (Comparable<?>)((Object)String.valueOf(CollectionsExt.first(set))), sQLException);
            }
            return linkedHashSet;
        }
    }
}

