/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.FaultyNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.InlineContent;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SingleImportSolver {
    private final ProblemsHandler problemsHandler;
    private final LessCompiler.Configuration configuration;
    private TypesConversionUtils conversionUtils = new TypesConversionUtils();
    private ASTManipulator astManipulator = new ASTManipulator();
    private LessCompiler.Cache astCache;

    public SingleImportSolver(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
        this.astCache = configuration.getCache();
        if (this.astCache == null) {
            final HashMap map = new HashMap();
            this.astCache = new LessCompiler.Cache(){

                @Override
                public Object getAst(LessSource key) {
                    return map.get(key);
                }

                @Override
                public void setAst(LessSource key, Object value) {
                    map.put(key, value);
                }
            };
        }
    }

    public ASTCssNode importEncountered(Import importNode, LessSource source, AlreadyImportedSources alreadyImportedSources) {
        StyleSheet importedAst;
        LessSource importedSource;
        String filename = this.conversionUtils.extractFilename(importNode.getUrlExpression(), this.problemsHandler, this.configuration);
        if (filename == null) {
            this.problemsHandler.errorWrongImport(importNode.getUrlExpression());
            return null;
        }
        String urlParams = "";
        int paramsIndx = filename.lastIndexOf("?");
        if (paramsIndx != -1) {
            urlParams = filename.substring(paramsIndx);
            filename = filename.substring(0, paramsIndx);
        }
        if (!importNode.isInline() && this.treatAsCss(importNode, filename)) {
            return null;
        }
        filename = this.addLessSuffixIfNeeded(filename, urlParams);
        try {
            importedSource = source.relativeSource(filename);
        }
        catch (LessSource.FileNotFound ex) {
            return this.importFileNotFound(importNode, filename);
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorFileCanNotBeRead(importNode, filename);
            return null;
        }
        catch (LessSource.StringSourceException ex) {
            this.problemsHandler.warnLessImportNoBaseDirectory(importNode.getUrlExpression());
            return null;
        }
        if (importNode.isImportOnce() && alreadyImportedSources.alreadyVisited(importedSource)) {
            this.astManipulator.removeFromBody(importNode);
            return null;
        }
        try {
            if (importNode.isInline()) {
                ASTCssNode importedNode = this.replaceByInlineValue(importNode, importedSource.getContent());
                alreadyImportedSources.add(importedSource);
                this.configureVisibilityBlocks(importNode, Arrays.asList(importedNode));
                return importedNode;
            }
            importedAst = this.buildImportedAst(importNode, importedSource);
            alreadyImportedSources.add(importedSource);
        }
        catch (LessSource.FileNotFound e) {
            return this.importFileNotFound(importNode, filename);
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorFileCanNotBeRead(importNode, filename);
            return null;
        }
        List<ASTCssNode> importedNodes = importedAst.getChilds();
        this.configureVisibilityBlocks(importNode, importedAst.getChilds());
        this.astManipulator.replaceInBody((ASTCssNode)importNode, importedNodes);
        return importedAst;
    }

    private void configureVisibilityBlocks(Import importNode, List<ASTCssNode> nodes) {
        if (importNode.isReferenceOnly() || importNode.hasVisibilityBlock()) {
            int childVisibilityBlocks = importNode.getVisibilityBlocks() + (importNode.isReferenceOnly() ? 1 : 0);
            for (ASTCssNode child : nodes) {
                child.setVisibilityBlocks(childVisibilityBlocks);
            }
        }
    }

    private ASTCssNode replaceByInlineValue(Import node, String importedContent) {
        HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
        StyleSheet result = new StyleSheet(underlyingStructure);
        InlineContent content = new InlineContent(underlyingStructure, importedContent);
        result.addMember(content);
        result.configureParentToAllChilds();
        this.astManipulator.replaceInBody((ASTCssNode)node, content);
        return result;
    }

    private ASTCssNode importFileNotFound(Import node, String filename) {
        if (!node.isOptional()) {
            this.problemsHandler.errorFileNotFound(node, filename);
            return null;
        }
        return this.replaceByInlineValue(node, "");
    }

    private StyleSheet buildImportedAst(Import node, LessSource source) throws LessSource.FileNotFound, LessSource.CannotReadFile {
        StyleSheet importedAst = this.getImportedAst(node, source);
        if (node.hasMediums()) {
            HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
            StyleSheet result = new StyleSheet(underlyingStructure);
            Media media = new Media(underlyingStructure);
            result.addMember(media);
            media.setParent(result);
            media.setMediums(node.getMediums());
            GeneralBody mediaBody = new GeneralBody(underlyingStructure, importedAst.getMembers());
            media.setBody(mediaBody);
            media.configureParentToAllChilds();
            mediaBody.configureParentToAllChilds();
            return result;
        }
        return importedAst;
    }

    private StyleSheet getImportedAst(Import node, LessSource source) throws LessSource.FileNotFound, LessSource.CannotReadFile {
        StyleSheet importedAst = (StyleSheet)this.astCache.getAst(source);
        if (importedAst == null) {
            importedAst = this.parseContent(node, source.getContent(), source);
            this.astCache.setAst(source, importedAst);
        }
        return importedAst.clone();
    }

    private StyleSheet parseContent(Import importNode, String importedContent, LessSource source) {
        ANTLRParser parser = new ANTLRParser();
        ANTLRParser.ParseResult parsedSheet = parser.parseStyleSheet(importedContent, source);
        if (parsedSheet.hasErrors()) {
            StyleSheet result = new StyleSheet(importNode.getUnderlyingStructure());
            result.addMember(new FaultyNode(importNode));
            this.problemsHandler.addErrors(parsedSheet.getErrors());
            return result;
        }
        ASTBuilder astBuilder = new ASTBuilder(this.problemsHandler);
        StyleSheet lessStyleSheet = astBuilder.parseStyleSheet(parsedSheet.getTree());
        return lessStyleSheet;
    }

    private String addLessSuffixIfNeeded(String filename, String urlParams) {
        if (new File(filename).getName().contains(".")) {
            return filename;
        }
        return filename + ".less" + urlParams;
    }

    private boolean treatAsCss(Import node, String filename) {
        Import.ImportContent contentKind = node.getContentKind();
        return contentKind == Import.ImportContent.CSS || contentKind == Import.ImportContent.SUFFIX_BASED && this.isCssFile(filename);
    }

    private boolean isCssFile(String filename) {
        String lowerCase = filename.toLowerCase();
        return lowerCase.endsWith(".css") || lowerCase.endsWith("/css");
    }

    public static class AlreadyImportedSources {
        private Set<LessSource> sourcesThatCount = new HashSet<LessSource>();
        private Set<LessSource> allImportedSources;

        public AlreadyImportedSources(Set<LessSource> allImportedSources) {
            this.allImportedSources = allImportedSources;
        }

        public void add(LessSource importedSource) {
            this.sourcesThatCount.add(importedSource);
            this.allImportedSources.add(importedSource);
        }

        public boolean alreadyVisited(LessSource importedSource) {
            boolean result = this.sourcesThatCount.contains(importedSource);
            return result;
        }
    }
}

