/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.util.ArgumentChecks;

public final class PerformanceLevel
extends Level {
    private static final long serialVersionUID = -6547125008284983701L;
    public static final PerformanceLevel PERFORMANCE = new PerformanceLevel("PERFORMANCE", 600, 0L);
    public static final PerformanceLevel SLOW = new PerformanceLevel("SLOW", 610, 100000000L);
    public static final PerformanceLevel SLOWER = new PerformanceLevel("SLOWER", 620, 1000000000L);
    public static final PerformanceLevel SLOWEST = new PerformanceLevel("SLOWEST", 630, 5000000000L);
    private volatile long minDuration;

    private PerformanceLevel(String string, int n, long l) {
        super(string, n);
        this.minDuration = l;
    }

    public static PerformanceLevel forDuration(long l, TimeUnit timeUnit) {
        if ((l = timeUnit.toNanos(l)) >= PerformanceLevel.SLOWER.minDuration) {
            return l >= PerformanceLevel.SLOWEST.minDuration ? SLOWEST : SLOWER;
        }
        return l >= PerformanceLevel.SLOW.minDuration ? SLOW : PERFORMANCE;
    }

    public long getMinDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.minDuration, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinDuration(long l, TimeUnit timeUnit) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("duration", l);
        l = timeUnit.toNanos(l);
        int n = this.intValue();
        Class<PerformanceLevel> clazz = PerformanceLevel.class;
        synchronized (PerformanceLevel.class) {
            switch (n) {
                default: {
                    throw new AssertionError(this);
                }
                case 600: {
                    if (l > PerformanceLevel.SLOW.minDuration) {
                        PerformanceLevel.SLOW.minDuration = l;
                    }
                }
                case 610: {
                    if (l > PerformanceLevel.SLOWER.minDuration) {
                        PerformanceLevel.SLOWER.minDuration = l;
                    }
                }
                case 620: {
                    if (l <= PerformanceLevel.SLOWEST.minDuration) break;
                    PerformanceLevel.SLOWEST.minDuration = l;
                }
                case 630: 
            }
            switch (n) {
                default: {
                    throw new AssertionError(this);
                }
                case 630: {
                    if (l < PerformanceLevel.SLOWER.minDuration) {
                        PerformanceLevel.SLOWER.minDuration = l;
                    }
                }
                case 620: {
                    if (l < PerformanceLevel.SLOW.minDuration) {
                        PerformanceLevel.SLOW.minDuration = l;
                    }
                }
                case 610: {
                    this.minDuration = l;
                }
                case 600: 
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }
}

