/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.util;

public class VolumeHelper {
    private VolumeHelper() {
    }

    public static String nextVolumeName(String arcName, boolean oldNumbering) {
        if (!oldNumbering) {
            int indexL;
            int indexR;
            int len = arcName.length();
            for (indexR = len - 1; indexR >= 0 && !VolumeHelper.isDigit(arcName.charAt(indexR)); --indexR) {
            }
            int index = indexR + 1;
            for (indexL = indexR - 1; indexL >= 0 && VolumeHelper.isDigit(arcName.charAt(indexL)); --indexL) {
            }
            if (indexL < 0) {
                return null;
            }
            StringBuilder buffer = new StringBuilder(len);
            buffer.append(arcName, 0, ++indexL);
            char[] digits = new char[indexR - indexL + 1];
            arcName.getChars(indexL, indexR + 1, digits, 0);
            for (indexR = digits.length - 1; indexR >= 0; --indexR) {
                int n = indexR;
                digits[n] = (char)(digits[n] + '\u0001');
                if (digits[n] != ':') break;
                digits[indexR] = 48;
            }
            if (indexR < 0) {
                buffer.append('1');
            }
            buffer.append(digits);
            buffer.append(arcName, index, len);
            return buffer.toString();
        }
        int len = arcName.length();
        if (len <= 4 || arcName.charAt(len - 4) != '.') {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int off = len - 3;
        buffer.append(arcName, 0, off);
        if (!VolumeHelper.isDigit(arcName.charAt(off + 1)) || !VolumeHelper.isDigit(arcName.charAt(off + 2))) {
            buffer.append("r00");
        } else {
            char[] ext = new char[3];
            arcName.getChars(off, len, ext, 0);
            int i = ext.length - 1;
            while (true) {
                int n = --i;
                ext[n] = (char)(ext[n] + '\u0001');
                if (ext[n] != ':') break;
                ext[i] = 48;
            }
            buffer.append(ext);
        }
        return buffer.toString();
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

