/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    protected SAMLConfig config = SAMLConfig.instance();
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String OPENSAML_NS = "http://www.opensaml.org";
    public static final String SAML_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String SAMLP_NS = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String SAML10_PROTOCOL_ENUM = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String SAML11_PROTOCOL_ENUM = "urn:oasis:names:tc:SAML:1.1:protocol";
    public static final String SAML_ARTIFACT_SOURCEID = "urn:oasis:names:tc:SAML:profiles:v1metadata";
    public static final String XMLSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SOAP11ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XML_SCHEMA_ID = "xml.xsd";
    public static final String SAML_SCHEMA_ID = "cs-sstc-schema-assertion-01.xsd";
    public static final String SAMLP_SCHEMA_ID = "cs-sstc-schema-protocol-01.xsd";
    public static final String SAML11_SCHEMA_ID = "cs-sstc-schema-assertion-1.1.xsd";
    public static final String SAMLP11_SCHEMA_ID = "cs-sstc-schema-protocol-1.1.xsd";
    public static final String XMLSIG_SCHEMA_ID = "xmldsig-core-schema.xsd";
    public static final String SOAP11ENV_SCHEMA_ID = "soap-envelope.xsd";
    private static Logger log = Logger.getLogger((String)XML.class.getName());
    public static ParserPool parserPool = new ParserPool();

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String assign(String string) {
        return string != null && string.length() > 0 ? string.trim() : null;
    }

    public static boolean safeCompare(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    public static boolean isElementNamed(Element element, String string, String string2) {
        return element != null && XML.safeCompare(string, element.getNamespaceURI()) && XML.safeCompare(string2, element.getLocalName());
    }

    public static Element getFirstChildElement(Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getLastChildElement(Node node) {
        Node node2;
        for (node2 = node.getLastChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getPreviousSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getFirstChildElement(Node node, String string, String string2) {
        Element element = XML.getFirstChildElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getNextSiblingElement(element);
        }
        return element;
    }

    public static Element getLastChildElement(Node node, String string, String string2) {
        Element element = XML.getLastChildElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getPreviousSiblingElement(element);
        }
        return element;
    }

    public static Element getNextSiblingElement(Node node) {
        Node node2;
        for (node2 = node.getNextSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getPreviousSiblingElement(Node node) {
        Node node2;
        for (node2 = node.getPreviousSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getPreviousSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String string, String string2) {
        Element element = XML.getNextSiblingElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getNextSiblingElement(element);
        }
        return element;
    }

    public static Element getPreviousSiblingElement(Node node, String string, String string2) {
        Element element = XML.getPreviousSiblingElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getPreviousSiblingElement(element);
        }
        return element;
    }

    public static QName getQNameAttribute(Element element, String string, String string2) {
        String string3 = XML.assign(element.getAttributeNS(string, string2));
        if (string3 == null) {
            return null;
        }
        return new QName(XML.getNamespaceForQName(string3, element), string3.substring(string3.indexOf(58) + 1));
    }

    public static QName getQNameTextNode(Text text) {
        String string = XML.assign(text.getNodeValue());
        Node node = text.getParentNode();
        if (string == null || node == null || node.getNodeType() != 1) {
            return null;
        }
        return new QName(XML.getNamespaceForQName(string, (Element)node), string.substring(string.indexOf(58) + 1));
    }

    public static String getNamespaceForQName(String string, Element element) {
        String string2 = null;
        if (string != null && string.indexOf(58) >= 0) {
            string2 = string.substring(0, string.indexOf(58));
        }
        return XML.getNamespaceForPrefix(string2, element);
    }

    public static String getNamespaceForPrefix(String string, Element element) {
        return element.lookupNamespaceURI(string);
    }

    public static class ParserPool
    implements ErrorHandler,
    EntityResolver {
        protected SAMLConfig config = SAMLConfig.instance();
        private Map pools = new HashMap();
        private Stack unparsedpool = new Stack();
        private Map extensions = new HashMap();
        private Schema defaultSchema = null;
        private Schema schemaSAML10 = null;
        private Schema schemaSAML11 = null;
        private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

        public synchronized void setDefaultSchema(Schema schema) {
            this.defaultSchema = schema;
        }

        public synchronized void setDefaultSchemas(Schema schema, Schema schema2) {
            this.schemaSAML10 = schema;
            this.schemaSAML11 = schema2;
            this.defaultSchema = SAMLConfig.instance().getBooleanProperty("org.opensaml.compatibility-mode") ? this.schemaSAML10 : this.schemaSAML11;
        }

        public synchronized Schema getDefaultSchema() {
            return this.defaultSchema;
        }

        public synchronized Schema getSchemaSAML10() {
            return this.schemaSAML10;
        }

        public synchronized Schema getSchemaSAML11() {
            return this.schemaSAML11;
        }

        public ParserPool() {
            this.dbf.setNamespaceAware(true);
            try {
                this.dbf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.warn((Object)("Unable to turn off data normalization in parser, supersignatures may fail with Xerces-J: " + parserConfigurationException));
            }
            this.registerSchemas(null);
        }

        public synchronized void registerSchemas(Map map) {
            Map.Entry entry;
            if (map != null) {
                this.extensions.putAll(map);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance(XML.XSD_NS);
            ArrayList<Source> arrayList = new ArrayList<Source>();
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xml.xsd"), XML.XML_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-core-schema.xsd"), XML.XMLSIG_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/soap-envelope.xsd"), XML.SOAP11ENV_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-01.xsd"), XML.SAML_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-01.xsd"), XML.SAMLP_SCHEMA_ID));
            Iterator iterator = this.extensions.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                try {
                    arrayList.add(new SAXSource(((EntityResolver)entry.getValue()).resolveEntity(null, (String)entry.getKey())));
                }
                catch (SAXException sAXException) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + sAXException));
                }
                catch (IOException iOException) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + iOException));
                }
            }
            try {
                this.schemaSAML10 = schemaFactory.newSchema(arrayList.toArray(new Source[0]));
            }
            catch (SAXException sAXException) {
                log.error((Object)("Unable to parse SAML 1.0 Schemas: " + sAXException));
            }
            arrayList.clear();
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xml.xsd"), XML.XML_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-core-schema.xsd"), XML.XMLSIG_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/soap-envelope.xsd"), XML.SOAP11ENV_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-1.1.xsd"), XML.SAML11_SCHEMA_ID));
            arrayList.add(new StreamSource((class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-1.1.xsd"), XML.SAMLP11_SCHEMA_ID));
            iterator = this.extensions.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                try {
                    arrayList.add(new SAXSource(((EntityResolver)entry.getValue()).resolveEntity(null, (String)entry.getKey())));
                }
                catch (SAXException sAXException) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + sAXException));
                }
                catch (IOException iOException) {
                    log.error((Object)("Unable to obtain extension schema (" + entry.getKey() + "): " + iOException));
                }
            }
            try {
                this.schemaSAML11 = schemaFactory.newSchema(arrayList.toArray(new Source[0]));
            }
            catch (SAXException sAXException) {
                log.error((Object)("Unable to parse SAML 1.1 Schemas: " + sAXException));
            }
            this.defaultSchema = SAMLConfig.instance().getBooleanProperty("org.opensaml.compatibility-mode") ? this.schemaSAML10 : this.schemaSAML11;
        }

        public synchronized DocumentBuilder get(Schema schema) throws SAMLException {
            Stack stack;
            DocumentBuilder documentBuilder = null;
            if (schema != null) {
                stack = (Stack)this.pools.get(schema);
                if (stack == null) {
                    stack = new Stack();
                    this.pools.put(schema, stack);
                }
            } else {
                stack = this.unparsedpool;
            }
            if (stack.empty()) {
                try {
                    this.dbf.setSchema(schema);
                    documentBuilder = this.dbf.newDocumentBuilder();
                    documentBuilder.setErrorHandler(this);
                    documentBuilder.setEntityResolver(this);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    log.error((Object)"Unable to obtain usable XML parser from environment");
                    throw new SAMLException("Unable to obtain usable XML parser from environment", (Exception)parserConfigurationException);
                }
            } else {
                documentBuilder = (DocumentBuilder)stack.pop();
            }
            return documentBuilder;
        }

        public DocumentBuilder get() throws SAMLException {
            return this.get(this.getDefaultSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document parse(InputSource inputSource, Schema schema) throws SAMLException, SAXException, IOException {
            DocumentBuilder documentBuilder = this.get(schema);
            try {
                Document document;
                Document document2 = document = documentBuilder.parse(inputSource);
                return document2;
            }
            finally {
                this.put(documentBuilder);
            }
        }

        public Document parse(InputStream inputStream) throws SAMLException, SAXException, IOException {
            return this.parse(new InputSource(inputStream), this.getDefaultSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document parse(String string, Schema schema) throws SAMLException, SAXException, IOException {
            DocumentBuilder documentBuilder = this.get(schema);
            try {
                Document document;
                Document document2 = document = documentBuilder.parse(new InputSource(string));
                return document2;
            }
            finally {
                this.put(documentBuilder);
            }
        }

        public Document parse(String string) throws SAMLException, SAXException, IOException {
            return this.parse(string, this.getDefaultSchema());
        }

        public Document newDocument() {
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = this.get();
            }
            catch (SAMLException sAMLException) {
                return null;
            }
            Document document = documentBuilder.newDocument();
            this.put(documentBuilder);
            return document;
        }

        public synchronized void put(DocumentBuilder documentBuilder) {
            Schema schema = documentBuilder.getSchema();
            if (schema == null) {
                this.unparsedpool.push(documentBuilder);
            } else {
                Stack stack = (Stack)this.pools.get(schema);
                stack.push(documentBuilder);
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            log.warn((Object)("Parser warning: line = " + sAXParseException.getLineNumber() + " : uri = " + sAXParseException.getSystemId()));
            log.warn((Object)("Parser warning (root cause): " + sAXParseException.getMessage()));
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return new InputSource();
        }
    }
}

