/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.directory;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.client.methods.DirectoryManagerAPI;
import org.nuxeo.client.objects.ConnectableEntity;

public class DirectoryEntry
extends ConnectableEntity<DirectoryManagerAPI, DirectoryEntry> {
    public static final String ID_PROPERTY = "id";
    public static final String LABEL_PROPERTY = "label";
    public static final String ORDERING_PROPERTY = "ordering";
    public static final String OBSOLETE_PROPERTY = "obsolete";
    protected String id;
    protected String directoryName;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public DirectoryEntry() {
        super("directoryEntry", DirectoryManagerAPI.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        if (this.nuxeoClient != null && this.nuxeoClient.getServerVersion().isGreaterThan("9.3-SNAPSHOT")) {
            return this.id;
        }
        Object idProperty = this.getIdProperty();
        return idProperty == null ? null : String.valueOf(idProperty);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ?> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public <T> T getProperty(String key) {
        return (T)(this.properties == null ? null : this.properties.get(key));
    }

    public <T> T putProperty(String key, T value) {
        return (T)this.properties.put(key, value);
    }

    @JsonIgnore
    public <T> T getIdProperty() {
        return this.getProperty(ID_PROPERTY);
    }

    @JsonIgnore
    public <T> T putIdProperty(T value) {
        return this.putProperty(ID_PROPERTY, value);
    }

    @JsonIgnore
    public String getLabelProperty() {
        return (String)this.getProperty(LABEL_PROPERTY);
    }

    @JsonIgnore
    public String putLabelProperty(String value) {
        return this.putProperty(LABEL_PROPERTY, value);
    }

    @JsonIgnore
    public Long getOrderingProperty() {
        return (Long)this.getProperty(ORDERING_PROPERTY);
    }

    @JsonIgnore
    public Integer putOrderingProperty(Integer value) {
        return this.putProperty(ORDERING_PROPERTY, value);
    }

    @JsonIgnore
    public Integer getObsoleteProperty() {
        return (Integer)this.getProperty(OBSOLETE_PROPERTY);
    }

    @JsonIgnore
    public Integer putObsoleteProperty(Integer value) {
        return this.putProperty(OBSOLETE_PROPERTY, value);
    }

    public DirectoryEntry update() {
        return this.fetchResponse(((DirectoryManagerAPI)this.api).updateDirectoryEntry(this.directoryName, this.getId(), this));
    }

    public void delete() {
        this.fetchResponse(((DirectoryManagerAPI)this.api).deleteDirectoryEntry(this.directoryName, this.getId()));
    }
}

